/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.title;

import bibliothek.gui.Dockable;
import bibliothek.gui.ToolbarExtension;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.title.AbstractDockTitle;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class ToolbarDockTitleGrip
extends AbstractDockTitle {
    private Color backgroundColor = UIManager.getColor("Button.background");
    private Color gripShadowColor = Color.gray;
    private Color gripColor = Color.white;

    public static DockTitleFactory createFactory(final Color color, final Color color2, final Color color3) {
        return new DockTitleFactory(){

            @Override
            public void uninstall(DockTitleRequest dockTitleRequest) {
            }

            @Override
            public void request(DockTitleRequest dockTitleRequest) {
                dockTitleRequest.answer(new ToolbarDockTitleGrip(dockTitleRequest.getVersion(), dockTitleRequest.getTarget(), color, color2, color3));
            }

            @Override
            public void install(DockTitleRequest dockTitleRequest) {
            }
        };
    }

    public static DockTitleFactory createFactory() {
        return new DockTitleFactory(){

            @Override
            public void uninstall(DockTitleRequest dockTitleRequest) {
            }

            @Override
            public void request(DockTitleRequest dockTitleRequest) {
                dockTitleRequest.answer(new ToolbarDockTitleGrip(dockTitleRequest.getVersion(), dockTitleRequest.getTarget()));
            }

            @Override
            public void install(DockTitleRequest dockTitleRequest) {
            }
        };
    }

    public ToolbarDockTitleGrip(DockTitleVersion dockTitleVersion, Dockable dockable, Color color, Color color2, Color color3) {
        super(dockable, dockTitleVersion, true);
        this.backgroundColor = color;
        this.gripColor = color2;
        this.gripShadowColor = color3;
    }

    public ToolbarDockTitleGrip(DockTitleVersion dockTitleVersion, Dockable dockable) {
        super(dockable, dockTitleVersion, true);
    }

    @Override
    protected BasicTitleViewItem<JComponent> createItemFor(DockAction dockAction, Dockable dockable) {
        return dockable.getController().getActionViewConverter().createView(dockAction, ToolbarExtension.TOOLBAR_TITLE, dockable);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.max(5, dimension.width), Math.max(5, dimension.height));
    }

    @Override
    public void setActive(boolean bl) {
        super.setActive(bl);
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.getOrientation().isHorizontal()) {
            int n = this.getSize().width;
            graphics.setColor(this.gripColor);
            graphics.drawLine(5, 3, n - 5, 3);
            graphics.drawLine(5, 4, n - 5, 4);
            graphics.setColor(this.gripShadowColor);
            graphics.drawLine(n - 5 + 1, 3, n - 5 + 1, 5);
            graphics.drawLine(5, 5, n - 5, 5);
        } else {
            int n = this.getSize().height;
            graphics.setColor(this.gripColor);
            graphics.drawLine(3, 5, 3, n - 5);
            graphics.drawLine(4, 5, 4, n - 5);
            graphics.setColor(this.gripShadowColor);
            graphics.drawLine(3, n - 5 + 1, 5, n - 5 + 1);
            graphics.drawLine(5, 5, 5, n - 5);
        }
    }
}

