/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.wizard;

import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.split.Divideable;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.wizard.WizardSplitDockStation;
import java.awt.Rectangle;

public class CellDivider
implements Divideable {
    private WizardSplitDockStation station;
    private Leaf leaf;

    public CellDivider(WizardSplitDockStation wizardSplitDockStation, Leaf leaf) {
        this.station = wizardSplitDockStation;
        this.leaf = leaf;
    }

    public Leaf getLeaf() {
        return this.leaf;
    }

    @Override
    public double getDividerAt(int n, int n2) {
        Rectangle rectangle = this.leaf.getBounds();
        int n3 = this.station.getDividerSize();
        switch (this.station.getSide()) {
            case LEFT: 
            case RIGHT: {
                return (double)(n2 - rectangle.y + n3 / 2) / (double)(rectangle.height + n3 / 2);
            }
            case BOTTOM: 
            case TOP: {
                return (double)(n - rectangle.x + n3 / 2) / (double)(rectangle.width + n3 / 2);
            }
        }
        throw new IllegalArgumentException("unknown side: " + (Object)((Object)this.station.getSide()));
    }

    @Override
    public Rectangle getDividerBounds(double d, Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        Rectangle rectangle2 = this.leaf.getBounds();
        int n = this.station.getDividerSize();
        switch (this.station.getSide()) {
            case LEFT: 
            case RIGHT: {
                rectangle.x = rectangle2.x;
                rectangle.width = rectangle2.width;
                rectangle.height = n;
                rectangle.y = (int)(d * (double)(rectangle2.height + n / 2) + (double)rectangle2.y - (double)(n / 2));
                return rectangle;
            }
            case BOTTOM: 
            case TOP: {
                rectangle.y = rectangle2.y;
                rectangle.height = rectangle2.height;
                rectangle.width = n;
                rectangle.x = (int)(d * (double)(rectangle2.width + n / 2) + (double)rectangle2.x - (double)(n / 2));
                return rectangle;
            }
        }
        throw new IllegalArgumentException("unknown side: " + (Object)((Object)this.station.getSide()));
    }

    @Override
    public SplitDockStation.Orientation getOrientation() {
        switch (this.station.getSide()) {
            case LEFT: 
            case RIGHT: {
                return SplitDockStation.Orientation.VERTICAL;
            }
            case BOTTOM: 
            case TOP: {
                return SplitDockStation.Orientation.HORIZONTAL;
            }
        }
        throw new IllegalStateException("unknown side: " + (Object)((Object)this.station.getSide()));
    }

    @Override
    public double getDivider() {
        return 1.0;
    }

    @Override
    public double getActualDivider() {
        return this.getDivider();
    }

    @Override
    public void setDivider(double d) {
    }

    @Override
    public double validateDivider(double d) {
        return this.station.getWizardSplitLayoutManager().validateDivider(d, this.leaf);
    }
}

