/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.ToolbarDockStation;
import bibliothek.gui.dock.station.span.Span;
import bibliothek.gui.dock.station.span.SpanCallback;
import bibliothek.gui.dock.station.span.SpanMode;
import bibliothek.gui.dock.station.span.SpanUsage;
import bibliothek.gui.dock.themes.StationSpanFactoryValue;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;

public abstract class SpanToolbarLayoutManager
implements LayoutManager2 {
    private ToolbarDockStation station;
    private Container parent;
    private Span[] spans = new Span[0];
    private StationSpanFactoryValue factory;
    private int size;
    private int index = -1;
    private int gap = 3;
    private int sideGap = 5;

    public SpanToolbarLayoutManager(ToolbarDockStation toolbarDockStation, Container container) {
        this.parent = container;
        this.station = toolbarDockStation;
        this.factory = new StationSpanFactoryValue("dock.spanFactory.toolbar", toolbarDockStation){

            @Override
            protected void changed() {
                SpanToolbarLayoutManager.this.reset();
            }
        };
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("gap must not be smaller than 0");
        }
        this.gap = n;
    }

    public int getSideGap() {
        return this.sideGap;
    }

    public void setSideGap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("sideGap must not be smaller than 0");
        }
        this.sideGap = n;
    }

    public void setController(DockController dockController) {
        this.factory.setController(dockController);
    }

    public int getInsertionIndex(int n, int n2) {
        Component component;
        int n3;
        int n4;
        if (this.station.getDockableCount() == 0) {
            return 0;
        }
        int[] nArray = new int[this.parent.getComponentCount()];
        if (this.station.getOrientation() == Orientation.HORIZONTAL) {
            n4 = n;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                component = this.parent.getComponent(n3);
                nArray[n3] = component.getX() + component.getWidth() / 2;
            }
        } else {
            n4 = n2;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                component = this.parent.getComponent(n3);
                nArray[n3] = component.getY() + component.getHeight() / 2;
            }
        }
        for (n3 = 0; n3 < nArray.length; ++n3) {
            if (n4 > nArray[n3]) continue;
            return n3;
        }
        return nArray.length;
    }

    public void setSpanSize(Dockable dockable) {
        Dimension dimension = dockable.getComponent().getPreferredSize();
        int n = this.station.getOrientation() == Orientation.HORIZONTAL ? dimension.width : dimension.height;
        if (this.size != n) {
            this.size = n;
            for (Span span : this.spans) {
                span.configureSize(SpanMode.OPEN, n);
            }
        }
    }

    public void setExpandedSpan(int n, boolean bl) {
        block6: {
            if (this.index == n) break block6;
            this.index = n;
            if (bl) {
                for (int i = 0; i < this.spans.length; ++i) {
                    if (i == n) {
                        this.spans[i].mutate(SpanMode.OPEN);
                        continue;
                    }
                    this.spans[i].mutate(SpanMode.OFF);
                }
            } else {
                for (int i = 0; i < this.spans.length; ++i) {
                    if (i == n) {
                        this.spans[i].set(SpanMode.OPEN);
                        continue;
                    }
                    this.spans[i].set(SpanMode.OFF);
                }
            }
        }
    }

    protected abstract void revalidate();

    private void reset() {
        this.index = -1;
        int n = this.station.getDockableCount() + 1;
        if (this.spans.length != n) {
            SpanCallback spanCallback = new SpanCallback(){

                @Override
                public DockStation getStation() {
                    return SpanToolbarLayoutManager.this.station;
                }

                @Override
                public boolean isHorizontal() {
                    return SpanToolbarLayoutManager.this.station.getOrientation() == Orientation.HORIZONTAL;
                }

                @Override
                public boolean isVertical() {
                    return SpanToolbarLayoutManager.this.station.getOrientation() == Orientation.VERTICAL;
                }

                @Override
                public void resized() {
                    SpanToolbarLayoutManager.this.revalidate();
                }

                @Override
                public SpanUsage getUsage() {
                    return SpanUsage.INSERTING;
                }
            };
            this.spans = new Span[n];
            for (int i = 0; i < n; ++i) {
                this.spans[i] = this.factory.create(spanCallback);
                this.spans[i].configureSize(SpanMode.OPEN, this.size);
            }
        }
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.reset();
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.reset();
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = 0;
        int n2 = 0;
        if (insets != null) {
            n += insets.left + insets.right;
            n2 += insets.top + insets.bottom;
        }
        if (this.station.getOrientation() == Orientation.HORIZONTAL) {
            int n3 = 0;
            int n4 = 0;
            int n5 = container.getComponentCount();
            for (int i = 0; i < n5; ++i) {
                Component component = container.getComponent(i);
                Dimension object = component.getPreferredSize();
                n3 += object.width;
                n3 = i == 0 ? (n3 += this.sideGap) : (n3 += this.gap);
                n4 = Math.max(n4, object.height);
            }
            n3 += this.sideGap;
            for (Span span : this.spans) {
                n3 += span.getSize();
            }
            return new Dimension(n3 + n, n4 + 2 * this.sideGap + n2);
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = container.getComponentCount();
        for (int i = 0; i < n8; ++i) {
            Component component = container.getComponent(i);
            Dimension dimension = component.getPreferredSize();
            n7 += dimension.height;
            n7 = i == 0 ? (n7 += this.sideGap) : (n7 += this.gap);
            n6 = Math.max(n6, dimension.width);
        }
        n7 += this.sideGap;
        for (Span span : this.spans) {
            n7 += span.getSize();
        }
        return new Dimension(n6 + 2 * this.sideGap + n, n7 + n2);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = 0;
        int n2 = 0;
        int n3 = container.getWidth();
        int n4 = container.getHeight();
        if (insets != null) {
            n = insets.left;
            n2 = insets.top;
            n3 -= insets.left + insets.right;
            n4 -= insets.top + insets.bottom;
            n3 = Math.max(n3, 1);
            n4 = Math.max(n4, 1);
        }
        if (this.station.getOrientation() == Orientation.HORIZONTAL) {
            int n5 = container.getComponentCount();
            for (int i = 0; i < n5; ++i) {
                int n6 = 0;
                if (i < this.spans.length) {
                    n6 = this.spans[i].getSize();
                }
                n += n6;
                n = i == 0 ? (n += this.sideGap) : (n += this.gap);
                Component component = container.getComponent(i);
                Dimension dimension = component.getPreferredSize();
                component.setBounds(n, n2 + this.sideGap, dimension.width, n4 - 2 * this.sideGap);
                n += dimension.width;
            }
        } else {
            int n7 = container.getComponentCount();
            for (int i = 0; i < n7; ++i) {
                int n8 = 0;
                if (i < this.spans.length) {
                    n8 = this.spans[i].getSize();
                }
                n2 += n8;
                n2 = i == 0 ? (n2 += this.sideGap) : (n2 += this.gap);
                Component component = container.getComponent(i);
                Dimension dimension = component.getPreferredSize();
                component.setBounds(n + this.sideGap, n2, n3 - 2 * this.sideGap, dimension.height);
                n2 += dimension.height;
            }
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        this.reset();
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }
}

