/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.wizard;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.split.Divideable;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.wizard.CellDivider;
import bibliothek.gui.dock.wizard.ColumnDividier;
import bibliothek.gui.dock.wizard.PersistentCell;
import bibliothek.gui.dock.wizard.PersistentColumn;
import bibliothek.gui.dock.wizard.WizardNodeMap;
import bibliothek.gui.dock.wizard.WizardSplitDockStation;
import java.awt.Dimension;
import java.awt.Insets;

public class WizardColumnModel {
    private WizardSplitDockStation station;
    private double factorW;
    private double factorH;
    private PersistentColumn[] persistentColumns;

    public WizardColumnModel(WizardSplitDockStation wizardSplitDockStation) {
        this(wizardSplitDockStation, -1.0, -1.0);
    }

    public WizardColumnModel(WizardSplitDockStation wizardSplitDockStation, double d, double d2) {
        this.station = wizardSplitDockStation;
        this.factorH = d2;
        this.factorW = d;
    }

    public void setFactors(double d, double d2) {
        this.factorW = d;
        this.factorH = d2;
    }

    private WizardSplitDockStation.Side side() {
        return this.station.getSide();
    }

    private int gap(int n) {
        return this.station.getWizardSpanStrategy().getGap(n);
    }

    private int gap(int n, int n2) {
        return this.station.getWizardSpanStrategy().getGap(n, n2);
    }

    private int gap(Node node, WizardNodeMap wizardNodeMap) {
        return this.station.getWizardSpanStrategy().getGap(node, wizardNodeMap);
    }

    private int gap() {
        return this.station.getDividerSize();
    }

    public Leaf[] getLastLeafOfColumns() {
        return this.getMap().getLastLeafOfColumns();
    }

    public PersistentColumn[] getPersistentColumns() {
        return this.getMap().getPersistentColumns();
    }

    public boolean isHeaderLevel(SplitNode splitNode) {
        return this.getMap().isHeaderLevel(splitNode);
    }

    public boolean isHeaderLevel(SplitNode splitNode, boolean bl) {
        return this.getMap().isHeaderLevel(splitNode, bl);
    }

    protected WizardNodeMap getMap() {
        return new WizardNodeMap(this.station, this.persistentColumns){

            @Override
            protected void handlePersistentColumnsAdapted(PersistentColumn[] persistentColumnArray) {
                WizardColumnModel.access$002(WizardColumnModel.this, persistentColumnArray);
            }
        };
    }

    public Dimension getPreferredSize() {
        Object object;
        PersistentColumn[] persistentColumnArray = this.getMap().getPersistentColumns();
        int n = 0;
        int n2 = 20;
        for (int i = 0; i < persistentColumnArray.length; ++i) {
            object = persistentColumnArray[i];
            n += ((PersistentColumn)object).getSize();
            n += this.gap(i);
            int n3 = 0;
            int n4 = 0;
            for (PersistentCell persistentCell : ((PersistentColumn)object).getCells().values()) {
                n3 += persistentCell.getSize();
                n3 += this.gap(i, n4);
                ++n4;
            }
            n2 = Math.max(n2, n3 += this.gap(i, n4));
        }
        n += this.gap(persistentColumnArray.length);
        if (this.station.getDockableCount() > 0) {
            n += this.station.getSideGap();
        }
        Dimension dimension = this.side().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL ? new Dimension(n, n2) : new Dimension(n2, n);
        object = this.station.getContentPane().getInsets();
        if (object != null) {
            dimension.width += ((Insets)object).left + ((Insets)object).right;
            dimension.height += ((Insets)object).top + ((Insets)object).bottom;
        }
        return dimension;
    }

    public void setPersistentColumns(Dockable[][] dockableArray, int[][] nArray, int[] nArray2) {
        WizardNodeMap wizardNodeMap = this.getMap();
        PersistentColumn[] persistentColumnArray = wizardNodeMap.getPersistentColumns();
        for (int i = 0; i < dockableArray.length; ++i) {
            block1: for (int j = 0; j < dockableArray[i].length; ++j) {
                Dockable dockable = dockableArray[i][j];
                if (dockable == null) continue;
                for (PersistentColumn persistentColumn : persistentColumnArray) {
                    PersistentCell persistentCell = persistentColumn.getCells().get(dockable);
                    if (persistentCell == null) continue;
                    persistentCell.setSize(nArray[i][j]);
                    persistentColumn.setSize(nArray2[i]);
                    continue block1;
                }
            }
        }
        this.applyPersistentSizes(wizardNodeMap, true);
    }

    public void setDivider(Divideable divideable, double d) {
        PersistentCell persistentCell;
        WizardNodeMap wizardNodeMap = this.getMap();
        if (divideable instanceof Node) {
            Node node = (Node)divideable;
            WizardNodeMap.Column column = this.side() == WizardSplitDockStation.Side.RIGHT || this.side() == WizardSplitDockStation.Side.BOTTOM ? wizardNodeMap.getHeadColumn(node.getRight()) : wizardNodeMap.getHeadColumn(node.getLeft());
            if (column != null) {
                this.setDivider(wizardNodeMap, column, node.getDivider(), d, node.getSize());
            } else {
                PersistentCell persistentCell2 = wizardNodeMap.getHeadCell(node.getLeft());
                if (persistentCell2 != null) {
                    double d2 = d - node.getDivider();
                    int n = this.side().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL ? (int)(d2 * (double)node.getSize().height) : (int)(d2 * (double)node.getSize().width);
                    persistentCell2.setSize(persistentCell2.getSize() + n);
                    this.applyPersistentSizes(wizardNodeMap, true);
                } else {
                    node.setDivider(d);
                }
            }
        } else if (divideable instanceof ColumnDividier) {
            WizardNodeMap.Column column = wizardNodeMap.getHeadColumn(this.station.getRoot());
            if (column != null) {
                this.setDivider(wizardNodeMap, column, divideable.getDivider(), d, this.station.getSize());
            }
        } else if (divideable instanceof CellDivider && (persistentCell = wizardNodeMap.getHeadCell(((CellDivider)divideable).getLeaf())) != null) {
            double d3 = d - divideable.getDivider();
            int n = (int)(d3 * (double)persistentCell.getSize());
            persistentCell.setSize(persistentCell.getSize() + n);
            this.applyPersistentSizes(wizardNodeMap, true);
        }
    }

    private void setDivider(WizardNodeMap wizardNodeMap, WizardNodeMap.Column column, double d, double d2, Dimension dimension) {
        PersistentColumn persistentColumn = column.getPersistentColumn();
        double d3 = this.side() == WizardSplitDockStation.Side.RIGHT || this.side() == WizardSplitDockStation.Side.BOTTOM ? d - d2 : d2 - d;
        int n = this.side().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL ? (int)(d3 * (double)dimension.width) : (int)(d3 * (double)dimension.height);
        persistentColumn.setSize(persistentColumn.getSize() + n);
        this.applyPersistentSizes(wizardNodeMap, true);
    }

    public void resetToPreferredSizes() {
        WizardNodeMap wizardNodeMap = this.getMap();
        for (PersistentColumn persistentColumn : wizardNodeMap.getPersistentColumns()) {
            persistentColumn.setSize(persistentColumn.getPreferredSize());
            for (PersistentCell persistentCell : persistentColumn.getCells().values()) {
                persistentCell.setSize(persistentCell.getPreferredSize());
            }
        }
        this.applyPersistentSizes(wizardNodeMap, true);
    }

    public void resetToPreferredSize(int n) {
        PersistentColumn persistentColumn = this.getMap().getPersistentColumn(n);
        persistentColumn.setSize(persistentColumn.getPreferredSize());
    }

    protected int applyPersistentSizes(WizardNodeMap wizardNodeMap, boolean bl) {
        int n = this.applyPersistentSizes(this.station.getRoot(), wizardNodeMap);
        if (bl) {
            this.station.revalidateOutside();
        }
        return n;
    }

    private int applyPersistentSizes(SplitNode splitNode, WizardNodeMap wizardNodeMap) {
        WizardNodeMap.Column column = wizardNodeMap.getColumn(splitNode, false);
        if (column != null) {
            this.applyPersistentSizes(column.getRoot(), column.getPersistentColumn(), wizardNodeMap);
            PersistentColumn persistentColumn = column.getPersistentColumn();
            if (persistentColumn == null) {
                return 0;
            }
            return persistentColumn.getSize();
        }
        if (splitNode instanceof Root) {
            return this.applyPersistentSizes(((Root)splitNode).getChild(), wizardNodeMap);
        }
        if (splitNode instanceof Node) {
            int n = this.applyPersistentSizes(((Node)splitNode).getLeft(), wizardNodeMap);
            int n2 = this.applyPersistentSizes(((Node)splitNode).getRight(), wizardNodeMap);
            int n3 = this.gap((Node)splitNode, wizardNodeMap);
            ((Node)splitNode).setDivider((double)(n + n3 / 2) / (double)(n + n2 + n3));
            return n + n3 + n2;
        }
        return 0;
    }

    private int applyPersistentSizes(SplitNode splitNode, PersistentColumn persistentColumn, WizardNodeMap wizardNodeMap) {
        PersistentCell persistentCell;
        if (splitNode instanceof Root) {
            return this.applyPersistentSizes(((Root)splitNode).getChild(), persistentColumn, wizardNodeMap);
        }
        if (splitNode instanceof Node) {
            Node node = (Node)splitNode;
            int n = this.applyPersistentSizes(node.getLeft(), persistentColumn, wizardNodeMap);
            int n2 = this.applyPersistentSizes(node.getRight(), persistentColumn, wizardNodeMap);
            if (node.getLeft() == null || !node.getLeft().isVisible()) {
                return n2;
            }
            if (node.getRight() == null || !node.getRight().isVisible()) {
                return n;
            }
            int n3 = this.gap((Node)splitNode, wizardNodeMap);
            ((Node)splitNode).setDivider((double)(n + n3 / 2) / (double)(n + n2 + n3));
            return n + n3 + n2;
        }
        if (splitNode instanceof Leaf && (persistentCell = persistentColumn.getCells().get(((Leaf)splitNode).getDockable())) != null) {
            return persistentCell.getSize();
        }
        return 0;
    }

    public void updateBounds(double d, double d2) {
        double d3 = 1.0;
        double d4 = 1.0;
        int n = this.gap(0);
        WizardNodeMap wizardNodeMap = this.getMap();
        int n2 = wizardNodeMap.getColumns().size();
        if (this.side().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
            d += (double)n / this.factorW;
            d3 -= (double)n / this.factorW;
            if (n2 > 0) {
                d3 -= (double)this.gap(n2) / this.factorW;
            }
        } else {
            d2 += (double)n / this.factorH;
            d4 -= (double)n / this.factorH;
            if (n2 > 0) {
                d4 -= (double)this.gap(n2) / this.factorH;
            }
        }
        int n3 = this.station.getSideGap();
        switch (this.station.getSide()) {
            case RIGHT: {
                d += (double)n3 / this.factorW;
            }
            case LEFT: {
                d3 -= (double)n3 / this.factorW;
                break;
            }
            case BOTTOM: {
                d2 += (double)n3 / this.factorH;
            }
            case TOP: {
                d4 -= (double)n3 / this.factorH;
            }
        }
        Root root = this.station.getRoot();
        root.updateBounds(d, d2, d3, d4, this.factorW, this.factorH, false);
        int n4 = this.applyPersistentSizes(wizardNodeMap, false);
        if (this.station.getSide().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
            d3 = (double)n4 / this.factorW;
        } else {
            d4 = (double)n4 / this.factorH;
        }
        this.updateBounds(this.station.getRoot(), d, d2, d3, d4, wizardNodeMap);
    }

    protected void updateBounds(SplitNode splitNode, double d, double d2, double d3, double d4, WizardNodeMap wizardNodeMap) {
        if (splitNode != null && splitNode.isVisible()) {
            WizardNodeMap.Column column = wizardNodeMap.getColumn(splitNode, false);
            if (column != null) {
                this.updateBounds(d, d2, d3, d4, column, wizardNodeMap);
            } else {
                this.updateBoundsRecursive(splitNode, d, d2, d3, d4, wizardNodeMap);
            }
        }
    }

    protected void updateBounds(double d, double d2, double d3, double d4, WizardNodeMap.Column column, WizardNodeMap wizardNodeMap) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (PersistentCell persistentCell : column.getPersistentColumn().getCells().values()) {
            n += persistentCell.getSize();
            n3 += this.gap(column.getIndex(), n2);
            ++n2;
        }
        n3 += this.gap(column.getIndex(), n2);
        int n4 = this.gap(column.getIndex(), 0);
        int n5 = column.getCellCount();
        if (this.side().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
            double d5 = d4 * this.factorH - (double)n3;
            if ((double)n < (d5 = Math.max(d5, 0.0))) {
                d4 = (double)n / this.factorH + (double)n3 / this.factorH;
            }
            d2 += (double)n4 / this.factorH;
            d4 -= (double)n4 / this.factorH;
            if (n5 > 0) {
                d4 -= (double)this.gap(column.getIndex(), n5) / this.factorH;
            }
        } else {
            double d6 = d3 * this.factorW - (double)n3;
            if ((double)n < (d6 = Math.max(d6, 0.0))) {
                d3 = (double)n / this.factorW + (double)n3 / this.factorW;
            }
            d += (double)n4 / this.factorW;
            d3 -= (double)n4 / this.factorW;
            if (n5 > 0) {
                d3 -= (double)this.gap(column.getIndex(), n5) / this.factorW;
            }
        }
        this.updateBoundsRecursive(column.getRoot(), d, d2, d3, d4, wizardNodeMap);
    }

    protected void updateBoundsRecursive(SplitNode splitNode, double d, double d2, double d3, double d4, WizardNodeMap wizardNodeMap) {
        if (splitNode != null && splitNode.isVisible()) {
            if (splitNode instanceof Root) {
                this.updateBounds(((Root)splitNode).getChild(), d, d2, d3, d4, wizardNodeMap);
            } else if (splitNode instanceof Node) {
                Node node = (Node)splitNode;
                if (node.getLeft() != null && node.getLeft().isVisible() && node.getRight() != null && node.getRight().isVisible()) {
                    if (node.getOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
                        double d5 = this.factorW > 0.0 ? Math.max(0.0, (double)this.gap(node, wizardNodeMap) / this.factorW) : 0.0;
                        double d6 = d3 * node.getDivider();
                        this.updateBounds(node.getLeft(), d, d2, d6 - d5 / 2.0, d4, wizardNodeMap);
                        this.updateBounds(node.getRight(), d + d6 + d5 / 2.0, d2, d3 - d6 - d5 / 2.0, d4, wizardNodeMap);
                    } else {
                        double d7 = this.factorH > 0.0 ? Math.max(0.0, (double)this.gap(node, wizardNodeMap) / this.factorH) : 0.0;
                        double d8 = d4 * node.getDivider();
                        this.updateBounds(node.getLeft(), d, d2, d3, d8 - d7 / 2.0, wizardNodeMap);
                        this.updateBounds(node.getRight(), d, d2 + d8 + d7 / 2.0, d3, d4 - d8 - d7 / 2.0, wizardNodeMap);
                    }
                } else {
                    this.updateBounds(node.getLeft(), d, d2, d3, d4, wizardNodeMap);
                    this.updateBounds(node.getRight(), d, d2, d3, d4, wizardNodeMap);
                }
            }
            splitNode.setBounds(d, d2, d3, d4, this.factorW, this.factorH, true);
        }
    }

    public double validateDivider(double d, Node node) {
        return this.validateDivider(d, node, this.getMap());
    }

    public double validateDivider(double d, Leaf leaf) {
        return this.validateDivider(d, leaf, this.getMap());
    }

    public double validateColumnDivider(double d) {
        return this.validateColumnDivider(d, this.getMap());
    }

    private double validateDivider(double d, Node node, WizardNodeMap wizardNodeMap) {
        WizardNodeMap.Column column = wizardNodeMap.getColumn(node, true);
        if (column == null) {
            return this.validateHeadNode(d, node, wizardNodeMap);
        }
        return this.validateDivider(column, d, node, wizardNodeMap);
    }

    private double validateDivider(double d, Leaf leaf, WizardNodeMap wizardNodeMap) {
        WizardNodeMap.Column column = wizardNodeMap.getColumn(leaf, true);
        if (column != null) {
            return this.validateDivider(column, d, leaf, wizardNodeMap);
        }
        return d;
    }

    private double validateColumnDivider(double d, WizardNodeMap wizardNodeMap) {
        int n;
        WizardNodeMap.Column column = wizardNodeMap.getOutermostColumn();
        if (column == null) {
            return d;
        }
        int n2 = 0;
        int n3 = this.gap();
        if (this.side().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
            for (WizardNodeMap.Column column2 : wizardNodeMap.getColumns().values()) {
                n2 += column2.getRoot().getSize().width + n3;
            }
            n2 -= column.getRoot().getSize().width + n3;
            n2 += column.getMinimumSize().width;
            n = this.station.getWidth() - n3;
        } else {
            for (WizardNodeMap.Column column3 : wizardNodeMap.getColumns().values()) {
                n2 += column3.getRoot().getSize().height + n3;
            }
            n2 -= column.getRoot().getSize().height + n3;
            n2 += column.getMinimumSize().height;
            n = this.station.getHeight() - n3;
        }
        if (this.side() == WizardSplitDockStation.Side.RIGHT || this.side() == WizardSplitDockStation.Side.BOTTOM) {
            double d2 = 1.0 - (double)(n2 + this.gap() / 2) / (double)(n + this.gap());
            return Math.min(d2, d);
        }
        double d3 = (double)(n2 + this.gap() / 2) / (double)(n + this.gap());
        return Math.max(d3, d);
    }

    private double validateHeadNode(double d, Node node, WizardNodeMap wizardNodeMap) {
        int n;
        int n2;
        if (this.side() == WizardSplitDockStation.Side.RIGHT || this.side() == WizardSplitDockStation.Side.BOTTOM ? d < node.getDivider() : d > node.getDivider()) {
            return d;
        }
        WizardNodeMap.Column column = this.side() == WizardSplitDockStation.Side.RIGHT || this.side() == WizardSplitDockStation.Side.BOTTOM ? wizardNodeMap.getHeadColumn(node.getRight()) : wizardNodeMap.getHeadColumn(node.getLeft());
        if (column == null) {
            return d;
        }
        if (this.side().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
            n2 = column.getMinimumSize().width + this.gap();
            n = node.getSize().width;
        } else {
            n2 = column.getMinimumSize().height + this.gap();
            n = node.getSize().height;
        }
        if (this.side() == WizardSplitDockStation.Side.RIGHT || this.side() == WizardSplitDockStation.Side.BOTTOM) {
            double d2 = 1.0 - (double)(n2 + this.gap() / 2) / (double)(n + this.gap());
            return Math.min(d2, d);
        }
        double d3 = (double)(n2 + this.gap() / 2) / (double)(n + this.gap());
        return Math.max(d3, d);
    }

    public double validateDivider(WizardNodeMap.Column column, double d, Node node, WizardNodeMap wizardNodeMap) {
        int n;
        int n2;
        if (d > node.getDivider()) {
            return d;
        }
        WizardNodeMap.Cell cell = column.getRightmostCell(node.getLeft());
        if (cell == null) {
            return d;
        }
        if (this.side().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
            n2 = node.getLeft().getSize().height - cell.getNode().getSize().height + cell.getMinimumSize().height;
            n = node.getSize().height;
        } else {
            n2 = node.getLeft().getSize().width - cell.getNode().getSize().width + cell.getMinimumSize().width;
            n = node.getSize().width;
        }
        double d2 = (double)(n2 + this.gap() / 2) / (double)(n + this.gap());
        return Math.max(d2, d);
    }

    public double validateDivider(WizardNodeMap.Column column, double d, Leaf leaf, WizardNodeMap wizardNodeMap) {
        int n;
        int n2;
        WizardNodeMap.Cell cell = column.getRightmostCell(leaf);
        if (cell == null) {
            return d;
        }
        if (this.side().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
            n2 = cell.getMinimumSize().height + this.gap();
            n = leaf.getSize().height;
        } else {
            n2 = cell.getMinimumSize().width + this.gap();
            n = leaf.getSize().width;
        }
        double d2 = (double)(n2 + this.gap() / 2) / (double)(n + this.gap());
        return Math.max(d2, d);
    }

    static /* synthetic */ PersistentColumn[] access$002(WizardColumnModel wizardColumnModel, PersistentColumn[] persistentColumnArray) {
        wizardColumnModel.persistentColumns = persistentColumnArray;
        return persistentColumnArray;
    }
}

