/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.ImageComponent;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.Texture;
import org.jogamp.java3d.TextureCubeMap;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.NodeComponentState;
import org.jogamp.vecmath.Color4f;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3f;

public abstract class TextureState
extends NodeComponentState {
    private int[] imageComponents;
    protected int width;
    protected int height;
    protected int format;
    protected int mipMapMode;
    protected int boundaryWidth;

    public TextureState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null && !(this.node instanceof TextureCubeMap)) {
            ImageComponent[] images = ((Texture)this.node).getImages();
            this.imageComponents = new int[images.length];
            int i = 0;
            while (i < images.length) {
                this.imageComponents[i] = control.getSymbolTable().addReference((SceneGraphObject)images[i]);
                ++i;
            }
        }
    }

    @Override
    public void writeConstructorParams(DataOutput out) throws IOException {
        super.writeConstructorParams(out);
        out.writeInt(((Texture)this.node).getMipMapMode());
        out.writeInt(((Texture)this.node).getWidth());
        out.writeInt(((Texture)this.node).getHeight());
        out.writeInt(((Texture)this.node).getFormat());
        out.writeInt(((Texture)this.node).getBoundaryWidth());
    }

    @Override
    public void readConstructorParams(DataInput in) throws IOException {
        super.readConstructorParams(in);
        this.mipMapMode = in.readInt();
        this.width = in.readInt();
        this.height = in.readInt();
        this.format = in.readInt();
        this.boundaryWidth = in.readInt();
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        Texture attr = (Texture)this.node;
        Color4f clr = new Color4f();
        attr.getBoundaryColor(clr);
        this.control.writeColor4f(out, clr);
        out.writeInt(attr.getBoundaryModeS());
        out.writeInt(attr.getBoundaryModeT());
        out.writeBoolean(attr.getEnable());
        out.writeInt(this.imageComponents.length);
        int i = 0;
        while (i < this.imageComponents.length) {
            out.writeInt(this.imageComponents[i]);
            ++i;
        }
        out.writeInt(attr.getMagFilter());
        out.writeInt(attr.getMinFilter());
        out.writeInt(attr.getBaseLevel());
        out.writeInt(attr.getMaximumLevel());
        out.writeFloat(attr.getMinimumLOD());
        out.writeFloat(attr.getMaximumLOD());
        Point3f lodOffset = new Point3f();
        attr.getLodOffset((Tuple3f)lodOffset);
        this.control.writePoint3f(out, lodOffset);
        out.writeInt(attr.getAnisotropicFilterMode());
        out.writeFloat(attr.getAnisotropicFilterDegree());
        int points = attr.getSharpenTextureFuncPointsCount();
        out.writeInt(points);
        if (points > 0) {
            float[] lod = new float[points];
            float[] pts = new float[points];
            attr.getSharpenTextureFunc(lod, pts);
            int i2 = 0;
            while (i2 < points) {
                out.writeFloat(lod[i2]);
                out.writeFloat(pts[i2]);
                ++i2;
            }
        }
        points = attr.getFilter4FuncPointsCount();
        out.writeInt(points);
        if (points >= 4) {
            float[] weights = new float[points];
            attr.getFilter4Func(weights);
            int i3 = 0;
            while (i3 < points) {
                out.writeFloat(weights[i3]);
                ++i3;
            }
        }
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        Texture attr = (Texture)this.node;
        attr.setBoundaryColor(this.control.readColor4f(in));
        attr.setBoundaryModeS(in.readInt());
        attr.setBoundaryModeT(in.readInt());
        attr.setEnable(in.readBoolean());
        this.imageComponents = new int[in.readInt()];
        int i = 0;
        while (i < this.imageComponents.length) {
            this.imageComponents[i] = in.readInt();
            ++i;
        }
        int mag = in.readInt();
        try {
            attr.setMagFilter(mag);
        }
        catch (IllegalArgumentException e) {
            if (mag == 5) {
                attr.setMagFilter(3);
            }
            if (mag == 4) {
                attr.setMagFilter(2);
            }
            attr.setMagFilter(0);
        }
        attr.setMinFilter(in.readInt());
        attr.setBaseLevel(in.readInt());
        attr.setMaximumLevel(in.readInt());
        attr.setMinimumLOD(in.readFloat());
        attr.setMaximumLOD(in.readFloat());
        attr.setLodOffset((Tuple3f)this.control.readPoint3f(in));
        attr.setAnisotropicFilterMode(in.readInt());
        attr.setAnisotropicFilterDegree(in.readFloat());
        int points = in.readInt();
        if (points > 0) {
            float[] lod = new float[points];
            float[] pts = new float[points];
            int i2 = 0;
            while (i2 < points) {
                lod[i2] = in.readFloat();
                pts[i2] = in.readFloat();
                ++i2;
            }
            attr.setSharpenTextureFunc(lod, pts);
        }
        if ((points = in.readInt()) >= 4) {
            float[] weights = new float[points];
            int i3 = 0;
            while (i3 < points) {
                weights[i3] = in.readFloat();
                ++i3;
            }
            attr.setFilter4Func(weights);
        }
    }

    @Override
    public void addSubReference() {
        if (!(this.node instanceof TextureCubeMap)) {
            int i = 0;
            while (i < this.imageComponents.length) {
                this.control.getSymbolTable().incNodeComponentRefCount(this.imageComponents[i]);
                ++i;
            }
        }
    }

    @Override
    public void buildGraph() {
        if (!(this.node instanceof TextureCubeMap)) {
            int i = 0;
            while (i < this.imageComponents.length) {
                ((Texture)this.node).setImage(i, (ImageComponent)this.control.getSymbolTable().getJ3dNode(this.imageComponents[i]));
                ++i;
            }
        }
        super.buildGraph();
    }
}

