__constant float epsilon = 0.0001f;
__constant float tolerance = 0.0001f;

kernel void belongsToVolume(__global const float4* listPoints, __global float* results, const int numPoints, __global const float* volumeParamBuffer)
{
   // get index into global data array
   int iGID = get_global_id(0);
   // bound check (equivalent to the limit on a 'for' loop for standard/serial C code
   if (iGID >= numPoints)
   {
      return;
   }
   float3 lePoint = listPoints[iGID].xyz;
   float3 areteNormalisee;
   float3 P1;
   float longueurArete;
   
   float3 O = (float3)(volumeParamBuffer[0], volumeParamBuffer[1], volumeParamBuffer[2]);
   float3 U = (float3)(volumeParamBuffer[3], volumeParamBuffer[4], volumeParamBuffer[5]);
   float3 V = (float3)(volumeParamBuffer[6], volumeParamBuffer[7], volumeParamBuffer[8]);
   float3 N = (float3)(volumeParamBuffer[9], volumeParamBuffer[10], volumeParamBuffer[11]);
   float uMin = volumeParamBuffer[12];
   float vMin = volumeParamBuffer[13];
   float uMax = volumeParamBuffer[14];
   float vMax = volumeParamBuffer[15];
   float height = volumeParamBuffer[16];
   int nbVertices = (int)volumeParamBuffer[17]; 
   
   int i0 = 18;
   int paramUnitSize = 7;
   
   float3 OP = lePoint-O;
   float scalU = dot(OP, U);
   float scalV = dot(OP, V);
   float scalN = dot(OP, N);
   results[4*iGID] = lePoint.x;
   results[4*iGID+1] = lePoint.y;
   results[4*iGID+2] = lePoint.z;
   if ((scalU<uMin)||(scalU>uMax)||(scalV<vMin)||(scalV>vMax)||(scalN<0)||(scalN>height))
   {
      results[4*iGID+3] = 0;
      return;
   }
   float3 lePointProj = (float3)(O.x + scalU*U.x + scalV*V.x, O.y + scalU*U.y + scalV*V.y, O.z + scalU*U.z + scalV*V.z);
   int nbIntersections = 0;
   int startInd;
   for (int i=0; i<nbVertices; i++)
   {
      //-----------------------------------------------------------
      //CALCUL POUR UNE ARETE
      //-----------------------------------------------------------
      startInd = i0+i*paramUnitSize;
      P1 = (float3)(volumeParamBuffer[startInd+0], volumeParamBuffer[startInd+1], volumeParamBuffer[startInd+2]);
      areteNormalisee = (float3)(volumeParamBuffer[startInd+3], volumeParamBuffer[startInd+4], volumeParamBuffer[startInd+5]);
      longueurArete = volumeParamBuffer[startInd+6];
 
      if (longueurArete>epsilon)
      {
         //-----------------------------------------------------------
         //TEST D'INTERSECTION AVEC UN SEGMENT
         //-----------------------------------------------------------
         float scal = dot(U, areteNormalisee);
         if (fabs(fabs(scal)-1.f)<epsilon)
         {
         }
         else
         {
            //Cas général
            float3 crossProd = cross(U, areteNormalisee);
            float norm = length(crossProd);
            crossProd /= norm;
            float3 w = cross(U, crossProd);
            float3 PP1 = P1 - lePointProj;
            float dist = dot(PP1, crossProd);
            if (fabs(dist)<tolerance)
            {
               float dotWithW = dot(areteNormalisee, w);
               float lambda = -(PP1.x*w.x+PP1.y*w.y+PP1.z*w.z)/dotWithW;
               if ((lambda>=0.0)&&(lambda<=longueurArete))
               {
                  float dotWithU = dot(areteNormalisee, U);
                  float mu = (PP1.x*U.x+PP1.y*U.y+PP1.z*U.z) + lambda*dotWithU;
                  if (mu>=0.0)
                  {
                     nbIntersections = nbIntersections+1;
                  }
               }
            }
         }
      }
   }
   //-----------------------------------------------------------
   //LE POINT APPARTIENT AU POLYGONE SI LE NOMBRE D'INTERSECTIONS EST IMPAIR
   //-----------------------------------------------------------
   if (nbIntersections%2 != 0)
   {
      results[4*iGID+3] = 1;
   }
   else
   {
      results[4*iGID+3] = 0;
   }
}
}
}
