/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.oculusvr;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import com.jogamp.oculusvr.ovrVector2f;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDataInfoRuntime;

public class ovrDistortionVertex {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] ovrDistortionVertex_size = new int[]{40, 40, 40, 40, 40, 40, 40, 40, 40, 40};
    private static final int[] ScreenPosNDC_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] ScreenPosNDC_size = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final int[] TimeWarpFactor_offset = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final int[] VignetteFactor_offset = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    private static final int[] TanEyeAnglesR_offset = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
    private static final int[] TanEyeAnglesR_size = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final int[] TanEyeAnglesG_offset = new int[]{24, 24, 24, 24, 24, 24, 24, 24, 24, 24};
    private static final int[] TanEyeAnglesG_size = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final int[] TanEyeAnglesB_offset = new int[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
    private static final int[] TanEyeAnglesB_size = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8};

    public static int size() {
        return ovrDistortionVertex_size[mdIdx];
    }

    public static ovrDistortionVertex create() {
        return ovrDistortionVertex.create(Buffers.newDirectByteBuffer(ovrDistortionVertex.size()));
    }

    public static ovrDistortionVertex create(ByteBuffer byteBuffer) {
        return new ovrDistortionVertex(byteBuffer);
    }

    ovrDistortionVertex(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[ovrDistortionVertex.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public ovrVector2f getScreenPosNDC() {
        return ovrVector2f.create(this.accessor.slice(ScreenPosNDC_offset[mdIdx], ScreenPosNDC_size[mdIdx]));
    }

    public ovrDistortionVertex setTimeWarpFactor(float f) {
        this.accessor.setFloatAt(TimeWarpFactor_offset[mdIdx], f);
        return this;
    }

    public float getTimeWarpFactor() {
        return this.accessor.getFloatAt(TimeWarpFactor_offset[mdIdx]);
    }

    public ovrDistortionVertex setVignetteFactor(float f) {
        this.accessor.setFloatAt(VignetteFactor_offset[mdIdx], f);
        return this;
    }

    public float getVignetteFactor() {
        return this.accessor.getFloatAt(VignetteFactor_offset[mdIdx]);
    }

    public ovrVector2f getTanEyeAnglesR() {
        return ovrVector2f.create(this.accessor.slice(TanEyeAnglesR_offset[mdIdx], TanEyeAnglesR_size[mdIdx]));
    }

    public ovrVector2f getTanEyeAnglesG() {
        return ovrVector2f.create(this.accessor.slice(TanEyeAnglesG_offset[mdIdx], TanEyeAnglesG_size[mdIdx]));
    }

    public ovrVector2f getTanEyeAnglesB() {
        return ovrVector2f.create(this.accessor.slice(TanEyeAnglesB_offset[mdIdx], TanEyeAnglesB_size[mdIdx]));
    }
}

