/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.displayer.DisplayerRequest;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.OrientationObserver;
import bibliothek.gui.dock.station.OrientedDockStation;
import bibliothek.gui.dock.station.toolbar.ToolbarLineBorder;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayer;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.Transparency;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class ToolbarDockableDisplayer
extends BasicDockableDisplayer {
    public static final DisplayerFactory FACTORY = new DisplayerFactory(){

        @Override
        public void request(DisplayerRequest displayerRequest) {
            ToolbarDockableDisplayer toolbarDockableDisplayer = new ToolbarDockableDisplayer(displayerRequest.getParent(), displayerRequest.getTarget(), displayerRequest.getTitle());
            toolbarDockableDisplayer.setDefaultBorderHint(false);
            toolbarDockableDisplayer.setRespectBorderHint(true);
            displayerRequest.answer(toolbarDockableDisplayer);
        }
    };
    private OrientationObserver observer;
    private JPanel dockable;
    private BasicDockableDisplayer.DisplayerBorder toolbarBorder;

    public ToolbarDockableDisplayer(DockStation dockStation, Dockable dockable, DockTitle dockTitle) {
        super(dockStation);
        this.setTransparency(Transparency.TRANSPARENT);
        this.setDockable(dockable);
        this.setTitle(dockTitle);
    }

    @Override
    protected Component getComponent(Dockable dockable) {
        this.ensureDockable();
        return this.dockable;
    }

    private void ensureDockable() {
        if (this.dockable == null) {
            this.dockable = new JPanel(new GridLayout(1, 1));
            this.dockable.setOpaque(false);
            this.toolbarBorder = new BasicDockableDisplayer.DisplayerBorder(this, this.dockable, "toolbar");
        }
    }

    @Override
    protected Border getDefaultBorder() {
        return new ToolbarLineBorder(this);
    }

    @Override
    protected void updateBorder() {
        if (this.isSingleTabShowing()) {
            super.updateBorder();
        } else {
            this.ensureDockable();
            this.setBaseBorder(null);
            this.setContentBorder(null);
            boolean bl = this.isRespectBorderHint() ? this.getHints().getShowBorderHint() : this.getDefaultBorderHint();
            if (bl) {
                this.toolbarBorder.setBorder(this.getDefaultBorder());
            } else {
                this.toolbarBorder.setBorder(null);
            }
        }
    }

    @Override
    public void setController(DockController dockController) {
        super.setController(dockController);
        this.toolbarBorder.setController(dockController);
    }

    @Override
    public void setDockable(Dockable dockable) {
        Dockable dockable2 = this.getDockable();
        if (dockable2 != dockable) {
            if (this.observer != null) {
                this.observer.destroy();
                this.observer = null;
            }
            super.setDockable(dockable);
            this.ensureDockable();
            this.dockable.removeAll();
            if (dockable != null) {
                this.dockable.add(dockable.getComponent());
                this.observer = new OrientationObserver(dockable){

                    @Override
                    protected void orientationChanged(Orientation orientation) {
                        ToolbarDockableDisplayer.this.setOrientation(orientation);
                    }
                };
                this.setOrientation(this.getOrientation());
            }
        }
    }

    @Override
    public Insets getDockableInsets() {
        Insets insets = super.getDockableInsets();
        Border border = this.dockable.getBorder();
        if (border != null) {
            Insets insets2 = border.getBorderInsets(this.dockable);
            insets.left += insets2.left;
            insets.right += insets2.right;
            insets.top += insets2.top;
            insets.bottom += insets2.bottom;
        }
        return insets;
    }

    protected Orientation getOrientation() {
        Object object;
        if (this.observer != null && (object = this.observer.getOrientation()) != null) {
            return object;
        }
        object = this.getDockable();
        if (object == null) {
            return null;
        }
        if (object instanceof OrientedDockStation) {
            return ((OrientedDockStation)object).getOrientation();
        }
        return null;
    }

    protected void setOrientation(Orientation orientation) {
        if (orientation != null) {
            if (orientation == Orientation.HORIZONTAL) {
                this.setTitleLocation(DockableDisplayer.Location.LEFT);
            } else {
                this.setTitleLocation(DockableDisplayer.Location.TOP);
            }
        }
    }
}

