/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.toolbar.expand;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ExpandableToolbarItemStrategy;
import bibliothek.gui.dock.control.DockRegister;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockRegisterListener;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItem;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItemListener;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItemStrategyListener;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import java.util.ArrayList;
import java.util.List;

public class DefaultExpandableToolbarItemStrategy
implements ExpandableToolbarItemStrategy {
    private final List<ExpandableToolbarItemStrategyListener> listeners = new ArrayList<ExpandableToolbarItemStrategyListener>();
    private DockController controller;
    private final DockRegisterListener registerListener = new DockRegisterAdapter(){

        @Override
        public void dockStationRegistered(DockController dockController, DockStation dockStation) {
            DefaultExpandableToolbarItemStrategy.this.handleAdd(dockStation);
        }

        @Override
        public void dockableRegistered(DockController dockController, Dockable dockable) {
            DefaultExpandableToolbarItemStrategy.this.handleAdd(dockable);
        }

        @Override
        public void dockStationUnregistered(DockController dockController, DockStation dockStation) {
            DefaultExpandableToolbarItemStrategy.this.handleRemove(dockStation);
        }

        @Override
        public void dockableUnregistered(DockController dockController, Dockable dockable) {
            DefaultExpandableToolbarItemStrategy.this.handleRemove(dockable);
        }
    };
    private final ExpandableToolbarItemListener expandableListener = new ExpandableToolbarItemListener(){

        @Override
        public void changed(ExpandableToolbarItem expandableToolbarItem, ExpandedState expandedState, ExpandedState expandedState2) {
            DefaultExpandableToolbarItemStrategy.this.fire(expandableToolbarItem, expandedState2);
        }

        @Override
        public void enablementChanged(ExpandableToolbarItem expandableToolbarItem, ExpandedState expandedState, boolean bl) {
            for (ExpandableToolbarItemStrategyListener expandableToolbarItemStrategyListener : DefaultExpandableToolbarItemStrategy.this.listeners()) {
                expandableToolbarItemStrategyListener.enablementChanged(expandableToolbarItem, expandedState, bl);
            }
        }
    };

    protected void handleAdd(Dockable dockable) {
        if (dockable.asDockStation() == null && dockable instanceof ExpandableToolbarItem) {
            ExpandableToolbarItem expandableToolbarItem = (ExpandableToolbarItem)dockable;
            expandableToolbarItem.addExpandableListener(this.expandableListener);
            this.fire(expandableToolbarItem);
        }
    }

    protected void handleAdd(DockStation dockStation) {
        if (dockStation instanceof ExpandableToolbarItem) {
            ExpandableToolbarItem expandableToolbarItem = (ExpandableToolbarItem)((Object)dockStation);
            expandableToolbarItem.addExpandableListener(this.expandableListener);
            this.fire(expandableToolbarItem);
        }
    }

    private void fire(ExpandableToolbarItem expandableToolbarItem) {
        this.fire(expandableToolbarItem, this.getState(expandableToolbarItem));
        for (ExpandedState expandedState : ExpandedState.values()) {
            boolean bl = this.isEnabled(expandableToolbarItem, expandedState);
            for (ExpandableToolbarItemStrategyListener expandableToolbarItemStrategyListener : this.listeners()) {
                expandableToolbarItemStrategyListener.enablementChanged(expandableToolbarItem, expandedState, bl);
            }
        }
    }

    private void fire(ExpandableToolbarItem expandableToolbarItem, ExpandedState expandedState) {
        switch (expandedState) {
            case EXPANDED: {
                for (ExpandableToolbarItemStrategyListener expandableToolbarItemStrategyListener : this.listeners()) {
                    expandableToolbarItemStrategyListener.expanded(expandableToolbarItem);
                }
                break;
            }
            case SHRUNK: {
                for (ExpandableToolbarItemStrategyListener expandableToolbarItemStrategyListener : this.listeners()) {
                    expandableToolbarItemStrategyListener.shrunk(expandableToolbarItem);
                }
                break;
            }
            case STRETCHED: {
                for (ExpandableToolbarItemStrategyListener expandableToolbarItemStrategyListener : this.listeners()) {
                    expandableToolbarItemStrategyListener.stretched(expandableToolbarItem);
                }
                break;
            }
        }
    }

    protected void handleRemove(Dockable dockable) {
        if (dockable.asDockStation() == null && dockable instanceof ExpandableToolbarItem) {
            ((ExpandableToolbarItem)dockable).removeExpandableListener(this.expandableListener);
        }
    }

    protected void handleRemove(DockStation dockStation) {
        if (dockStation instanceof ExpandableToolbarItem) {
            ((ExpandableToolbarItem)((Object)dockStation)).addExpandableListener(this.expandableListener);
        }
    }

    @Override
    public void install(DockController dockController) {
        if (this.controller != null) {
            throw new IllegalStateException("this strategy is already installed");
        }
        this.controller = dockController;
        DockRegister dockRegister = dockController.getRegister();
        dockRegister.addDockRegisterListener(this.registerListener);
        int n = dockRegister.getStationCount();
        for (int i = 0; i < n; ++i) {
            this.handleAdd(dockRegister.getStation(i));
        }
    }

    @Override
    public void uninstall(DockController dockController) {
        if (this.controller != dockController) {
            throw new IllegalStateException("this strategy is not installed at '" + dockController + "'");
        }
        DockRegister dockRegister = dockController.getRegister();
        dockRegister.removeDockRegisterListener(this.registerListener);
        int n = dockRegister.getStationCount();
        for (int i = 0; i < n; ++i) {
            this.handleRemove(dockRegister.getStation(i));
        }
    }

    @Override
    public boolean isEnabled(Dockable dockable, ExpandedState expandedState) {
        if (dockable instanceof ExpandableToolbarItem) {
            return ((ExpandableToolbarItem)dockable).isEnabled(expandedState);
        }
        return false;
    }

    @Override
    public ExpandedState getState(Dockable dockable) {
        if (dockable instanceof ExpandableToolbarItem) {
            return ((ExpandableToolbarItem)dockable).getExpandedState();
        }
        return null;
    }

    @Override
    public void setState(Dockable dockable, ExpandedState expandedState) {
        ((ExpandableToolbarItem)dockable).setExpandedState(expandedState);
    }

    @Override
    public void addExpandedListener(ExpandableToolbarItemStrategyListener expandableToolbarItemStrategyListener) {
        if (expandableToolbarItemStrategyListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(expandableToolbarItemStrategyListener);
    }

    @Override
    public void removeExpandedListener(ExpandableToolbarItemStrategyListener expandableToolbarItemStrategyListener) {
        this.listeners.remove(expandableToolbarItemStrategyListener);
    }

    protected ExpandableToolbarItemStrategyListener[] listeners() {
        return this.listeners.toArray(new ExpandableToolbarItemStrategyListener[this.listeners.size()]);
    }
}

