
    kernel void testFunction(global const float4* listPoints, global int* arePointsInside, float r, int numPoints, int nbIter) {

        // get index into global data array
        int iGID = get_global_id(0);
        int trueR = 1;
        int falseR = 0;

        // bound check (equivalent to the limit on a 'for' loop for standard/serial C code
        if (iGID >= numPoints)  {
            return;
        }

		float x = listPoints[iGID].x;
		float y = listPoints[iGID].y;
		float z = listPoints[iGID].z;
		float length = 0;
		for (int i=0; i<nbIter; i++)
		{
			length += sqrt(x*x+y*y+z*z);
		}
		length = length/nbIter;
		arePointsInside[iGID] = (int)(length <= r);
    }