/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.LineAttributesRetained;
import org.jogamp.java3d.NodeComponent;

public class LineAttributes
extends NodeComponent {
    public static final int ALLOW_WIDTH_READ = 0;
    public static final int ALLOW_WIDTH_WRITE = 1;
    public static final int ALLOW_PATTERN_READ = 2;
    public static final int ALLOW_PATTERN_WRITE = 3;
    public static final int ALLOW_ANTIALIASING_READ = 4;
    public static final int ALLOW_ANTIALIASING_WRITE = 5;
    public static final int PATTERN_SOLID = 0;
    public static final int PATTERN_DASH = 1;
    public static final int PATTERN_DOT = 2;
    public static final int PATTERN_DASH_DOT = 3;
    public static final int PATTERN_USER_DEFINED = 4;
    private static final int[] readCapabilities = new int[]{4, 2, 0};

    public LineAttributes() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public LineAttributes(float lineWidth, int linePattern, boolean lineAntialiasing) {
        if (linePattern < 0 || linePattern > 3) {
            throw new IllegalArgumentException(J3dI18N.getString("LineAttributes0"));
        }
        this.setDefaultReadCapabilities(readCapabilities);
        ((LineAttributesRetained)this.retained).initLineWidth(lineWidth);
        ((LineAttributesRetained)this.retained).initLinePattern(linePattern);
        ((LineAttributesRetained)this.retained).initLineAntialiasingEnable(lineAntialiasing);
    }

    public void setLineWidth(float lineWidth) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LineAttributes1"));
        }
        if (this.isLive()) {
            ((LineAttributesRetained)this.retained).setLineWidth(lineWidth);
        } else {
            ((LineAttributesRetained)this.retained).initLineWidth(lineWidth);
        }
    }

    public float getLineWidth() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LineAttributes2"));
        }
        return ((LineAttributesRetained)this.retained).getLineWidth();
    }

    public void setLinePattern(int linePattern) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LineAttributes3"));
        }
        if (linePattern < 0 || linePattern > 4) {
            throw new IllegalArgumentException(J3dI18N.getString("LineAttributes4"));
        }
        if (this.isLive()) {
            ((LineAttributesRetained)this.retained).setLinePattern(linePattern);
        } else {
            ((LineAttributesRetained)this.retained).initLinePattern(linePattern);
        }
    }

    public int getLinePattern() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LineAttributes5"));
        }
        return ((LineAttributesRetained)this.retained).getLinePattern();
    }

    public void setPatternMask(int mask) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LineAttributes8"));
        }
        if (this.isLive()) {
            ((LineAttributesRetained)this.retained).setPatternMask(mask);
        } else {
            ((LineAttributesRetained)this.retained).initPatternMask(mask);
        }
    }

    public int getPatternMask() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LineAttributes9"));
        }
        return ((LineAttributesRetained)this.retained).getPatternMask();
    }

    public void setPatternScaleFactor(int scaleFactor) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LineAttributes10"));
        }
        if (this.isLive()) {
            ((LineAttributesRetained)this.retained).setPatternScaleFactor(scaleFactor);
        } else {
            ((LineAttributesRetained)this.retained).initPatternScaleFactor(scaleFactor);
        }
    }

    public int getPatternScaleFactor() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LineAttributes11"));
        }
        return ((LineAttributesRetained)this.retained).getPatternScaleFactor();
    }

    public void setLineAntialiasingEnable(boolean state) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LineAttributes6"));
        }
        if (this.isLive()) {
            ((LineAttributesRetained)this.retained).setLineAntialiasingEnable(state);
        } else {
            ((LineAttributesRetained)this.retained).initLineAntialiasingEnable(state);
        }
    }

    public boolean getLineAntialiasingEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("LineAttributes7"));
        }
        return ((LineAttributesRetained)this.retained).getLineAntialiasingEnable();
    }

    @Override
    void createRetained() {
        this.retained = new LineAttributesRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        LineAttributes la = new LineAttributes();
        la.duplicateNodeComponent(this);
        return la;
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        LineAttributesRetained attr = (LineAttributesRetained)originalNodeComponent.retained;
        LineAttributesRetained rt = (LineAttributesRetained)this.retained;
        rt.initLineWidth(attr.getLineWidth());
        rt.initLinePattern(attr.getLinePattern());
        rt.initLineAntialiasingEnable(attr.getLineAntialiasingEnable());
        rt.initPatternMask(attr.getPatternMask());
        rt.initPatternScaleFactor(attr.getPatternScaleFactor());
    }
}

