/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.ToolbarContainerDockStation;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.PerspectivePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerConverter;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerConverterCallback;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerDockPerspective;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import java.util.Map;

public class DefaultToolbarContainerConverter
implements ToolbarContainerConverter {
    @Override
    public PlaceholderMap getPlaceholders(ToolbarContainerDockStation toolbarContainerDockStation) {
        PlaceholderMap placeholderMap = new PlaceholderMap(new Path("dock.ToolbarContainerStation"), 0);
        placeholderMap.put(placeholderMap.newKey("content", new Path[0]), "list", toolbarContainerDockStation.getDockables().toMap());
        return placeholderMap;
    }

    @Override
    public PlaceholderMap getPlaceholders(ToolbarContainerDockStation toolbarContainerDockStation, Map<Dockable, Integer> map) {
        PlaceholderMap placeholderMap = new PlaceholderMap(new Path("dock.ToolbarContainerStation"), 0);
        placeholderMap.put(placeholderMap.newKey("content", new Path[0]), "list", this.convert(toolbarContainerDockStation.getPlaceholderStrategy(), toolbarContainerDockStation.getDockables(), map));
        return placeholderMap;
    }

    @Override
    public PlaceholderMap getPlaceholders(ToolbarContainerDockPerspective toolbarContainerDockPerspective, Map<PerspectiveDockable, Integer> map) {
        PlaceholderMap placeholderMap = new PlaceholderMap(new Path("dock.ToolbarContainerStation"), 0);
        placeholderMap.put(placeholderMap.newKey("content", new Path[0]), "list", this.convert(toolbarContainerDockPerspective.getDockables(), map));
        return placeholderMap;
    }

    private PlaceholderMap convert(final PlaceholderStrategy placeholderStrategy, DockablePlaceholderList<StationChildHandle> dockablePlaceholderList, final Map<Dockable, Integer> map) {
        return dockablePlaceholderList.toMap(new PlaceholderListItemAdapter<Dockable, StationChildHandle>(){

            @Override
            public ConvertedPlaceholderListItem convert(int n, StationChildHandle stationChildHandle) {
                Path path;
                Dockable dockable = stationChildHandle.getDockable();
                ConvertedPlaceholderListItem convertedPlaceholderListItem = new ConvertedPlaceholderListItem();
                Integer n2 = (Integer)map.get(dockable);
                if (n2 == null) {
                    return null;
                }
                convertedPlaceholderListItem.putInt("id", n2);
                convertedPlaceholderListItem.putInt("index", n);
                if (placeholderStrategy != null && (path = placeholderStrategy.getPlaceholderFor(dockable)) != null) {
                    convertedPlaceholderListItem.putString("placeholder", path.toString());
                    convertedPlaceholderListItem.setPlaceholder(path);
                }
                return convertedPlaceholderListItem;
            }
        });
    }

    private PlaceholderMap convert(PerspectivePlaceholderList<PerspectiveDockable> perspectivePlaceholderList, final Map<PerspectiveDockable, Integer> map) {
        return perspectivePlaceholderList.toMap(new PlaceholderListItemAdapter<PerspectiveDockable, PerspectiveDockable>(){

            @Override
            public ConvertedPlaceholderListItem convert(int n, PerspectiveDockable perspectiveDockable) {
                ConvertedPlaceholderListItem convertedPlaceholderListItem = new ConvertedPlaceholderListItem();
                Integer n2 = (Integer)map.get(perspectiveDockable);
                if (n2 == null) {
                    return null;
                }
                convertedPlaceholderListItem.putInt("id", n2);
                convertedPlaceholderListItem.putInt("index", n);
                Path path = perspectiveDockable.getPlaceholder();
                if (path != null) {
                    convertedPlaceholderListItem.putString("placeholder", path.toString());
                    convertedPlaceholderListItem.setPlaceholder(path);
                }
                return convertedPlaceholderListItem;
            }
        });
    }

    @Override
    public void setPlaceholders(ToolbarContainerDockStation toolbarContainerDockStation, PlaceholderMap placeholderMap) {
        if (!placeholderMap.getFormat().equals(new Path("dock.ToolbarContainerStation"))) {
            throw new IllegalArgumentException("unknown format: " + placeholderMap.getFormat());
        }
        if (placeholderMap.getVersion() != 0) {
            throw new IllegalArgumentException("unknown version: " + placeholderMap.getVersion());
        }
        toolbarContainerDockStation.setPlaceholders(placeholderMap.getMap(placeholderMap.newKey("content", new Path[0]), "list"));
    }

    @Override
    public void setPlaceholders(ToolbarContainerDockStation toolbarContainerDockStation, ToolbarContainerConverterCallback toolbarContainerConverterCallback, PlaceholderMap placeholderMap, Map<Integer, Dockable> map) {
        this.convert(toolbarContainerDockStation, toolbarContainerConverterCallback, placeholderMap.getMap(placeholderMap.newKey("content", new Path[0]), "list"), map);
    }

    private void convert(final ToolbarContainerDockStation toolbarContainerDockStation, final ToolbarContainerConverterCallback toolbarContainerConverterCallback, PlaceholderMap placeholderMap, final Map<Integer, Dockable> map) {
        DockablePlaceholderList<StationChildHandle> dockablePlaceholderList = new DockablePlaceholderList<StationChildHandle>();
        toolbarContainerConverterCallback.setDockables(dockablePlaceholderList);
        dockablePlaceholderList.read(placeholderMap, new PlaceholderListItemAdapter<Dockable, StationChildHandle>(){
            private DockHierarchyLock.Token token;

            @Override
            public StationChildHandle convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                int n = convertedPlaceholderListItem.getInt("id");
                Dockable dockable = (Dockable)map.get(n);
                if (dockable == null) {
                    return null;
                }
                DockUtilities.ensureTreeValidity(toolbarContainerDockStation, dockable);
                this.token = DockHierarchyLock.acquireLinking(toolbarContainerDockStation, dockable);
                StationChildHandle stationChildHandle = toolbarContainerConverterCallback.wrap(dockable);
                toolbarContainerConverterCallback.adding(stationChildHandle);
                return stationChildHandle;
            }

            @Override
            public void added(StationChildHandle stationChildHandle) {
                try {
                    toolbarContainerConverterCallback.added(stationChildHandle);
                }
                finally {
                    this.token.release();
                }
            }
        });
        toolbarContainerConverterCallback.finished(dockablePlaceholderList);
    }
}

