/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.dock.layout.AbstractDockableProperty;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ToolbarProperty
extends AbstractDockableProperty {
    private int index;
    private Path placeholder;

    public ToolbarProperty() {
    }

    public ToolbarProperty(int n, Path path) {
        this.index = n;
        this.placeholder = path;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[index=" + this.index + ", placeholder=" + this.placeholder + ", successor=" + this.getSuccessor() + "]";
    }

    @Override
    public DockableProperty copy() {
        ToolbarProperty toolbarProperty = new ToolbarProperty(this.index, this.placeholder);
        DockableProperty dockableProperty = this.getSuccessor();
        if (dockableProperty != null) {
            toolbarProperty.setSuccessor(dockableProperty.copy());
        }
        return toolbarProperty;
    }

    public int getIndex() {
        return this.index;
    }

    public Path getPlaceholder() {
        return this.placeholder;
    }

    @Override
    public String getFactoryID() {
        return "ToolbarPropertyFactory";
    }

    @Override
    public void store(DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_1_1);
        dataOutputStream.writeInt(this.index);
        if (this.placeholder == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeUTF(this.placeholder.toString());
        }
    }

    @Override
    public void load(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        if (!version.equals(Version.VERSION_1_1_1)) {
            throw new IOException("data from an unknown version: " + version);
        }
        this.index = dataInputStream.readInt();
        this.placeholder = dataInputStream.readBoolean() ? new Path(dataInputStream.readUTF()) : null;
    }

    @Override
    public void store(XElement xElement) {
        xElement.addElement("index").setInt(this.index);
        if (this.placeholder != null) {
            xElement.addElement("placeholder").setString(this.placeholder.toString());
        }
    }

    @Override
    public void load(XElement xElement) {
        XElement xElement2 = xElement.getElement("index");
        XElement xElement3 = xElement.getElement("placeholder");
        if (xElement2 != null) {
            this.index = xElement2.getInt();
        }
        this.placeholder = xElement3 != null ? new Path(xElement3.getString()) : null;
    }
}

