/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.displayer.DisplayerCombinerTarget;
import bibliothek.gui.dock.station.StationDropItem;
import bibliothek.gui.dock.station.StationDropOperation;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.SplitDockAccess;
import bibliothek.gui.dock.station.support.CombinerTarget;

public class SplitDropOperation
implements StationDropOperation {
    private SplitDockAccess access;
    private PutInfo putInfo;
    private StationDropItem item;
    private boolean move;

    public SplitDropOperation(SplitDockAccess access, PutInfo putInfo, StationDropItem item, boolean move) {
        this.access = access;
        this.putInfo = putInfo;
        this.item = item;
        this.move = move;
    }

    public boolean isMove() {
        return this.move;
    }

    public void draw() {
        this.access.setDropInfo(this.putInfo);
    }

    public void destroy(StationDropOperation next) {
        if (this.access.getOwner().getDropInfo() == this.putInfo) {
            this.access.setDropInfo(null);
            if (next == null || !(next instanceof SplitDropOperation) || next.getTarget() != this.getTarget()) {
                this.access.unsetDropInfo();
            }
        }
    }

    public DockStation getTarget() {
        return this.access.getOwner();
    }

    public Dockable getItem() {
        return this.putInfo.getDockable();
    }

    public CombinerTarget getCombination() {
        return this.putInfo.getCombinerTarget();
    }

    public DisplayerCombinerTarget getDisplayerCombination() {
        CombinerTarget target = this.getCombination();
        if (target == null) {
            return null;
        }
        return target.getDisplayerCombination();
    }

    public void execute() {
        this.access.unsetDropInfo();
        if (this.isMove()) {
            this.access.move(this.putInfo, this.item);
        } else {
            this.access.drop(null, this.putInfo, this.item);
        }
    }
}

