#version 130
// simple fragment shader
uniform sampler2D tex;
uniform int isMasked;

out vec4 FragColor;
void main()
{
  vec2 tc0 = gl_TexCoord[0].xy;
  if(isMasked != 0){//masked
    vec4 sample = texture2D(tex, tc0).rgba;
    float gray = dot(sample.rgb, vec3(0.299, 0.587, 0.114));
    FragColor = vec4(vec3(gray), sample.a * 0.5);
  }else
	  FragColor = texture2D(tex, tc0).rgba;
  gl_FragDepth = 0.0000001;
}