/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen.magnet;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.station.screen.magnet.AttractorStrategy;
import bibliothek.gui.dock.station.screen.magnet.MagnetOperation;
import bibliothek.gui.dock.station.screen.magnet.MagnetRequest;
import bibliothek.gui.dock.station.screen.magnet.MagnetStrategy;
import bibliothek.gui.dock.station.screen.magnet.MagnetizedOperation;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.SilentPropertyValue;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MagnetController {
    private ScreenDockStation station;
    private Operation current;
    private PropertyValue<MagnetStrategy> strategy = new PropertyValue<MagnetStrategy>(ScreenDockStation.MAGNET_STRATEGY){

        @Override
        protected void valueChanged(MagnetStrategy oldValue, MagnetStrategy newValue) {
            if (oldValue != null) {
                oldValue.uninstall(MagnetController.this);
            }
            if (newValue != null) {
                newValue.install(MagnetController.this);
            }
        }
    };
    private PropertyValue<AttractorStrategy> attraction = new SilentPropertyValue<AttractorStrategy>(ScreenDockStation.ATTRACTOR_STRATEGY);
    private DockController controller;

    public MagnetController(ScreenDockStation station) {
        if (station == null) {
            throw new IllegalArgumentException("station must not be null");
        }
        this.station = station;
    }

    public void setController(DockController controller) {
        if (this.controller != controller) {
            this.controller = controller;
            this.strategy.setProperties(controller);
            this.attraction.setProperties(controller);
        }
    }

    public DockController getController() {
        return this.controller;
    }

    public ScreenDockStation getStation() {
        return this.station;
    }

    public MagnetizedOperation start(ScreenDockWindow window) {
        if (this.current != null) {
            this.current.stop();
        }
        this.current = new Operation(window);
        return this.current;
    }

    public AttractorStrategy.Attraction getAttraction(Dockable moved, Dockable fixed) {
        AttractorStrategy strategy = this.attraction.getValue();
        if (strategy == null) {
            return AttractorStrategy.Attraction.NEUTRAL;
        }
        return strategy.attract(this.station, moved, fixed);
    }

    public AttractorStrategy.Attraction getStickiness(Dockable moved, Dockable fixed) {
        AttractorStrategy strategy = this.attraction.getValue();
        if (strategy == null) {
            return AttractorStrategy.Attraction.NEUTRAL;
        }
        return strategy.stick(this.station, moved, fixed);
    }

    public ScreenDockWindow getCurrent() {
        if (this.current == null) {
            return null;
        }
        return this.current.getWindow();
    }

    public ScreenDockWindow[] getWindows() {
        int count = this.station.getDockableCount();
        ScreenDockWindow[] windows = new ScreenDockWindow[count];
        for (int i = 0; i < count; ++i) {
            windows[i] = this.station.getWindow(i);
        }
        return windows;
    }

    public ScreenDockWindow[] getAttracted(ScreenDockWindow window) {
        ArrayList<ScreenDockWindow> result = new ArrayList<ScreenDockWindow>();
        int count = this.station.getDockableCount();
        for (int i = 0; i < count; ++i) {
            ScreenDockWindow next = this.station.getWindow(i);
            if (next == window) continue;
            AttractorStrategy.Attraction attraction = this.getAttraction(window.getDockable(), next.getDockable());
            switch (attraction) {
                case STRONGLY_ATTRACTED: 
                case ATTRACTED: {
                    result.add(next);
                }
            }
        }
        return result.toArray(new ScreenDockWindow[result.size()]);
    }

    public int distance(ScreenDockWindow windowA, MagnetRequest.Side sideA, ScreenDockWindow windowB, MagnetRequest.Side sideB, boolean initialBoundaries) {
        if (sideA != sideB && (sideA == MagnetRequest.Side.NORTH || sideA == MagnetRequest.Side.SOUTH) != (sideB == MagnetRequest.Side.NORTH || sideB == MagnetRequest.Side.SOUTH)) {
            throw new IllegalArgumentException("sideA and sideB are neither equal nor opposite: " + (Object)((Object)sideA) + ", " + (Object)((Object)sideB));
        }
        int valueA = this.getValue(windowA, sideA, initialBoundaries);
        int valueB = this.getValue(windowB, sideB, initialBoundaries);
        return Math.abs(valueA - valueB);
    }

    public boolean intersectHorizontally(ScreenDockWindow windowA, ScreenDockWindow windowB, boolean initialBoundaries) {
        int yA1 = this.getValue(windowA, MagnetRequest.Side.NORTH, initialBoundaries);
        int yA2 = this.getValue(windowA, MagnetRequest.Side.SOUTH, initialBoundaries);
        int yB1 = this.getValue(windowB, MagnetRequest.Side.NORTH, initialBoundaries);
        int yB2 = this.getValue(windowB, MagnetRequest.Side.SOUTH, initialBoundaries);
        return this.between(yA1, yA2, yB1) || this.between(yA1, yA2, yB2) || this.between(yB1, yB2, yA1) || this.between(yB1, yB2, yA2);
    }

    public boolean intersectVertically(ScreenDockWindow windowA, ScreenDockWindow windowB, boolean initialBoundaries) {
        int xA1 = this.getValue(windowA, MagnetRequest.Side.WEST, initialBoundaries);
        int xA2 = this.getValue(windowA, MagnetRequest.Side.EAST, initialBoundaries);
        int xB1 = this.getValue(windowB, MagnetRequest.Side.WEST, initialBoundaries);
        int xB2 = this.getValue(windowB, MagnetRequest.Side.EAST, initialBoundaries);
        return this.between(xA1, xA2, xB1) || this.between(xA1, xA2, xB2) || this.between(xB1, xB2, xA1) || this.between(xB1, xB2, xA2);
    }

    private boolean between(int x1, int x2, int point) {
        return x1 <= point && point <= x2;
    }

    public int getValue(ScreenDockWindow window, MagnetRequest.Side side, boolean initialBoundaries) {
        if (initialBoundaries) {
            return this.getValue(this.current.getInitialBounds(window), side);
        }
        if (this.getCurrent() == window) {
            return this.getValue(this.current.getBounds(), side);
        }
        return this.getValue(window.getWindowBounds(), side);
    }

    public int getValue(Rectangle rectangle, MagnetRequest.Side side) {
        switch (side) {
            case NORTH: {
                return rectangle.y;
            }
            case SOUTH: {
                return rectangle.y + rectangle.height - 1;
            }
            case WEST: {
                return rectangle.x;
            }
            case EAST: {
                return rectangle.x + rectangle.width - 1;
            }
        }
        throw new IllegalStateException("unknown side: " + (Object)((Object)side));
    }

    public MagnetStrategy getStrategy() {
        return this.strategy.getValue();
    }

    public void setStrategy(MagnetStrategy strategy) {
        this.strategy.setValue(strategy);
    }

    public AttractorStrategy getAttractorStrategy() {
        return this.attraction.getValue();
    }

    public void setAttractorStrategy(AttractorStrategy strategy) {
        this.attraction.setValue(strategy);
    }

    private class Operation
    implements MagnetizedOperation,
    MagnetRequest {
        private ScreenDockWindow window;
        private Map<ScreenDockWindow, Rectangle> initialBoundaries = new HashMap<ScreenDockWindow, Rectangle>();
        private Rectangle baseBoundaries;
        private Rectangle resultBoundaries;
        private MagnetOperation operation;

        public Operation(ScreenDockWindow window) {
            this.window = window;
            for (ScreenDockWindow check : MagnetController.this.getWindows()) {
                this.initialBoundaries.put(check, check.getWindowBounds());
            }
        }

        public ScreenDockWindow getWindow() {
            return this.window;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.baseBoundaries);
        }

        public Rectangle getResultBounds() {
            return new Rectangle(this.resultBoundaries);
        }

        public Rectangle getInitialBounds(ScreenDockWindow window) {
            Rectangle bounds = this.initialBoundaries.get(window);
            if (bounds == null) {
                throw new IllegalArgumentException("window is unknown: " + window);
            }
            return new Rectangle(bounds);
        }

        public boolean isMoved() {
            return this.isNorth() && this.isSouth() || this.isEast() && this.isWest();
        }

        public boolean isResized() {
            Rectangle initialBoundaries = this.getInitialBounds(this.getWindow());
            return !this.isMoved() && !initialBoundaries.equals(this.baseBoundaries);
        }

        public boolean isNorth() {
            Rectangle initialBoundaries = this.getInitialBounds(this.getWindow());
            return initialBoundaries.y != this.baseBoundaries.y;
        }

        public boolean isSouth() {
            Rectangle initialBoundaries = this.getInitialBounds(this.getWindow());
            return initialBoundaries.y + initialBoundaries.height != this.baseBoundaries.y + this.baseBoundaries.height;
        }

        public boolean isWest() {
            Rectangle initialBoundaries = this.getInitialBounds(this.getWindow());
            return initialBoundaries.x != this.baseBoundaries.x;
        }

        public boolean isEast() {
            Rectangle initialBoundaries = this.getInitialBounds(this.getWindow());
            return initialBoundaries.x + initialBoundaries.width != this.baseBoundaries.x + this.baseBoundaries.width;
        }

        public boolean is(MagnetRequest.Side side) {
            switch (side) {
                case EAST: {
                    return this.isEast();
                }
                case WEST: {
                    return this.isWest();
                }
                case NORTH: {
                    return this.isNorth();
                }
                case SOUTH: {
                    return this.isSouth();
                }
            }
            throw new IllegalStateException("side unknown: " + (Object)((Object)side));
        }

        public void resizingAttraction(ScreenDockWindow neighbor, MagnetRequest.Side windowSide, MagnetRequest.Side neighborSide) {
            this.checkArguments(neighbor, windowSide, neighborSide);
            int neighborValue = MagnetController.this.getValue(neighbor.getWindowBounds(), neighborSide);
            int windowValue = MagnetController.this.getValue(this.resultBoundaries, windowSide);
            int delta = neighborValue - windowValue;
            if (windowSide != neighborSide) {
                switch (windowSide) {
                    case NORTH: 
                    case WEST: {
                        ++delta;
                        break;
                    }
                    case SOUTH: 
                    case EAST: {
                        --delta;
                    }
                }
            }
            switch (windowSide) {
                case NORTH: {
                    this.resultBoundaries.y += delta;
                    this.resultBoundaries.height -= delta;
                    break;
                }
                case SOUTH: {
                    this.resultBoundaries.height += delta;
                    break;
                }
                case WEST: {
                    this.resultBoundaries.x += delta;
                    this.resultBoundaries.width -= delta;
                    break;
                }
                case EAST: {
                    this.resultBoundaries.width += delta;
                }
            }
        }

        public void movingAttraction(ScreenDockWindow neighbor, MagnetRequest.Side windowSide, MagnetRequest.Side neighborSide) {
            this.checkArguments(neighbor, windowSide, neighborSide);
            int neighborValue = MagnetController.this.getValue(neighbor.getWindowBounds(), neighborSide);
            int windowValue = MagnetController.this.getValue(this.resultBoundaries, windowSide);
            int delta = neighborValue - windowValue;
            if (windowSide != neighborSide) {
                switch (windowSide) {
                    case NORTH: 
                    case WEST: {
                        ++delta;
                        break;
                    }
                    case SOUTH: 
                    case EAST: {
                        --delta;
                    }
                }
            }
            switch (windowSide) {
                case NORTH: 
                case SOUTH: {
                    this.resultBoundaries.y += delta;
                    break;
                }
                case WEST: 
                case EAST: {
                    this.resultBoundaries.x += delta;
                }
            }
        }

        private void checkArguments(ScreenDockWindow neighbor, MagnetRequest.Side windowSide, MagnetRequest.Side neighborSide) {
            if (neighbor == null) {
                throw new IllegalArgumentException("neighbor is null");
            }
            if (neighbor == this.getWindow()) {
                throw new IllegalArgumentException("neighbor is identical to window");
            }
            if (windowSide == null) {
                throw new IllegalArgumentException("windowSide is null");
            }
            if (neighborSide == null) {
                throw new IllegalArgumentException("neighborSide is null");
            }
            if (windowSide != neighborSide) {
                switch (windowSide) {
                    case EAST: {
                        if (neighborSide == MagnetRequest.Side.WEST) break;
                        throw new IllegalArgumentException("windowSide and neighborSide not the same and not opposing: " + (Object)((Object)windowSide) + " vs. " + (Object)((Object)neighborSide));
                    }
                    case WEST: {
                        if (neighborSide == MagnetRequest.Side.EAST) break;
                        throw new IllegalArgumentException("windowSide and neighborSide not the same and not opposing: " + (Object)((Object)windowSide) + " vs. " + (Object)((Object)neighborSide));
                    }
                    case SOUTH: {
                        if (neighborSide == MagnetRequest.Side.NORTH) break;
                        throw new IllegalArgumentException("windowSide and neighborSide not the same and not opposing: " + (Object)((Object)windowSide) + " vs. " + (Object)((Object)neighborSide));
                    }
                    case NORTH: {
                        if (neighborSide == MagnetRequest.Side.SOUTH) break;
                        throw new IllegalArgumentException("windowSide and neighborSide not the same and not opposing: " + (Object)((Object)windowSide) + " vs. " + (Object)((Object)neighborSide));
                    }
                }
            }
        }

        public void directAttraction(Rectangle bounds) {
            this.resultBoundaries = new Rectangle(bounds);
        }

        public Rectangle attract(Rectangle bounds) {
            MagnetStrategy strategy;
            this.baseBoundaries = new Rectangle(bounds);
            this.resultBoundaries = new Rectangle(bounds);
            if (this.operation == null && (strategy = MagnetController.this.getStrategy()) != null) {
                this.operation = strategy.start(MagnetController.this, this);
            }
            if (this.operation != null) {
                this.operation.attract(MagnetController.this, this);
            }
            return this.resultBoundaries;
        }

        public void stop() {
            if (MagnetController.this.current == this) {
                MagnetController.this.current = null;
            }
            if (this.operation != null) {
                this.operation.destroy();
                this.operation = null;
            }
        }
    }
}

