/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.DockController;
import bibliothek.gui.Orientation;
import bibliothek.gui.Position;
import bibliothek.gui.dock.ToolbarContainerDockStation;
import bibliothek.gui.dock.station.support.ListSpanStrategy;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerDropInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import javax.swing.JComponent;

public class ToolbarContainerLayoutManager
implements LayoutManager2 {
    private JComponent parent;
    private ToolbarContainerDockStation station;
    private ListSpanStrategy spans;

    public ToolbarContainerLayoutManager(JComponent jComponent, ToolbarContainerDockStation toolbarContainerDockStation) {
        this.parent = jComponent;
        this.station = toolbarContainerDockStation;
        this.spans = this.createSpans();
    }

    public void setController(DockController dockController) {
        this.spans.setController(dockController);
    }

    public void setDrawing(ToolbarContainerDropInfo toolbarContainerDropInfo) {
        if (toolbarContainerDropInfo == null) {
            this.spans.untease();
        } else {
            int n = toolbarContainerDropInfo.getIndex();
            Position position = toolbarContainerDropInfo.getSideDockableBeneathMouse();
            if (position == Position.SOUTH || position == Position.EAST) {
                ++n;
            }
            this.spans.tease(n);
            if (this.station.getOrientation() == Orientation.HORIZONTAL) {
                this.spans.size(n, toolbarContainerDropInfo.getItem().getComponent().getWidth());
            } else {
                this.spans.size(n, toolbarContainerDropInfo.getItem().getComponent().getHeight());
            }
        }
    }

    private ListSpanStrategy createSpans() {
        return new ListSpanStrategy("dock.spanFactory.toolbar.container", this.station){

            @Override
            protected void spanResized() {
                ToolbarContainerLayoutManager.this.parent.revalidate();
            }

            @Override
            protected boolean isHorizontal() {
                return ToolbarContainerLayoutManager.this.station.getOrientation() == Orientation.HORIZONTAL;
            }

            @Override
            protected int getNumberOfDockables() {
                return ToolbarContainerLayoutManager.this.station.getDockableCount();
            }
        };
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.spans.reset();
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.spans.reset();
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        if (this.station.getOrientation() == Orientation.VERTICAL) {
            int n = this.spans.getTeasing();
            int n2 = 0;
            int n3 = container.getComponentCount();
            for (int i = 0; i < n3; ++i) {
                Dimension dimension = container.getComponent(i).getPreferredSize();
                n = Math.max(dimension.width, n);
                n2 += dimension.height;
                n2 += this.spans.getGap(i);
            }
            return new Dimension(n, n2 += this.spans.getGap(container.getComponentCount()));
        }
        int n = 0;
        int n4 = this.spans.getTeasing();
        int n5 = container.getComponentCount();
        for (int i = 0; i < n5; ++i) {
            Dimension dimension = container.getComponent(i).getPreferredSize();
            n4 = Math.max(dimension.height, n4);
            n += dimension.width;
            n += this.spans.getGap(i);
        }
        return new Dimension(n += this.spans.getGap(container.getComponentCount()), n4);
    }

    @Override
    public void layoutContainer(Container container) {
        block11: {
            int n;
            int n2;
            Dimension dimension;
            block10: {
                dimension = this.preferredLayoutSize(container);
                n2 = 0;
                n = container.getComponentCount();
                for (int i = 0; i <= n; ++i) {
                    n2 += this.spans.getGap(i);
                }
                if (this.station.getOrientation() != Orientation.HORIZONTAL) break block10;
                if (dimension.width <= n2) break block11;
                float f = (float)container.getWidth() / (float)(dimension.width - n2);
                if (f > 1.0f) {
                    f = 1.0f;
                } else if (f < 0.0f) {
                    f = 0.0f;
                }
                n = 0;
                int n3 = container.getHeight();
                int n4 = container.getComponentCount();
                for (int i = 0; i < n4; ++i) {
                    Component component = container.getComponent(i);
                    Dimension dimension2 = component.getPreferredSize();
                    int n5 = (int)((float)dimension2.width * f);
                    component.setBounds(n += this.spans.getGap(i), 0, n5, Math.min(n3, dimension2.height));
                    n += n5;
                }
                break block11;
            }
            if (dimension.height > n2) {
                float f = (float)container.getHeight() / (float)(dimension.height - n2);
                if (f > 1.0f) {
                    f = 1.0f;
                } else if (f < 0.0f) {
                    f = 0.0f;
                }
                n = 0;
                int n6 = container.getWidth();
                int n7 = container.getComponentCount();
                for (int i = 0; i < n7; ++i) {
                    Component component = container.getComponent(i);
                    Dimension dimension3 = component.getPreferredSize();
                    int n8 = (int)((float)dimension3.height * f);
                    component.setBounds(0, n += this.spans.getGap(i), Math.min(n6, dimension3.width), n8);
                    n += n8;
                }
            }
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        this.spans.reset();
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }
}

