//#define VAR 2 //This isn't valid here, use constant int, OR the -D input flag, or we can add our own find/replace step before compiling.
constant int FOUR = 2*2;//Arithmetic can be computed in constants just fine
/*----------------------------------------------------------*//**
Perform a simple pixel-only operation with similar math operations
as the other conditional functions below (benchCondition & benchCondCrazy).
*//*-----------------------------------------------------------*/
kernel void benchNoCondition(const int W, const int H, __global int* srcData, __global int* destData) {
 	int i = get_global_id(0); // get index into global data array
 	destData[i] = (srcData[i] % 2)*VAR;//(int)pythag(4.0 ,3.0);//Needs util.h header file for definition
}

/*----------------------------------------------------------*//**
A single bifurcation to test how much a branch slows down the code.
*//*-----------------------------------------------------------*/
kernel void benchCondition(const int W, const int H, __global int* srcData, __global int* destData) {
 	int i = get_global_id(0); // get index into global data array

 	if (srcData[i] % 2 == 0)
 		destData[i] = srcData[i]*VAR;
 	else
 		destData[i] = srcData[i]*8;
 	//barrier(CLK_GLOBAL_MEM_FENCE);//blocking call, needs CLK_LOCAL_MEM_FENCE and/or CLK_GLOBAL_MEM_FENCE
}

/*----------------------------------------------------------*//**
Try many different conditions that won't succeed at the same cycles for each processor.
*//*-----------------------------------------------------------*/
kernel void benchCondCrazy(const int W, const int H, __global int* srcData, __global int* destData) {
 	int i = get_global_id(0); // get index into global data array

 	if (srcData[i] % 128 == 0)
 		destData[i] = srcData[i]*100;
 	else if (srcData[i] % 64 == 0)
 		destData[i] = srcData[i]*60;
 	else if (srcData[i] % 32 == 0)
 		destData[i] = srcData[i]*30;
 	else if (srcData[i] % 16 == 0)
 		destData[i] = srcData[i]*15;
 	else if (srcData[i] % 8 == 0)
 		destData[i] = srcData[i]*7;
 	else if (srcData[i] % 4 == 0)
 		destData[i] = srcData[i]*FOUR;
 	else if (srcData[i] % 2 == 0)
 		destData[i] = srcData[i]*VAR;
 	else
 		destData[i] = srcData[i]*3;
}
