
    // OpenCL Kernel Function for element by element vector addition
    kernel void IsInSphere(global const float4* listPoints, global int* arePointsInside, float centerX, float centerY, float centerZ, float r, int numPoints) {

        // get index into global data array
        int iGID = get_global_id(0);
        int trueR = 1;
        int falseR = 0;

        // bound check (equivalent to the limit on a 'for' loop for standard/serial C code
        if (iGID >= numPoints)  {
            return;
        }

		float3 center = (float3) (centerX, centerY, centerZ);

		float3 distanceVector = (float3)(listPoints[iGID].x - center.x, listPoints[iGID].y - center.y, listPoints[iGID].z - center.z);

		float length = sqrt(dot(distanceVector, distanceVector));
		
		arePointsInside[iGID] = (int)(length <= r);
    }