/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.CompressedGeometryHeader;
import org.jogamp.java3d.CompressedGeometryRetained;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.GeometryDecompressorShape3D;
import org.jogamp.java3d.J3DBuffer;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.NodeComponent;
import org.jogamp.java3d.Shape3D;

public class CompressedGeometry
extends Geometry {
    CompressedGeometryHeader cgHeader;
    public static final int ALLOW_COUNT_READ = 0;
    public static final int ALLOW_HEADER_READ = 1;
    public static final int ALLOW_GEOMETRY_READ = 2;
    public static final int ALLOW_REF_DATA_READ = 3;
    private static final int[] readCapabilities = new int[]{0, 1, 2, 3};

    CompressedGeometry() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public CompressedGeometry(CompressedGeometryHeader hdr, byte[] compressedGeometry) {
        this(hdr, compressedGeometry, false);
    }

    public CompressedGeometry(CompressedGeometryHeader hdr, byte[] compressedGeometry, boolean byReference) {
        if (hdr.size + hdr.start > compressedGeometry.length) {
            throw new IllegalArgumentException(J3dI18N.getString("CompressedGeometry0"));
        }
        this.setDefaultReadCapabilities(readCapabilities);
        this.cgHeader = new CompressedGeometryHeader();
        hdr.copy(this.cgHeader);
        ((CompressedGeometryRetained)this.retained).createCompressedGeometry(this.cgHeader, compressedGeometry, byReference);
        if (!byReference) {
            this.cgHeader.start = 0;
        }
    }

    public CompressedGeometry(CompressedGeometryHeader hdr, J3DBuffer compressedGeometry) {
        throw new UnsupportedOperationException(J3dI18N.getString("CompressedGeometry9"));
    }

    public int getByteCount() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("CompressedGeometry1"));
        }
        return this.cgHeader.size;
    }

    public void getCompressedGeometryHeader(CompressedGeometryHeader hdr) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("CompressedGeometry2"));
        }
        this.cgHeader.copy(hdr);
    }

    public void getCompressedGeometry(byte[] compressedGeometry) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("CompressedGeometry3"));
        }
        if (this.isByReference()) {
            throw new IllegalStateException(J3dI18N.getString("CompressedGeometry7"));
        }
        if (this.cgHeader.size > compressedGeometry.length) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("CompressedGeometry4"));
        }
        ((CompressedGeometryRetained)this.retained).copy(compressedGeometry);
    }

    public Shape3D[] decompress() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("CompressedGeometry5"));
        }
        CompressedGeometryRetained cgr = (CompressedGeometryRetained)this.retained;
        GeometryDecompressorShape3D decompressor = new GeometryDecompressorShape3D();
        return decompressor.toTriangleStripArrays(cgr);
    }

    public boolean isByReference() {
        return ((CompressedGeometryRetained)this.retained).isByReference();
    }

    public byte[] getCompressedGeometryRef() {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("CompressedGeometry6"));
        }
        if (!this.isByReference()) {
            throw new IllegalStateException(J3dI18N.getString("CompressedGeometry8"));
        }
        return ((CompressedGeometryRetained)this.retained).getReference();
    }

    public J3DBuffer getCompressedGeometryBuffer() {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("CompressedGeometry6"));
        }
        return null;
    }

    @Override
    void createRetained() {
        this.retained = new CompressedGeometryRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        CompressedGeometry cg = new CompressedGeometry();
        cg.cgHeader = new CompressedGeometryHeader();
        this.cgHeader.copy(cg.cgHeader);
        CompressedGeometryRetained cgr = (CompressedGeometryRetained)this.retained;
        cgr.duplicate((CompressedGeometryRetained)cg.retained);
        cg.duplicateNodeComponent(this);
        return cg;
    }
}

