#version 130
#extension GL_EXT_gpu_shader4 : enable

#define PI 3.14159265359

//in int count;
//in float multiplier;

uniform float amplitude;
uniform int isAllClash;
out float distance;
out vec4 vert_color ;

void main(void) {

	gl_Position    = gl_ModelViewProjectionMatrix * gl_Vertex;

	distance = gl_Position.z;
	float prof = distance;

	if(isAllClash == 1){
		gl_Position.z *= .9999; //Move the points closer to the eye, so they are visible on top of their original octree cloud. Lower to 0.1 to see entirely through walls.
		//Make the clash points flash in red color:
		float ratio = amplitude;//The sine wave was already computed on CPU
		vert_color = mix(gl_Color, vec4(1.0, 0.0, 0.0, 1.0), ratio);
	}else{
		vert_color = gl_Color;
	}

	//gl_PointSize = 1.0 + 40.0 * (1.0 - prof);

	//gl_PointSize = clamp(5 - 4 * prof / 10, 1.0, 5.0);
	gl_PointSize = 5.0 * prof;

  	//gl_PointSize = clamp(distance, 1.0, 1.0 + amplitude * 9.0);
  	//if(gl_VertexID >= 100000)
	//  	gl_PointSize = 1.0;
	// else
	//  	gl_PointSize = 10.0;

}
