__constant float3 myVectorFloat = (float3)(1.0, 2.0, 3.0);
__constant int3 myVectorInt = (int3)(81, 85, 90);
__constant float2 foo[2] = 
{
(float2)(1.0f,0.0f), 
(float2)(0.0f,1.0f)
};


__constant int nbVertices = 4;
__constant float3 polygonPerfect[4] = 
{
(float3)(-1.0f, -1.0f, 0.0f), 
(float3)( 1.0f, -1.0f, 0.0f), 
(float3)( 1.0f,  1.0f, 0.0f), 
(float3)(-1.0f,  1.0f, 0.0f)
};
__constant float3 aretesNormaliseesPerfect[4] = 
{
(float3)( 1.0f,  0.0f, 0.0f), 
(float3)( 0.0f,  1.0f, 0.0f), 
(float3)(-1.0f,  0.0f, 0.0f), 
(float3)( 0.0f, -1.0f, 0.0f)
};
__constant float longueursAretesPerfect[4] = 
{
2.0f, 
2.0f, 
2.0f, 
2.0f
};
__constant float3 O = (float3)(0.0f, 0.0f, 0.0f);
__constant float3 U = (float3)(0.0f, -1.0f, 0.0f);
__constant float3 V = (float3)(1.0f, 0.0f, 0.0f);
__constant float3 N = (float3)(0.0f, 0.0f, 1.0f);
 
__constant float2 BBmin = (float2)(-1.0f, -1.0f);
__constant float2 BBmax = (float2)( 1.0f,  1.0f);

__constant float epsilon = 0.0001f;
__constant float tolerance = 0.0001f;

kernel void belongsToPolygon(__global const float3* listPoints, __global float* results, const int resultRecordSize, const int numPoints) 
{
	// get index into global data array
	int iGID = get_global_id(0);
	int trueR = 1;
	int falseR = 0;

	// bound check (equivalent to the limit on a 'for' loop for standard/serial C code
	if (iGID >= numPoints)  
	{
		return;
	}
	//float3 lePoint = listPoints[iGID].xyz;
	float3 lePoint = listPoints[iGID];
	
	
	for (int i=0; i<resultRecordSize; i++)
	{
		results[resultRecordSize*iGID + i]  = 0.0f;
	}
	

		
	float3 areteNormalisee;
	float3 P1;
	float longueurArete;
	
	float uMin = BBmin.x;
	float vMin = BBmin.y;
	float uMax = BBmax.x;
	float vMax = BBmax.y;

	float3 OP = lePoint-O;

	float scalU = dot(OP, U);
	float scalV = dot(OP, V);
	float scalN = dot(OP, N);

	results[resultRecordSize*iGID + 1] = scalU;
	results[resultRecordSize*iGID + 2] = scalV;
	results[resultRecordSize*iGID + 3] = scalN;


	int k=0;
	results[resultRecordSize*iGID + 4 + k] = O.x; k++;
	results[resultRecordSize*iGID + 4 + k] = O.y; k++;
	results[resultRecordSize*iGID + 4 + k] = O.z; k++;
	
	results[resultRecordSize*iGID + 4 + k] = U.x; k++;
	results[resultRecordSize*iGID + 4 + k] = U.y; k++;
	results[resultRecordSize*iGID + 4 + k] = U.z; k++;
	
	results[resultRecordSize*iGID + 4 + k] = V.x; k++;
	results[resultRecordSize*iGID + 4 + k] = V.y; k++;
	results[resultRecordSize*iGID + 4 + k] = V.z; k++;
	
	results[resultRecordSize*iGID + 4 + k] = N.x; k++;
	results[resultRecordSize*iGID + 4 + k] = N.y; k++;
	results[resultRecordSize*iGID + 4 + k] = N.z; k++;
	
	results[resultRecordSize*iGID + 4 + k] = uMin; k++;
	results[resultRecordSize*iGID + 4 + k] = vMin; k++;
	
	results[resultRecordSize*iGID + 4 + k] = uMax; k++;
	results[resultRecordSize*iGID + 4 + k] = vMax; k++;

	int startInd = resultRecordSize*iGID + 4 + 16;
	
	
	

	if ((scalU<uMin)||(scalU>uMax)||(scalV<vMin)||(scalV>vMax)||(fabs(scalN)>tolerance))
	{
		results[resultRecordSize*iGID] = 0;
    }
    else
    {
    	int nbIntersections = 0;
		for (int i=0; i<nbVertices; i++)
		{
			//-----------------------------------------------------------
			//CALCUL POUR UNE ARETE
			//-----------------------------------------------------------
			areteNormalisee = aretesNormaliseesPerfect[i];
			longueurArete = longueursAretesPerfect[i];
			P1 = polygonPerfect[i];
			
			if (longueurArete>epsilon)
			{
				//-----------------------------------------------------------
				//TEST D'INTERSECTION AVEC UN SEGMENT
				//-----------------------------------------------------------
				float scal = dot(U, areteNormalisee);
				//float scal = U.x*areteNormalisee.x + U.y*areteNormalisee.y + U.z*areteNormalisee.z;
				results[startInd + 5*i+0] = scal;

				if (fabs(fabs(scal)-1)<epsilon)
				{
				}
				else
				{
					//Cas général
					float3 crossProd = cross(U, areteNormalisee);
					//float3 crossProd = (float3)(U.y*areteNormalisee.z-U.z*areteNormalisee.y, U.z*areteNormalisee.x-U.x*areteNormalisee.z, U.x*areteNormalisee.y-U.y*areteNormalisee.x);

					float norm = length(crossProd);
					//float norm = sqrt(crossProd.x*crossProd.x+crossProd.y*crossProd.y+crossProd.z*crossProd.z);
					crossProd /= norm;

					float3 w = cross(U, crossProd);
					//float3 w = (float3)(U.y*crossProd.z-U.z*crossProd.y, U.z*crossProd.x-U.x*crossProd.z, U.x*crossProd.y-U.y*crossProd.x);

					float3 PP1 = P1 - lePoint;
					
					float dist = dot(PP1, crossProd);					
					//float dist = PP1.x*crossProd.x + PP1.y*crossProd.y + PP1.z*crossProd.z;					
					results[startInd + 5*i+1] = dist;
					
					if (fabs(dist)<tolerance)
					{
						float dotWithW = dot(areteNormalisee, w);						
						//float dotWithW = areteNormalisee.x*w.x + areteNormalisee.y*w.y + areteNormalisee.z*w.z; 						
						results[startInd + 5*i+2] = dotWithW;
						
						float lambda = -(PP1.x*w.x+PP1.y*w.y+PP1.z*w.z)/dotWithW;
						results[startInd + 5*i+3] = lambda;
						
						if ((lambda>=0.0)&&(lambda<=longueurArete)) 
						{
							float dotWithU = dot(areteNormalisee, U);
							//float dotWithU = areteNormalisee.x*U.x + areteNormalisee.y*U.y + areteNormalisee.z*U.z;
							float mu = (PP1.x*U.x+PP1.y*U.y+PP1.z*U.z) + lambda*dotWithU;
							results[startInd + 5*i+4] = mu;
							
							if (mu>=0.0)
							{
								nbIntersections = nbIntersections+1;
							}						
						}
					}
				}
			}
		}
			
		//-----------------------------------------------------------
		//LE POINT APPARTIENT AU POLYGONE SI LE NOMBRE D'INTERSECTIONS EST IMPAIR
		//-----------------------------------------------------------
		if (nbIntersections%2 != 0)
		{
			results[resultRecordSize*iGID] = 1;
		}
		else
		{
			//results[iGID] = 0;
		}
		
		//results[iGID] = (int)((nbIntersections % 2!=0));
    }
    
    
    }
}
