/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.action.ActionContentModifier;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModelListener;
import bibliothek.gui.dock.themes.basic.action.BasicResourceInitializer;
import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import bibliothek.gui.dock.themes.border.BorderModifier;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.BackgroundComponent;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.container.Triple;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicButtonModel {
    private boolean selected = false;
    private Map<ActionContentModifier, Icon> icons = new HashMap<ActionContentModifier, Icon>();
    private Map<ActionContentModifier, Icon> disabledIcons = new HashMap<ActionContentModifier, Icon>();
    private DockActionRepresentative representative;
    private boolean mouseInside = false;
    private boolean mousePressed = false;
    private String text;
    private JComponent owner;
    private DockTitle.Orientation orientation = DockTitle.Orientation.FREE_HORIZONTAL;
    private BasicTrigger trigger;
    private BasicResourceInitializer initializer;
    private BackgroundPaint background;
    private BackgroundComponent backgroundComponent;
    private List<BasicButtonModelListener> listeners = new ArrayList<BasicButtonModelListener>();
    private Map<String, BorderModifier> borders = new HashMap<String, BorderModifier>();
    private DockController controller;

    public BasicButtonModel(JComponent owner, BasicTrigger trigger, BasicResourceInitializer initializer) {
        this(owner, trigger, initializer, true);
    }

    public BasicButtonModel(JComponent owner, BasicTrigger trigger, BasicResourceInitializer initializer, boolean createListener) {
        List<Triple<KeyStroke, String, Action>> actions;
        this.owner = owner;
        this.trigger = trigger;
        this.initializer = initializer;
        if (createListener) {
            Listener listener = new Listener();
            owner.addMouseListener(listener);
            owner.addMouseMotionListener(listener);
        }
        if ((actions = this.listActions()) != null) {
            InputMap inputMap = owner.getInputMap();
            ActionMap actionMap = owner.getActionMap();
            for (Triple<KeyStroke, String, Action> action : actions) {
                inputMap.put((KeyStroke)action.getA(), action.getB());
                actionMap.put(action.getB(), action.getC());
            }
        }
    }

    protected List<Triple<KeyStroke, String, Action>> listActions() {
        ArrayList<Triple<KeyStroke, String, Action>> actions = new ArrayList<Triple<KeyStroke, String, Action>>();
        Triple<KeyStroke, String, 1> select = new Triple<KeyStroke, String, 1>();
        select.setA(KeyStroke.getKeyStroke(32, 0, false));
        select.setB("button_model_select");
        select.setC(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                BasicButtonModel.this.setMousePressed(true);
            }
        });
        actions.add(select);
        Triple<KeyStroke, String, 2> trigger = new Triple<KeyStroke, String, 2>();
        trigger.setA(KeyStroke.getKeyStroke(32, 0, true));
        trigger.setB("button_model_trigger");
        trigger.setC(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (BasicButtonModel.this.mousePressed) {
                    BasicButtonModel.this.setMousePressed(false);
                    if (this.isEnabled()) {
                        BasicButtonModel.this.trigger();
                    }
                }
            }
        });
        actions.add(trigger);
        return actions;
    }

    public void addListener(BasicButtonModelListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.listeners.add(listener);
    }

    public void setController(DockController controller) {
        if (this.controller != null) {
            DockController old = this.controller;
            this.controller = null;
            for (BasicButtonModelListener listener : this.listeners()) {
                listener.unbound(this, old);
            }
        }
        if (controller != null) {
            this.controller = controller;
            for (BasicButtonModelListener listener : this.listeners()) {
                listener.bound(this, this.controller);
            }
        }
    }

    public void removeListener(BasicButtonModelListener listener) {
        this.listeners.remove(listener);
    }

    protected BasicButtonModelListener[] listeners() {
        return this.listeners.toArray(new BasicButtonModelListener[this.listeners.size()]);
    }

    public JComponent getOwner() {
        return this.owner;
    }

    public void setBackground(BackgroundPaint background, BackgroundComponent backgroundComponent) {
        if (this.background != background) {
            if (background != null) {
                if (backgroundComponent == null) {
                    throw new IllegalArgumentException("backgroundComponent must not be null");
                }
                if (backgroundComponent.getComponent() != this.getOwner()) {
                    throw new IllegalArgumentException("backgroundComponent must exactly represent 'getOwner()'");
                }
            }
            BackgroundPaint old = this.background;
            this.background = background;
            this.backgroundComponent = backgroundComponent;
            for (BasicButtonModelListener listener : this.listeners()) {
                listener.backgroundChanged(this, old, background);
            }
        }
    }

    public BackgroundPaint getBackground() {
        return this.background;
    }

    public BackgroundComponent getBackgroundComponent() {
        return this.backgroundComponent;
    }

    public DockAction getAction() {
        if (this.trigger == null) {
            return null;
        }
        return this.trigger.getAction();
    }

    public Dockable getDockable() {
        if (this.trigger == null) {
            return null;
        }
        return this.trigger.getDockable();
    }

    public void setBorder(String key, BorderModifier border) {
        BorderModifier oldBorder = this.borders.get(key);
        if (oldBorder != border) {
            if (border == null) {
                this.borders.remove(key);
            } else {
                this.borders.put(key, border);
            }
            for (BasicButtonModelListener listener : this.listeners()) {
                listener.borderChanged(this, key, oldBorder, border);
            }
        }
    }

    public BorderModifier getBorder(String key) {
        if (this.initializer != null) {
            this.initializer.ensureBorder(this, key);
        }
        return this.borders.get(key);
    }

    public void clearIcons() {
        for (ActionContentModifier key : this.getIconContexts()) {
            this.setIcon(key, null);
        }
    }

    public ActionContentModifier[] getIconContexts() {
        return this.icons.keySet().toArray(new ActionContentModifier[this.icons.size()]);
    }

    public void setText(String text) {
        String oldText = this.text;
        this.text = text;
        for (BasicButtonModelListener listener : this.listeners()) {
            listener.textChanged(this, oldText, text);
        }
        this.changed();
    }

    public String getText() {
        return this.text;
    }

    public void setIcon(ActionContentModifier modifier, Icon icon) {
        Icon oldIcon = this.icons.remove(modifier);
        if (icon == null) {
            this.icons.remove(modifier);
        } else {
            this.icons.put(modifier, icon);
        }
        this.disabledIcons.remove(modifier);
        for (BasicButtonModelListener listener : this.listeners()) {
            listener.iconChanged(this, modifier, oldIcon, icon);
        }
        this.changed();
    }

    public void setSelected(boolean selected) {
        if (this.selected != selected) {
            this.selected = selected;
            for (BasicButtonModelListener listener : this.listeners()) {
                listener.selectedStateChanged(this, selected);
            }
            this.changed();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setEnabled(boolean enabled) {
        this.owner.setEnabled(enabled);
        if (!enabled) {
            this.setMousePressed(false);
        }
        for (BasicButtonModelListener listener : this.listeners()) {
            listener.enabledStateChanged(this, enabled);
        }
        this.changed();
    }

    public boolean isEnabled() {
        return this.owner.isEnabled();
    }

    public void setToolTipText(String tooltip) {
        String old = this.owner.getToolTipText();
        for (BasicButtonModelListener listener : this.listeners()) {
            listener.tooltipChanged(this, old, tooltip);
        }
        this.owner.setToolTipText(tooltip);
    }

    public void setOrientation(DockTitle.Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("Orientation must not be null");
        }
        DockTitle.Orientation old = this.orientation;
        this.orientation = orientation;
        for (BasicButtonModelListener listener : this.listeners()) {
            listener.orientationChanged(this, old, orientation);
        }
        this.changed();
    }

    public void setDockableRepresentative(Dockable dockable) {
        if (this.representative != null) {
            this.representative.unbind();
            this.representative = null;
        }
        if (dockable != null) {
            this.representative = new DockActionRepresentative(dockable);
            this.representative.bind();
        }
    }

    public DockTitle.Orientation getOrientation() {
        return this.orientation;
    }

    public void changed() {
        this.owner.repaint();
    }

    public Dimension getMaxIconSize() {
        int w = 0;
        int h = 0;
        for (Icon icon : this.icons.values()) {
            w = Math.max(w, icon.getIconWidth());
            h = Math.max(h, icon.getIconHeight());
        }
        return new Dimension(w, h);
    }

    public Icon getPaintIcon() {
        return this.getPaintIcon(this.isEnabled());
    }

    public Icon getPaintIcon(boolean enabled) {
        ActionContentModifier modifier = enabled ? (this.mousePressed ? (this.orientation == null || this.orientation.isHorizontal() ? ActionContentModifier.NONE_PRESSED_HORIZONTAL : ActionContentModifier.NONE_PRESSED_VERTICAL) : (this.mouseInside ? (this.orientation == null || this.orientation.isHorizontal() ? ActionContentModifier.NONE_HOVER_HORIZONTAL : ActionContentModifier.NONE_HOVER_VERTICAL) : (this.orientation == null || this.orientation.isHorizontal() ? ActionContentModifier.NONE_HORIZONTAL : ActionContentModifier.NONE_VERTICAL))) : (this.mousePressed ? (this.orientation == null || this.orientation.isHorizontal() ? ActionContentModifier.DISABLED_PRESSED_HORIZONTAL : ActionContentModifier.DISABLED_PRESSED_VERTICAL) : (this.mouseInside ? (this.orientation == null || this.orientation.isHorizontal() ? ActionContentModifier.DISABLED_HOVER_HORIZONTAL : ActionContentModifier.DISABLED_HOVER_VERTICAL) : (this.orientation == null || this.orientation.isHorizontal() ? ActionContentModifier.DISABLED_HORIZONTAL : ActionContentModifier.DISABLED_VERTICAL)));
        LinkedList<ActionContentModifier> modifiers = new LinkedList<ActionContentModifier>();
        modifiers.add(modifier);
        while (!modifiers.isEmpty()) {
            modifier = (ActionContentModifier)modifiers.remove(0);
            Icon icon = this.icons.get(modifier);
            if (icon != null) {
                if (!enabled && modifier.isEnabled()) {
                    Icon disabled = this.disabledIcons.get(modifier);
                    if (disabled == null && !this.disabledIcons.containsKey(modifier)) {
                        disabled = DockUtilities.disabledIcon(this.owner, icon);
                        this.disabledIcons.put(modifier, disabled);
                    }
                    if (disabled != null) {
                        icon = disabled;
                    }
                }
                return icon;
            }
            for (ActionContentModifier backup : modifier.getBackup()) {
                modifiers.add(backup);
            }
        }
        return null;
    }

    protected void setMouseInside(boolean mouseInside) {
        if (this.mouseInside != mouseInside) {
            this.mouseInside = mouseInside;
            for (BasicButtonModelListener listener : this.listeners()) {
                listener.mouseInside(this, mouseInside);
            }
            this.changed();
        }
    }

    public boolean isMouseInside() {
        return this.mouseInside;
    }

    protected void setMousePressed(boolean mousePressed) {
        if (this.mousePressed != mousePressed) {
            this.mousePressed = mousePressed;
            for (BasicButtonModelListener listener : this.listeners()) {
                listener.mousePressed(this, mousePressed);
            }
            this.changed();
        }
    }

    public boolean isMousePressed() {
        return this.mousePressed;
    }

    protected void trigger() {
        if (this.trigger != null) {
            this.trigger.triggered();
        }
        for (BasicButtonModelListener listener : this.listeners()) {
            listener.triggered();
        }
    }

    private class DockActionRepresentative
    implements DockElementRepresentative,
    DockHierarchyListener {
        private Dockable dockable;
        private DockController controller;

        public DockActionRepresentative(Dockable dockable) {
            this.dockable = dockable;
        }

        public void bind() {
            this.dockable.addDockHierarchyListener(this);
            this.controller = this.dockable.getController();
            if (this.controller != null) {
                this.controller.addRepresentative(this);
            }
        }

        public void unbind() {
            this.dockable.removeDockHierarchyListener(this);
            if (this.controller != null) {
                this.controller.removeRepresentative(this);
                this.controller = null;
            }
        }

        public void hierarchyChanged(DockHierarchyEvent event) {
        }

        public void controllerChanged(DockHierarchyEvent event) {
            if (this.controller != null) {
                this.controller.removeRepresentative(this);
                this.controller = null;
            }
            this.controller = this.dockable.getController();
            if (this.controller != null) {
                this.controller.addRepresentative(this);
            }
        }

        public void addMouseInputListener(MouseInputListener listener) {
            BasicButtonModel.this.getOwner().addMouseListener(listener);
            BasicButtonModel.this.getOwner().addMouseMotionListener(listener);
        }

        public Component getComponent() {
            return BasicButtonModel.this.getOwner();
        }

        public DockElement getElement() {
            return this.dockable;
        }

        public Point getPopupLocation(Point click, boolean popupTrigger) {
            if (popupTrigger) {
                return click;
            }
            return null;
        }

        public boolean isUsedAsTitle() {
            return false;
        }

        public void removeMouseInputListener(MouseInputListener listener) {
            BasicButtonModel.this.getOwner().removeMouseListener(listener);
            BasicButtonModel.this.getOwner().removeMouseMotionListener(listener);
        }

        public boolean shouldFocus() {
            return false;
        }

        public boolean shouldTransfersFocus() {
            return true;
        }
    }

    private class Listener
    extends MouseInputAdapter {
        private Listener() {
        }

        public void mouseEntered(MouseEvent e) {
            BasicButtonModel.this.setMouseInside(true);
        }

        public void mouseExited(MouseEvent e) {
            BasicButtonModel.this.setMouseInside(false);
        }

        public void mouseDragged(MouseEvent e) {
            boolean inside = BasicButtonModel.this.owner.contains(e.getX(), e.getY());
            if (inside != BasicButtonModel.this.mouseInside) {
                BasicButtonModel.this.setMouseInside(inside);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (!BasicButtonModel.this.mousePressed && e.getButton() == 1) {
                BasicButtonModel.this.setMousePressed(true);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (BasicButtonModel.this.mousePressed && e.getButton() == 1) {
                boolean inside = BasicButtonModel.this.owner.contains(e.getX(), e.getY());
                if (inside && BasicButtonModel.this.isEnabled()) {
                    BasicButtonModel.this.trigger();
                }
                BasicButtonModel.this.setMousePressed(false);
                if (BasicButtonModel.this.mouseInside != inside) {
                    BasicButtonModel.this.setMouseInside(inside);
                }
            }
        }
    }
}

