/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui;

import bibliothek.gui.DockController;
import bibliothek.gui.DockFrontend;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.ExpandableToolbarItemStrategy;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.action.ActionType;
import bibliothek.gui.dock.action.ButtonDockAction;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.MenuDockAction;
import bibliothek.gui.dock.action.SelectableDockAction;
import bibliothek.gui.dock.action.ToolbarSeparator;
import bibliothek.gui.dock.action.actions.SeparatorAction;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewGenerator;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.control.relocator.DefaultDockRelocator;
import bibliothek.gui.dock.control.relocator.Inserter;
import bibliothek.gui.dock.control.relocator.Merger;
import bibliothek.gui.dock.dockable.AncestorMovingImageFactory;
import bibliothek.gui.dock.dockable.DefaultDockableMovingImageFactory;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.frontend.DefaultFrontendPerspectiveCache;
import bibliothek.gui.dock.frontend.DockFrontendExtension;
import bibliothek.gui.dock.frontend.FrontendPerspectiveCacheExtension;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.DockablePropertyFactory;
import bibliothek.gui.dock.layout.PropertyTransformer;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.ToolbarMiniButton;
import bibliothek.gui.dock.station.ToolbarTabDockStationFactory;
import bibliothek.gui.dock.station.screen.ScreenDockStationExtension;
import bibliothek.gui.dock.station.screen.ScreenDockWindowConfiguration;
import bibliothek.gui.dock.station.screen.ScreenToolbarDisplayerFactory;
import bibliothek.gui.dock.station.screen.ScreenToolbarDockTitleFactory;
import bibliothek.gui.dock.station.screen.ScreenToolbarInserter;
import bibliothek.gui.dock.station.screen.ToolbarScreenDockStationExtension;
import bibliothek.gui.dock.station.screen.ToolbarWindowConfiguration;
import bibliothek.gui.dock.station.screen.magnet.AttractorStrategy;
import bibliothek.gui.dock.station.screen.window.DefaultScreenDockWindowConfiguration;
import bibliothek.gui.dock.station.toolbar.ToolbarAttractorStrategy;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerDockStationFactory;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerPropertyFactory;
import bibliothek.gui.dock.station.toolbar.ToolbarDockStationFactory;
import bibliothek.gui.dock.station.toolbar.ToolbarDockStationMerger;
import bibliothek.gui.dock.station.toolbar.ToolbarDockableDisplayer;
import bibliothek.gui.dock.station.toolbar.ToolbarFullscreenFilter;
import bibliothek.gui.dock.station.toolbar.ToolbarGroupDockStationFactory;
import bibliothek.gui.dock.station.toolbar.ToolbarGroupDockStationMerger;
import bibliothek.gui.dock.station.toolbar.ToolbarItemDockableFactory;
import bibliothek.gui.dock.station.toolbar.ToolbarMovingImageFactory;
import bibliothek.gui.dock.station.toolbar.ToolbarPropertyFactory;
import bibliothek.gui.dock.station.toolbar.ToolbarStationPaint;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupPropertyFactory;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupTitle;
import bibliothek.gui.dock.station.toolbar.title.ToolbarDockTitlePoint;
import bibliothek.gui.dock.themes.DockThemeExtension;
import bibliothek.gui.dock.themes.ThemeManager;
import bibliothek.gui.dock.themes.basic.action.BasicButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicMenuHandler;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleManager;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.title.NullTitleFactory;
import bibliothek.gui.dock.toolbar.ToolbarDockFrontendExtension;
import bibliothek.gui.dock.toolbar.expand.ExpandManager;
import bibliothek.gui.dock.toolbar.item.DockActionItem;
import bibliothek.gui.dock.toolbar.perspective.ToolbarFrontendPerspectiveCacheExtension;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockPropertyListener;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.TextManager;
import bibliothek.gui.dock.util.extension.Extension;
import bibliothek.gui.dock.util.extension.ExtensionName;
import bibliothek.gui.dock.wizard.WizardSplitDockStationFactory;
import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ToolbarExtension
implements Extension {
    public static final ViewTarget<BasicTitleViewItem<JComponent>> TOOLBAR_TITLE = new ViewTarget("target TOOLBAR TITLE");

    @Override
    public void install(final DockController dockController) {
        ActionViewConverter actionViewConverter = dockController.getActionViewConverter();
        actionViewConverter.putDefault(ActionType.BUTTON, TOOLBAR_TITLE, new ViewGenerator<ButtonDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, ButtonDockAction buttonDockAction, Dockable dockable) {
                BasicButtonHandler basicButtonHandler = new BasicButtonHandler(buttonDockAction, dockable);
                ToolbarMiniButton toolbarMiniButton = new ToolbarMiniButton(basicButtonHandler, basicButtonHandler);
                basicButtonHandler.setModel(toolbarMiniButton.getModel());
                return basicButtonHandler;
            }
        });
        actionViewConverter.putDefault(ActionType.MENU, TOOLBAR_TITLE, new ViewGenerator<MenuDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, MenuDockAction menuDockAction, Dockable dockable) {
                BasicMenuHandler basicMenuHandler = new BasicMenuHandler(menuDockAction, dockable);
                ToolbarMiniButton toolbarMiniButton = new ToolbarMiniButton(basicMenuHandler, basicMenuHandler);
                basicMenuHandler.setModel(toolbarMiniButton.getModel());
                return basicMenuHandler;
            }
        });
        actionViewConverter.putDefault(ActionType.SEPARATOR, TOOLBAR_TITLE, new ViewGenerator<SeparatorAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, SeparatorAction separatorAction, Dockable dockable) {
                if (separatorAction.shouldDisplay(ViewTarget.TITLE)) {
                    return new ToolbarSeparator(separatorAction, Color.LIGHT_GRAY);
                }
                return null;
            }
        });
        actionViewConverter.putDefault(ActionType.BUTTON, DockActionItem.TOOLBAR, new ViewGenerator<ButtonDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, ButtonDockAction buttonDockAction, Dockable dockable) {
                return actionViewConverter.createView(ActionType.BUTTON, buttonDockAction, ViewTarget.TITLE, dockable);
            }
        });
        actionViewConverter.putDefault(ActionType.CHECK, DockActionItem.TOOLBAR, new ViewGenerator<SelectableDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, SelectableDockAction selectableDockAction, Dockable dockable) {
                return actionViewConverter.createView(ActionType.CHECK, selectableDockAction, ViewTarget.TITLE, dockable);
            }
        });
        actionViewConverter.putDefault(ActionType.DROP_DOWN, DockActionItem.TOOLBAR, new ViewGenerator<DropDownAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, DropDownAction dropDownAction, Dockable dockable) {
                return actionViewConverter.createView(ActionType.DROP_DOWN, dropDownAction, ViewTarget.TITLE, dockable);
            }
        });
        actionViewConverter.putDefault(ActionType.MENU, DockActionItem.TOOLBAR, new ViewGenerator<MenuDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, MenuDockAction menuDockAction, Dockable dockable) {
                return actionViewConverter.createView(ActionType.MENU, menuDockAction, ViewTarget.TITLE, dockable);
            }
        });
        actionViewConverter.putDefault(ActionType.RADIO, DockActionItem.TOOLBAR, new ViewGenerator<SelectableDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, SelectableDockAction selectableDockAction, Dockable dockable) {
                return actionViewConverter.createView(ActionType.RADIO, selectableDockAction, ViewTarget.TITLE, dockable);
            }
        });
        actionViewConverter.putDefault(ActionType.SEPARATOR, DockActionItem.TOOLBAR, new ViewGenerator<SeparatorAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, SeparatorAction separatorAction, Dockable dockable) {
                return actionViewConverter.createView(ActionType.SEPARATOR, separatorAction, ViewTarget.TITLE, dockable);
            }
        });
        IconManager iconManager = dockController.getIcons();
        iconManager.setIconDefault("toolbar.item.expand.horizontal", this.loadIcon("expand_horizontal.png"));
        iconManager.setIconDefault("toolbar.item.expand.vertical", this.loadIcon("expand_vertical.png"));
        iconManager.setIconDefault("toolbar.item.expand.hover.horizontal", this.loadIcon("expand_hover_horizontal.png"));
        iconManager.setIconDefault("toolbar.item.expand.hover.vertical", this.loadIcon("expand_hover_vertical.png"));
        iconManager.setIconDefault("toolbar.item.shrink.horizontal", this.loadIcon("shrink_horizontal.png"));
        iconManager.setIconDefault("toolbar.item.shrink.vertical", this.loadIcon("shrink_vertical.png"));
        iconManager.setIconDefault("toolbar.item.shrink.hover.horizontal", this.loadIcon("shrink_hover_horizontal.png"));
        iconManager.setIconDefault("toolbar.item.shrink.hover.vertical", this.loadIcon("shrink_hover_vertical.png"));
        iconManager.setIconDefault("toolbar.item.larger.horizontal", this.loadIcon("larger_horizontal.png"));
        iconManager.setIconDefault("toolbar.item.larger.vertical", this.loadIcon("larger_vertical.png"));
        iconManager.setIconDefault("toolbar.item.larger.hover.horizontal", this.loadIcon("larger_hover_horizontal.png"));
        iconManager.setIconDefault("toolbar.item.larger.hover.vertical", this.loadIcon("larger_hover_vertical.png"));
        iconManager.setIconDefault("toolbar.item.smaller.horizontal", this.loadIcon("smaller_horizontal.png"));
        iconManager.setIconDefault("toolbar.item.smaller.vertical", this.loadIcon("smaller_vertical.png"));
        iconManager.setIconDefault("toolbar.item.smaller.hover.horizontal", this.loadIcon("smaller_hover_horizontal.png"));
        iconManager.setIconDefault("toolbar.item.smaller.hover.vertical", this.loadIcon("smaller_hover_vertical.png"));
        iconManager.setIconDefault("toolbar.customization.here", this.loadIcon("here.png"));
        iconManager.setIconDefault("toolbar.customization.check", this.loadIcon("check.png"));
        iconManager.setIconDefault("toolbar.customization.preferences", this.loadIcon("preferences.png"));
        new ExpandManager(dockController);
        final ToolbarFullscreenFilter toolbarFullscreenFilter = new ToolbarFullscreenFilter(dockController);
        dockController.getRegister().addDockRegisterListener(new DockRegisterAdapter(){

            @Override
            public void dockStationRegistering(DockController dockController, DockStation dockStation) {
                if (dockStation instanceof ScreenDockStation) {
                    ((ScreenDockStation)dockStation).addFullscreenFilter(toolbarFullscreenFilter);
                }
            }

            @Override
            public void dockStationUnregistered(DockController dockController, DockStation dockStation) {
                if (dockStation instanceof ScreenDockStation) {
                    ((ScreenDockStation)dockStation).removeFullscreenFilter(toolbarFullscreenFilter);
                }
            }
        });
        dockController.getProperties().addListener(ExpandableToolbarItemStrategy.STRATEGY, new DockPropertyListener<ExpandableToolbarItemStrategy>(){

            @Override
            public void propertyChanged(DockProperties dockProperties, PropertyKey<ExpandableToolbarItemStrategy> propertyKey, ExpandableToolbarItemStrategy expandableToolbarItemStrategy, ExpandableToolbarItemStrategy expandableToolbarItemStrategy2) {
                if (expandableToolbarItemStrategy != null) {
                    expandableToolbarItemStrategy.uninstall(dockController);
                }
                if (expandableToolbarItemStrategy2 != null) {
                    expandableToolbarItemStrategy2.install(dockController);
                }
            }
        });
        dockController.getProperties().get(ExpandableToolbarItemStrategy.STRATEGY).install(dockController);
        dockController.getThemeManager().put(Priority.THEME, "dock.paint.toolbar", ThemeManager.STATION_PAINT_TYPE, new ToolbarStationPaint(new Color(255, 0, 0, 125), new Color(128, 128, 128, 125)));
    }

    private Icon loadIcon(String string) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/data/bibliothek/gui/toolbar/" + string);
            if (inputStream == null) {
                throw new FileNotFoundException("cannot find file '" + string + "'");
            }
            ImageIcon imageIcon = new ImageIcon(ImageIO.read(inputStream));
            inputStream.close();
            return imageIcon;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    @Override
    public void uninstall(DockController dockController) {
        ActionViewConverter actionViewConverter = dockController.getActionViewConverter();
        actionViewConverter.putDefault(ActionType.BUTTON, TOOLBAR_TITLE, null);
    }

    @Override
    public <E> Collection<E> load(DockController dockController, ExtensionName<E> extensionName) {
        if (extensionName.getName().equals(PropertyTransformer.FACTORY_EXTENSION)) {
            return this.createPropertyFactoryExtension();
        }
        if (extensionName.getName().equals(DefaultDockRelocator.MERGE_EXTENSION)) {
            return this.createMergerExtension();
        }
        if (extensionName.getName().equals(DefaultDockRelocator.INSERTER_EXTENSION)) {
            return this.createInserterExtension(dockController);
        }
        if (extensionName.getName().equals(ScreenDockStation.ATTRACTOR_STRATEGY_EXTENSION)) {
            return this.createAttractorStrategies();
        }
        if (extensionName.getName().equals(DockSituation.DOCK_FACTORY_EXTENSION)) {
            return this.createDockFactories();
        }
        if (extensionName.getName().equals(DockThemeExtension.DOCK_THEME_EXTENSION)) {
            return this.createDockThemeExtension();
        }
        if (extensionName.getName().equals(DockTitleVersion.DOCK_TITLE_VERSION_EXTENSION)) {
            return this.createTitleFactories((DockTitleVersion)extensionName.get("version"));
        }
        if (extensionName.getName().equals(DisplayerFactory.DISPLAYER_EXTENSION)) {
            return this.createDisplayerFactories(dockController, (String)extensionName.get("name"));
        }
        if (extensionName.getName().equals(TextManager.TEXT_EXTENSION)) {
            return this.createBundles((Locale)extensionName.get("locale"));
        }
        if (extensionName.getName().equals(DefaultScreenDockWindowConfiguration.CONFIGURATION_EXTENSION)) {
            return this.createWindowConfigurationExtension(dockController);
        }
        if (extensionName.getName().equals(DefaultDockableMovingImageFactory.FACTORY_EXTENSION)) {
            return this.createMovingImageFactory();
        }
        if (extensionName.getName().equals(ScreenDockStation.STATION_EXTENSION)) {
            return this.createScreenDockStationExtension(dockController);
        }
        if (extensionName.getName().equals(DefaultFrontendPerspectiveCache.CACHE_EXTENSION)) {
            return this.createPerspectiveCacheExtensions();
        }
        if (extensionName.getName().equals(DockFrontend.FRONTEND_EXTENSION)) {
            return this.createFrontendExtensions();
        }
        return null;
    }

    protected Collection<DockablePropertyFactory> createPropertyFactoryExtension() {
        ArrayList<DockablePropertyFactory> arrayList = new ArrayList<DockablePropertyFactory>();
        arrayList.add(new ToolbarPropertyFactory());
        arrayList.add(new ToolbarContainerPropertyFactory());
        arrayList.add(new ToolbarGroupPropertyFactory());
        return arrayList;
    }

    protected Collection<Merger> createMergerExtension() {
        ArrayList<Merger> arrayList = new ArrayList<Merger>();
        arrayList.add(new ToolbarDockStationMerger());
        arrayList.add(new ToolbarGroupDockStationMerger());
        return arrayList;
    }

    protected Collection<Inserter> createInserterExtension(DockController dockController) {
        ArrayList<Inserter> arrayList = new ArrayList<Inserter>();
        arrayList.add(new ScreenToolbarInserter(dockController));
        return arrayList;
    }

    protected Collection<AttractorStrategy> createAttractorStrategies() {
        ArrayList<AttractorStrategy> arrayList = new ArrayList<AttractorStrategy>();
        arrayList.add(new ToolbarAttractorStrategy());
        return arrayList;
    }

    protected Collection<DockFactory<?, ?, ?>> createDockFactories() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(new ToolbarGroupDockStationFactory());
        arrayList.add(new ToolbarDockStationFactory());
        arrayList.add(new ToolbarContainerDockStationFactory());
        arrayList.add(new ToolbarTabDockStationFactory());
        arrayList.add(new WizardSplitDockStationFactory());
        arrayList.add(new ToolbarItemDockableFactory());
        return arrayList;
    }

    protected Collection<DockTitleFactory> createTitleFactories(DockTitleVersion dockTitleVersion) {
        if (dockTitleVersion.getID().equals("screen dock")) {
            ArrayList<DockTitleFactory> arrayList = new ArrayList<DockTitleFactory>();
            arrayList.add(new ScreenToolbarDockTitleFactory(dockTitleVersion.getController()));
            return arrayList;
        }
        return null;
    }

    protected Collection<DisplayerFactory> createDisplayerFactories(DockController dockController, String string) {
        if (string.equals("screen")) {
            ArrayList<DisplayerFactory> arrayList = new ArrayList<DisplayerFactory>();
            arrayList.add(new ScreenToolbarDisplayerFactory(dockController));
            return arrayList;
        }
        return null;
    }

    protected Collection<ResourceBundle> createBundles(Locale locale) {
        ArrayList<ResourceBundle> arrayList = new ArrayList<ResourceBundle>();
        arrayList.add(ResourceBundle.getBundle("data.bibliothek.gui.toolbar.locale.toolbar", locale, this.getClass().getClassLoader()));
        return arrayList;
    }

    protected Collection<DockThemeExtension> createDockThemeExtension() {
        DockThemeExtension dockThemeExtension = new DockThemeExtension(){

            @Override
            public void installed(DockController dockController, DockTheme dockTheme) {
                ThemeManager themeManager = dockController.getThemeManager();
                themeManager.put(Priority.THEME, "dock.displayer.toolbar", ThemeManager.DISPLAYER_FACTORY_TYPE, ToolbarDockableDisplayer.FACTORY);
                themeManager.put(Priority.THEME, "dock.displayer.toolbar.simple", ThemeManager.DISPLAYER_FACTORY_TYPE, ToolbarDockableDisplayer.FACTORY);
                themeManager.put(Priority.THEME, "dock.displayer.toolbar.group", ThemeManager.DISPLAYER_FACTORY_TYPE, ToolbarDockableDisplayer.FACTORY);
                themeManager.put(Priority.THEME, "dock.displayer.toolbar.container", ThemeManager.DISPLAYER_FACTORY_TYPE, ToolbarDockableDisplayer.FACTORY);
                themeManager.put(Priority.THEME, "dock.displayer.toolbar.screen", ThemeManager.DISPLAYER_FACTORY_TYPE, ToolbarDockableDisplayer.FACTORY);
                DockTitleManager dockTitleManager = dockController.getDockTitleManager();
                dockTitleManager.registerTheme("toolbar.group", ToolbarDockTitlePoint.createFactory());
                dockTitleManager.registerTheme("toolbar", NullTitleFactory.INSTANCE);
                dockTitleManager.registerTheme("toolbar.container", ToolbarGroupTitle.FACTORY);
                dockTitleManager.registerTheme("toolbar.screen", ToolbarGroupTitle.FACTORY);
            }

            @Override
            public void install(DockController dockController, DockTheme dockTheme) {
            }

            @Override
            public void uninstall(DockController dockController, DockTheme dockTheme) {
            }
        };
        return Collections.singleton(dockThemeExtension);
    }

    protected Collection<ScreenDockWindowConfiguration> createWindowConfigurationExtension(DockController dockController) {
        ArrayList<ScreenDockWindowConfiguration> arrayList = new ArrayList<ScreenDockWindowConfiguration>();
        arrayList.add(new ToolbarWindowConfiguration(dockController));
        return arrayList;
    }

    protected Collection<DockableMovingImageFactory> createMovingImageFactory() {
        ArrayList<DockableMovingImageFactory> arrayList = new ArrayList<DockableMovingImageFactory>();
        arrayList.add(new ToolbarMovingImageFactory(new AncestorMovingImageFactory(null, 0.5f)));
        return arrayList;
    }

    protected Collection<ScreenDockStationExtension> createScreenDockStationExtension(DockController dockController) {
        ArrayList<ScreenDockStationExtension> arrayList = new ArrayList<ScreenDockStationExtension>();
        arrayList.add(new ToolbarScreenDockStationExtension(dockController));
        return arrayList;
    }

    protected Collection<FrontendPerspectiveCacheExtension> createPerspectiveCacheExtensions() {
        ArrayList<FrontendPerspectiveCacheExtension> arrayList = new ArrayList<FrontendPerspectiveCacheExtension>();
        arrayList.add(new ToolbarFrontendPerspectiveCacheExtension());
        return arrayList;
    }

    protected Collection<DockFrontendExtension> createFrontendExtensions() {
        ArrayList<DockFrontendExtension> arrayList = new ArrayList<DockFrontendExtension>();
        arrayList.add(new ToolbarDockFrontendExtension());
        return arrayList;
    }
}

