/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.group;

import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumn;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnListener;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnModel;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnModelListener;
import bibliothek.gui.dock.station.toolbar.title.ColumnDockActionSource;
import bibliothek.gui.dock.station.toolbar.title.ColumnDockActionSourceListener;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractToolbarGroupActions<P, C extends Column>
implements ColumnDockActionSource {
    private ToolbarColumnModel<Dockable, P> model;
    private List<C> columns = new ArrayList<C>();
    private List<ColumnDockActionSourceListener> listeners = new ArrayList<ColumnDockActionSourceListener>();
    private ToolbarGroupDockStation station;
    private ToolbarColumnModelListener<Dockable, P> modelListener = new ToolbarColumnModelListener<Dockable, P>(){

        @Override
        public void removed(ToolbarColumnModel<Dockable, P> toolbarColumnModel, ToolbarColumn<Dockable, P> toolbarColumn, int n) {
            Column column = (Column)AbstractToolbarGroupActions.this.columns.remove(n);
            for (ColumnDockActionSourceListener columnDockActionSourceListener : AbstractToolbarGroupActions.this.listeners()) {
                columnDockActionSourceListener.removed(AbstractToolbarGroupActions.this, column.getSource(), n);
            }
            column.destroy();
        }

        @Override
        public void inserted(ToolbarColumnModel<Dockable, P> toolbarColumnModel, ToolbarColumn<Dockable, P> toolbarColumn, int n) {
            Object c = AbstractToolbarGroupActions.this.createColumn(toolbarColumn);
            AbstractToolbarGroupActions.this.columns.add(n, c);
            for (ColumnDockActionSourceListener columnDockActionSourceListener : AbstractToolbarGroupActions.this.listeners()) {
                columnDockActionSourceListener.inserted(AbstractToolbarGroupActions.this, ((Column)c).getSource(), n);
            }
            int n2 = toolbarColumn.getDockableCount();
            for (int i = 0; i < n2; ++i) {
                ((Column)c).inserted(i, toolbarColumn.getItem(i));
            }
        }
    };
    private ComponentListener componentListener = new ComponentListener(){

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            for (ColumnDockActionSourceListener columnDockActionSourceListener : AbstractToolbarGroupActions.this.listeners()) {
                columnDockActionSourceListener.reshaped(AbstractToolbarGroupActions.this);
            }
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            for (ColumnDockActionSourceListener columnDockActionSourceListener : AbstractToolbarGroupActions.this.listeners()) {
                columnDockActionSourceListener.reshaped(AbstractToolbarGroupActions.this);
            }
        }
    };

    public AbstractToolbarGroupActions(ToolbarGroupDockStation toolbarGroupDockStation) {
        this.station = toolbarGroupDockStation;
    }

    @Override
    public void addListener(ColumnDockActionSourceListener columnDockActionSourceListener) {
        if (columnDockActionSourceListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(columnDockActionSourceListener);
    }

    @Override
    public void removeListener(ColumnDockActionSourceListener columnDockActionSourceListener) {
        this.listeners.remove(columnDockActionSourceListener);
    }

    protected ColumnDockActionSourceListener[] listeners() {
        return this.listeners.toArray(new ColumnDockActionSourceListener[this.listeners.size()]);
    }

    public void setModel(ToolbarColumnModel<Dockable, P> toolbarColumnModel) {
        if (this.model != toolbarColumnModel) {
            int n;
            if (this.model != null) {
                this.model.removeListener(this.modelListener);
                for (n = this.columns.size() - 1; n >= 0; --n) {
                    Column column = (Column)this.columns.get(n);
                    this.modelListener.removed(toolbarColumnModel, column.getColumn(), n);
                }
            }
            this.model = toolbarColumnModel;
            if (toolbarColumnModel != null) {
                toolbarColumnModel.addListener(this.modelListener);
                int n2 = toolbarColumnModel.getColumnCount();
                for (n = 0; n < n2; ++n) {
                    this.modelListener.inserted(toolbarColumnModel, toolbarColumnModel.getColumn((Dockable)n), n);
                }
            }
        }
    }

    public ToolbarColumnModel<Dockable, P> getModel() {
        return this.model;
    }

    protected List<C> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getSourceCount() {
        return this.getColumnCount();
    }

    @Override
    public DockActionSource getSource(int n) {
        return ((Column)this.getColumn(n)).getSource();
    }

    @Override
    public Orientation getOrientation() {
        return this.station.getOrientation();
    }

    public C getColumn(int n) {
        return (C)((Column)this.columns.get(n));
    }

    protected C getColumn(Dockable dockable) {
        for (Column column : this.columns) {
            if (!column.getDockables().contains(dockable)) continue;
            return (C)column;
        }
        return null;
    }

    @Override
    public int getSourceOffset(int n) {
        Rectangle rectangle = ((Column)this.getColumn(n)).getColumnBoundaries();
        if (rectangle == null) {
            return -1;
        }
        if (this.getOrientation() == Orientation.VERTICAL) {
            return rectangle.x;
        }
        return rectangle.y;
    }

    @Override
    public int getSourceLength(int n) {
        Rectangle rectangle = ((Column)this.getColumn(n)).getColumnBoundaries();
        if (rectangle == null) {
            return 0;
        }
        if (this.getOrientation() == Orientation.VERTICAL) {
            return rectangle.width;
        }
        return rectangle.height;
    }

    protected abstract C createColumn(ToolbarColumn<Dockable, P> var1);

    protected abstract Rectangle getBoundaries(P var1);

    protected abstract void installListener(P var1, ComponentListener var2);

    protected abstract void uninstallListener(P var1, ComponentListener var2);

    protected abstract class Column {
        private ToolbarColumn<Dockable, P> column;
        private boolean created = false;
        private DockActionSource source;
        private List<P> items = new ArrayList();
        private List<Dockable> dockables = new ArrayList<Dockable>();
        private ToolbarColumnListener<Dockable, P> listener = new ToolbarColumnListener<Dockable, P>(){

            @Override
            public void removed(ToolbarColumn<Dockable, P> toolbarColumn, P p, Dockable dockable, int n) {
                Column.this.items.remove(n);
                Column.this.dockables.remove(n);
                AbstractToolbarGroupActions.this.uninstallListener(p, AbstractToolbarGroupActions.this.componentListener);
                Column.this.removed(n, p);
            }

            @Override
            public void inserted(ToolbarColumn<Dockable, P> toolbarColumn, P p, Dockable dockable, int n) {
                Column.this.items.add(n, p);
                Column.this.dockables.add(n, dockable);
                AbstractToolbarGroupActions.this.installListener(p, AbstractToolbarGroupActions.this.componentListener);
                Column.this.inserted(n, p);
            }
        };

        public Column(ToolbarColumn<Dockable, P> toolbarColumn) {
            if (toolbarColumn != null) {
                this.init(toolbarColumn);
            }
        }

        protected void init(ToolbarColumn<Dockable, P> toolbarColumn) {
            this.column = toolbarColumn;
            this.column.addListener(this.listener);
            int n = toolbarColumn.getDockableCount();
            for (int i = 0; i < n; ++i) {
                this.listener.inserted(toolbarColumn, toolbarColumn.getItem(i), toolbarColumn.getDockable(i), i);
            }
        }

        public DockActionSource getSource() {
            if (!this.created) {
                this.created = true;
                this.source = this.createSource();
            }
            return this.source;
        }

        public List<P> getItems() {
            return Collections.unmodifiableList(this.items);
        }

        public List<Dockable> getDockables() {
            return Collections.unmodifiableList(this.dockables);
        }

        public ToolbarColumn<Dockable, P> getColumn() {
            return this.column;
        }

        public Rectangle getColumnBoundaries() {
            Rectangle rectangle = null;
            for (Object p : this.getItems()) {
                Rectangle rectangle2 = AbstractToolbarGroupActions.this.getBoundaries(p);
                if (rectangle == null) {
                    rectangle = new Rectangle(rectangle2);
                    continue;
                }
                rectangle = rectangle.union(rectangle2);
            }
            return rectangle;
        }

        protected abstract DockActionSource createSource();

        protected abstract void inserted(int var1, P var2);

        protected abstract void removed(int var1, P var2);

        private void destroy() {
            this.column.removeListener(this.listener);
            for (Object p : this.getItems()) {
                AbstractToolbarGroupActions.this.uninstallListener(p, AbstractToolbarGroupActions.this.componentListener);
            }
            this.removed();
        }

        protected abstract void removed();
    }
}

