/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.menu;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenuCallback;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenuContent;
import bibliothek.gui.dock.station.toolbar.menu.GroupedCustomizationMenuTitle;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class GroupedCustomizationMenuContent
implements CustomizationMenuContent {
    private int columns = 5;
    private List<Group> groups = new ArrayList<Group>();
    private JPanel view;
    private DockController controller;
    private CustomizationMenuCallback callback;
    private Insets insets = new Insets(2, 2, 2, 2);

    public Group addGroup(String string) {
        Group group = new Group(new GroupedCustomizationMenuTitle(string));
        this.addGroup(group);
        return group;
    }

    public void addGroup(Group group) {
        if (group == null) {
            throw new IllegalArgumentException("group is null");
        }
        if (this.groups.contains(group)) {
            throw new IllegalArgumentException("group was already added to this menu");
        }
        if (group.getOwner() != this) {
            throw new IllegalArgumentException("group was not created using this menu object");
        }
        this.groups.add(group);
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    public Group getGroup(int n) {
        return this.groups.get(n);
    }

    public void removeGroup(Group group) {
        this.groups.remove(group);
    }

    public void removeGroup(int n) {
        this.groups.remove(n);
    }

    @Override
    public Component getView() {
        return this.view;
    }

    @Override
    public void setController(DockController dockController) {
        if (this.controller != dockController) {
            this.controller = dockController;
            if (this.callback != null) {
                for (Group group : this.groups) {
                    group.setController(dockController);
                }
            }
        }
    }

    @Override
    public void bind(CustomizationMenuCallback customizationMenuCallback) {
        this.callback = customizationMenuCallback;
        for (Group object : this.groups) {
            object.setController(this.controller);
            object.bind(customizationMenuCallback);
        }
        this.view = new JPanel(new GridBagLayout());
        int n = 0;
        for (Group group : this.groups) {
            n += group.insertItems(n);
        }
    }

    @Override
    public void unbind() {
        for (Group group : this.groups) {
            group.unbind();
            group.setController(null);
        }
    }

    public class Group {
        private CustomizationMenuContent title;
        private List<CustomizationMenuContent> items = new ArrayList<CustomizationMenuContent>();

        public Group(CustomizationMenuContent customizationMenuContent) {
            this.title = customizationMenuContent;
        }

        public void setTitle(CustomizationMenuContent customizationMenuContent) {
            this.title = customizationMenuContent;
        }

        public CustomizationMenuContent getTitle() {
            return this.title;
        }

        private GroupedCustomizationMenuContent getOwner() {
            return GroupedCustomizationMenuContent.this;
        }

        private void setController(DockController dockController) {
            if (this.title != null) {
                this.title.setController(dockController);
            }
            for (CustomizationMenuContent customizationMenuContent : this.items) {
                customizationMenuContent.setController(dockController);
            }
        }

        private void bind(CustomizationMenuCallback customizationMenuCallback) {
            if (this.title != null) {
                this.title.bind(customizationMenuCallback);
            }
            for (CustomizationMenuContent customizationMenuContent : this.items) {
                customizationMenuContent.bind(customizationMenuCallback);
            }
        }

        private int insertItems(int n) {
            int n2 = n;
            if (this.title != null) {
                GroupedCustomizationMenuContent.this.view.add(this.title.getView(), new GridBagConstraints(0, n, GroupedCustomizationMenuContent.this.columns, 1, 1.0, 0.01, 10, 2, GroupedCustomizationMenuContent.this.insets, 0, 0));
                ++n;
            }
            int n3 = 0;
            int n4 = this.items.size();
            while (n3 < n4) {
                for (int i = 0; i < GroupedCustomizationMenuContent.this.columns && n3 < n4; ++i) {
                    GroupedCustomizationMenuContent.this.view.add(this.items.get(n3++).getView(), new GridBagConstraints(i, n, 1, 1, 1.0, 1.0, 10, 1, GroupedCustomizationMenuContent.this.insets, 0, 0));
                }
                ++n;
            }
            return n - n2;
        }

        private void unbind() {
            if (this.title != null) {
                this.title.unbind();
            }
            for (CustomizationMenuContent customizationMenuContent : this.items) {
                customizationMenuContent.unbind();
            }
        }

        public void add(CustomizationMenuContent customizationMenuContent) {
            this.add(this.getItemCount(), customizationMenuContent);
        }

        public void add(int n, CustomizationMenuContent customizationMenuContent) {
            this.items.add(n, customizationMenuContent);
        }

        public void remove(CustomizationMenuContent customizationMenuContent) {
            if (this.items.remove(customizationMenuContent)) {
                // empty if block
            }
        }

        public void remove(int n) {
            this.items.remove(n);
        }

        public int getItemCount() {
            return this.items.size();
        }

        public CustomizationMenuContent getItem(int n) {
            return this.items.get(n);
        }
    }
}

