/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.BoundingLeaf;
import org.jogamp.java3d.MediaContainer;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.Sound;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.LeafState;

public abstract class SoundState
extends LeafState {
    private int boundingLeaf;
    private int mediaContainer;

    public SoundState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            this.boundingLeaf = control.getSymbolTable().addReference((SceneGraphObject)((Sound)this.node).getSchedulingBoundingLeaf());
            this.mediaContainer = control.getSymbolTable().addReference((SceneGraphObject)((Sound)this.node).getSoundData());
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        Sound sound = (Sound)this.node;
        out.writeBoolean(sound.getContinuousEnable());
        out.writeBoolean(sound.getEnable());
        out.writeFloat(sound.getInitialGain());
        out.writeInt(sound.getLoop());
        out.writeFloat(sound.getPriority());
        out.writeBoolean(sound.getReleaseEnable());
        out.writeInt(this.boundingLeaf);
        this.control.writeBounds(out, sound.getSchedulingBounds());
        out.writeInt(this.mediaContainer);
        out.writeBoolean(sound.getMute());
        out.writeBoolean(sound.getPause());
        out.writeFloat(sound.getRateScaleFactor());
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        Sound sound = (Sound)this.node;
        sound.setContinuousEnable(in.readBoolean());
        sound.setEnable(in.readBoolean());
        sound.setInitialGain(in.readFloat());
        sound.setLoop(in.readInt());
        sound.setPriority(in.readFloat());
        sound.setReleaseEnable(in.readBoolean());
        this.boundingLeaf = in.readInt();
        sound.setSchedulingBounds(this.control.readBounds(in));
        this.mediaContainer = in.readInt();
        sound.setMute(in.readBoolean());
        sound.setPause(in.readBoolean());
        sound.setRateScaleFactor(in.readFloat());
    }

    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.mediaContainer);
    }

    @Override
    public void buildGraph() {
        ((Sound)this.node).setSchedulingBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.boundingLeaf));
        ((Sound)this.node).setSoundData((MediaContainer)this.control.getSymbolTable().getJ3dNode(this.mediaContainer));
        super.buildGraph();
    }
}

