kernel void identifiePointsRasants_NEW(global uchar4 *depthBuffer, global int *depthBufferFlags, global int *imgBufferFlags, 
								 int depthW, int depthH, int imageWidthIncludingMargin, int imageH, int imageMargin,
								 float gradiantNormRatioWrtCurrDistance_MaxValueAllowed, float gradiantThresholdPower, float distanceDeReference)
{
	int depthIndex = get_global_id(0);
	if (depthIndex >= depthW*depthH)  
	{
		return;
	}
	int depthRow = (int)(depthIndex/depthW);
	int depthCol = depthIndex-depthW*depthRow;
	
	if ((depthCol>=depthW)||(depthRow>=depthH))
	{
		return;
	}
	
	int2 ColRowInImageBuf = srcColRow2destColRow_Panoramic(depthCol, depthRow, 0, depthW, imageMargin, imageWidthIncludingMargin);
	int imageIndex = ColRowInImageBuf.y*imageWidthIncludingMargin+ColRowInImageBuf.x;
	
	uchar4 depthInfo = depthBuffer[depthIndex];
	float3 localCoords = getDepthBufferLocalCoordinates(depthInfo, depthCol, depthRow, depthW, depthH);
	if ((localCoords.x==0.f)&&(localCoords.y==0.f)&&(localCoords.z==0.f))
	{
		return;
	}

	float currentDistance = getDepthBufferLocalDistance(depthInfo);
	
	float gradiantNorm_minFound = infinity;
	int halfSize = 1;
	for (int ir=-halfSize; ir<=halfSize; ir++)
	{
		int iRow = depthRow+ir;
		if ((iRow>=0)&&(iRow<depthH))
		{
			for (int ic=-halfSize; ic<=halfSize; ic++)
			{
				if ((ir!=0)||(ic!=0))
				{
					int iCol = depthCol+ic;
					if (iCol<0) iCol+=depthW;
					if (iCol>=depthW) iCol-=depthW;
					uchar4 neighDepthInfo = depthBuffer[iRow*depthW + iCol];
					float neighD = getDepthBufferLocalDistance(neighDepthInfo);
					if (neighD>0.0f)
					{
						float neighD_pix = sqrt((float)(ir*ir+ic*ic));
						float gradiantNorm = fabs(neighD-currentDistance)/neighD_pix;
						//float gradiantNorm = fabs(neighD-currentDistance);
						if (gradiantNorm<gradiantNorm_minFound)
						{
							gradiantNorm_minFound = gradiantNorm;
						}
					}					
				}
			}
		}
	}
	int bElimine = 0;	
	if (gradiantNorm_minFound==infinity)
	{
		bElimine = 1;
	}
	else
	{
		if (distanceDeReference==0)
		{
			if (gradiantNorm_minFound>gradiantNormRatioWrtCurrDistance_MaxValueAllowed*currentDistance)
			{
			   bElimine = 1;
			}
		}
		else
		{
			if (gradiantNorm_minFound>gradiantNormRatioWrtCurrDistance_MaxValueAllowed*pow(currentDistance/distanceDeReference, gradiantThresholdPower))
			{
			   bElimine = 1;
			}
		}	
	}
	
	if (bElimine==1)
	{
		//depthBuffer[depthIndex] = (uchar4)(0);
		depthBufferFlags[depthIndex] = 1;
		imgBufferFlags[imageIndex] = 1;
	}
}




kernel void identifiePointsRasants_Col_Row(global const uchar4 *depthBuffer, global int *depthBufferFlags, global int *imgBufferFlags,
								 int depthW, int depthH, int imageWidthIncludingMargin, int imageH, int imageMargin,
								 float gradiantNormRatioWrtCurrDistance_MaxValueAllowed, float gradiantThresholdPower, float distanceDeReference)
{

	int depthIndex = get_global_id(0);
	if (depthIndex >= depthW*depthH)  
	{
		return;
	}
	int depthRow = (int)(depthIndex/depthW);
	int depthCol = depthIndex-depthW*depthRow;
	
	if ((depthCol>=depthW)||(depthRow>=depthH))
	{
		return;
	}
	
	int2 ColRowInImageBuf = srcColRow2destColRow_Panoramic(depthCol, depthRow, 0, depthW, imageMargin, imageWidthIncludingMargin);
	int imageIndex = ColRowInImageBuf.y*imageWidthIncludingMargin+ColRowInImageBuf.x;
	
	uchar4 depthInfo = depthBuffer[depthIndex];
	float currentDistance = getDepthBufferLocalDistance(depthInfo);
	if (currentDistance==0.f)
	{
		return;
	}

	int offsetMax = 10;
	
	float gradiantDistance_Col;
	
	int bFoundPreviousCol = 0;
	int bDone = 0;
	int previousCol = depthCol-1;
	int offsetPreviousCol = 1;
	uchar4 depthInfoPreviousCol = (uchar4)(0);
	while (bDone==0)
	{
		if (previousCol<0) previousCol+=depthW;
		int depthIndexPreviousCol = depthRow*depthW + previousCol;
		depthInfoPreviousCol = depthBuffer[depthIndexPreviousCol];
		if ((depthInfoPreviousCol.x!=0.f)||(depthInfoPreviousCol.y!=0.f)||(depthInfoPreviousCol.z!=0.f))
		{
			bFoundPreviousCol = 1;
			bDone = 1;
			break;
		}
		else
		{
			previousCol--;
			offsetPreviousCol++;
			if (offsetPreviousCol>offsetMax)
			{
				bDone = 1;
				break;
			}
		}
	}
	if (bFoundPreviousCol==0)
	{
		bDone = 0;
		previousCol = depthCol+1;
		offsetPreviousCol = -1;
		while (bDone==0)
		{
			if (previousCol>=depthW) previousCol-=depthW;
			depthInfoPreviousCol = depthBuffer[depthRow*depthW + previousCol];
			if ((depthInfoPreviousCol.x!=0.f)||(depthInfoPreviousCol.y!=0.f)||(depthInfoPreviousCol.z!=0.f))
			{
				bFoundPreviousCol = 1;
				bDone = 1;
				break;
			}
			else
			{
				previousCol++;
				offsetPreviousCol--;
				if (offsetPreviousCol<-offsetMax)
				{
					bDone = 1;
					break;
				}
			}
		}			
	}	
	if (bFoundPreviousCol==0)
	{
		depthBufferFlags[depthIndex] = 1;
		imgBufferFlags[imageIndex] = 1;
		return;
	}	


	float previousDistance = getDepthBufferLocalDistance(depthInfoPreviousCol);
	gradiantDistance_Col = fabs(currentDistance-previousDistance)/fabs((float)offsetPreviousCol);
	
	int bElimine = 0;
	if (distanceDeReference==0)
	{
		if (gradiantDistance_Col>gradiantNormRatioWrtCurrDistance_MaxValueAllowed*currentDistance)
		{
		   bElimine = 1;
		}
	}
	else
	{
		if (gradiantDistance_Col>gradiantNormRatioWrtCurrDistance_MaxValueAllowed*pow(currentDistance/distanceDeReference, gradiantThresholdPower))
		{
		   bElimine = 1;
		}
	}		
	if (bElimine==1)
	{
		depthBufferFlags[depthIndex] = 1;
		imgBufferFlags[imageIndex] = 1;
		return;
	}	
	
	
	int bFoundPreviousRow = 0;
	bDone = 0;
	int previousRow = depthRow-1;
	int offsetPreviousRow = 1;
	uchar4 depthInfoPreviousRow = (uchar4)(0);
	while (bDone==0)
	{
		if (previousRow<0)
		{
			bDone = 1;
			break;
		}
		int depthIndexPreviousRow = previousRow*depthW + depthCol;
		depthInfoPreviousRow = depthBuffer[depthIndexPreviousRow];
		if ((depthInfoPreviousRow.x!=0.f)||(depthInfoPreviousRow.y!=0.f)||(depthInfoPreviousRow.z!=0.f))
		{
			bFoundPreviousRow = 1;
			bDone = 1;
			break;
		}
		else
		{
			previousRow--;
			offsetPreviousRow++;
			if (offsetPreviousRow>offsetMax)
			{
				bDone = 1;
				break;
			}
		}
	}	
	
	if (bFoundPreviousRow==0)
	{
		bDone = 0;
		previousRow = depthRow+1;
		offsetPreviousRow = -1;
		while (bDone==0)
		{
			if (previousRow>=depthH)
			{
				bDone = 1;
				break;
			}
			depthInfoPreviousRow = depthBuffer[previousRow*depthW + depthCol];
			if ((depthInfoPreviousRow.x!=0.f)||(depthInfoPreviousRow.y!=0.f)||(depthInfoPreviousRow.z!=0.f))
			{
				bFoundPreviousRow = 1;
				bDone = 1;
				break;
			}
			else
			{
				previousRow++;
				offsetPreviousRow--;
				if (offsetPreviousRow<-offsetMax)
				{
					bDone = 1;
					break;
				}
			}
		}	

	}	
	
	
	if (bFoundPreviousRow==0)
	{
		depthBufferFlags[depthIndex] = 1;
		imgBufferFlags[imageIndex] = 1;
		return;
	}		
	

	previousDistance = getDepthBufferLocalDistance(depthInfoPreviousRow);
	float gradiantDistance_Row = fabs(currentDistance-previousDistance)/fabs((float)offsetPreviousCol);

	bElimine = 0;
	if (distanceDeReference==0)
	{
		if (gradiantDistance_Row>gradiantNormRatioWrtCurrDistance_MaxValueAllowed*currentDistance)
		{
		   bElimine = 1;
		}
	}
	else
	{
		if (gradiantDistance_Row>gradiantNormRatioWrtCurrDistance_MaxValueAllowed*pow(currentDistance/distanceDeReference, gradiantThresholdPower))
		{
		   bElimine = 1;
		}
	}		
	if (bElimine==1)
	{
		depthBufferFlags[depthIndex] = 1;
		imgBufferFlags[imageIndex] = 1;
		return;
	}

}



kernel void identifiePointsRasants_Col_Row_METRE(global uchar4 *depthBuffer, global int *depthBufferFlags, global int *imgBufferFlags, 
                                 int depthW, int depthH, int imageWidthIncludingMargin, int imageH, int imageMargin,
                                 float gradiantNormRatioWrtCurrDistance_MaxValueAllowed, float gradiantThresholdPower, float distanceDeReference)
{
    int depthIndex = get_global_id(0);
    if (depthIndex >= depthW*depthH)  
    {
        return;
    }
    int depthRow = (int)(depthIndex/depthW);
    int depthCol = depthIndex-depthW*depthRow;
    
    if ((depthCol>=depthW)||(depthRow>=depthH))
    {
        return;
    }
    
    int2 ColRowInImageBuf = srcColRow2destColRow_Panoramic(depthCol, depthRow, 0, depthW, imageMargin, imageWidthIncludingMargin);
    int imageIndex = ColRowInImageBuf.y*imageWidthIncludingMargin+ColRowInImageBuf.x;
    
    uchar4 depthInfo = depthBuffer[depthIndex];
    float currentDistance = getDepthBufferLocalDistance(depthInfo);
    if (currentDistance==0.f)
    {
        return;
    }
    float3 localP = getDepthBufferLocalCoordinates(depthInfo, depthCol, depthRow, depthW, depthH);
    float3 localN = (float3)(localP.x, localP.y, localP.z);
    localN/=currentDistance;
    int offsetMax = 10;
    
    
    int bFoundPreviousCol = 0;
    int depthIndexPreviousCol = -1;
    int bDone = 0;
    int previousCol = depthCol-1;
    int offsetPreviousCol = 1;
    uchar4 depthInfoPreviousCol = (uchar4)(0);
    while (bDone==0)
    {
        if (previousCol<0) previousCol+=depthW;
        depthIndexPreviousCol = depthRow*depthW + previousCol;
        depthInfoPreviousCol = depthBuffer[depthIndexPreviousCol];
        if ((depthInfoPreviousCol.x!=0.f)||(depthInfoPreviousCol.y!=0.f)||(depthInfoPreviousCol.z!=0.f))
        {
            bFoundPreviousCol = 1;
            bDone = 1;
            break;
        }
        else
        {
            previousCol--;
            offsetPreviousCol++;
            if (offsetPreviousCol>offsetMax)
            {
                bDone = 1;
                break;
            }
        }
    }
    if (bFoundPreviousCol==0)
    {
        bDone = 0;
        previousCol = depthCol+1;
        offsetPreviousCol = -1;
        while (bDone==0)
        {
            if (previousCol>=depthW) previousCol-=depthW;
            depthIndexPreviousCol = depthRow*depthW + previousCol;
            depthInfoPreviousCol = depthBuffer[depthIndexPreviousCol];
            if ((depthInfoPreviousCol.x!=0.f)||(depthInfoPreviousCol.y!=0.f)||(depthInfoPreviousCol.z!=0.f))
            {
                bFoundPreviousCol = 1;
                bDone = 1;
                break;
            }
            else
            {
                previousCol++;
                offsetPreviousCol--;
                if (offsetPreviousCol<-offsetMax)
                {
                    bDone = 1;
                    break;
                }
            }
        }           
    }   
    if (bFoundPreviousCol==0)
    {
        depthBufferFlags[depthIndex] = 1;
        imgBufferFlags[imageIndex] = 1;
        return;
    }   
    float gradiantDistance_Col;
    int depthRow_tmp = (int)(depthIndexPreviousCol/depthW);
    int depthCol_tmp = depthIndexPreviousCol-depthW*depthRow_tmp;
    float3 localNeigh = getDepthBufferLocalCoordinates(depthInfoPreviousCol, depthCol_tmp, depthRow_tmp, depthW, depthH);           
    float3 Pproj = projectionSurPlan(localNeigh, localP, localN);
    float d_n = sqrt((Pproj.x-localNeigh.x)*(Pproj.x-localNeigh.x)+(Pproj.y-localNeigh.y)*(Pproj.y-localNeigh.y)+(Pproj.z-localNeigh.z)*(Pproj.z-localNeigh.z));
    float d_uv = sqrt((Pproj.x-localP.x)*(Pproj.x-localP.x)+(Pproj.y-localP.y)*(Pproj.y-localP.y)+(Pproj.z-localP.z)*(Pproj.z-localP.z));
    float d = sqrt((localNeigh.x-localP.x)*(localNeigh.x-localP.x)+(localNeigh.y-localP.y)*(localNeigh.y-localP.y)+(localNeigh.z-localP.z)*(localNeigh.z-localP.z));
    float DY = d;
    float DX = d_uv;
    gradiantDistance_Col = DY/DX;
    
    int bElimine = 0;
    if (distanceDeReference==0)
    {
        if (gradiantDistance_Col>gradiantNormRatioWrtCurrDistance_MaxValueAllowed*currentDistance)
        {
           bElimine = 1;
        }
    }
    else
    {
        if (gradiantDistance_Col>gradiantNormRatioWrtCurrDistance_MaxValueAllowed*pow(currentDistance/distanceDeReference, gradiantThresholdPower))
        {
           bElimine = 1;
        }
    }       
    if (bElimine==1)
    {
        depthBufferFlags[depthIndex] = 1;
        imgBufferFlags[imageIndex] = 1;
        return;
    }   
    
    
    int bFoundPreviousRow = 0;
    int depthIndexPreviousRow = -1;
    bDone = 0;
    int previousRow = depthRow-1;
    int offsetPreviousRow = 1;
    uchar4 depthInfoPreviousRow = (uchar4)(0);
    while (bDone==0)
    {
        if (previousRow<0)
        {
            bDone = 1;
            break;
        }
        depthIndexPreviousRow = previousRow*depthW + depthCol;
        depthInfoPreviousRow = depthBuffer[depthIndexPreviousRow];
        if ((depthInfoPreviousRow.x!=0.f)||(depthInfoPreviousRow.y!=0.f)||(depthInfoPreviousRow.z!=0.f))
        {
            bFoundPreviousRow = 1;
            bDone = 1;
            break;
        }
        else
        {
            previousRow--;
            offsetPreviousRow++;
            if (offsetPreviousRow>offsetMax)
            {
                bDone = 1;
                break;
            }
        }
    }   
    
    if (bFoundPreviousRow==0)
    {
        bDone = 0;
        previousRow = depthRow+1;
        offsetPreviousRow = -1;
        while (bDone==0)
        {
            if (previousRow>=depthH)
            {
                bDone = 1;
                break;
            }
            depthIndexPreviousRow = previousRow*depthW + depthCol;
            depthInfoPreviousRow = depthBuffer[depthIndexPreviousRow];
            if ((depthInfoPreviousRow.x!=0.f)||(depthInfoPreviousRow.y!=0.f)||(depthInfoPreviousRow.z!=0.f))
            {
                bFoundPreviousRow = 1;
                bDone = 1;
                break;
            }
            else
            {
                previousRow++;
                offsetPreviousRow--;
                if (offsetPreviousRow<-offsetMax)
                {
                    bDone = 1;
                    break;
                }
            }
        }   
    }   
    
    
    if (bFoundPreviousRow==0)
    {
        depthBufferFlags[depthIndex] = 1;
        imgBufferFlags[imageIndex] = 1;
        return;
    }       
    
    depthRow_tmp = (int)(depthIndexPreviousRow/depthW);
    depthCol_tmp = depthIndexPreviousRow-depthW*depthRow_tmp;
    localNeigh = getDepthBufferLocalCoordinates(depthInfoPreviousRow, depthCol_tmp, depthRow_tmp, depthW, depthH);          
    Pproj = projectionSurPlan(localNeigh, localP, localN);
    d_n = sqrt((Pproj.x-localNeigh.x)*(Pproj.x-localNeigh.x)+(Pproj.y-localNeigh.y)*(Pproj.y-localNeigh.y)+(Pproj.z-localNeigh.z)*(Pproj.z-localNeigh.z));
    d_uv = sqrt((Pproj.x-localP.x)*(Pproj.x-localP.x)+(Pproj.y-localP.y)*(Pproj.y-localP.y)+(Pproj.z-localP.z)*(Pproj.z-localP.z));
    d = sqrt((localNeigh.x-localP.x)*(localNeigh.x-localP.x)+(localNeigh.y-localP.y)*(localNeigh.y-localP.y)+(localNeigh.z-localP.z)*(localNeigh.z-localP.z));
    DY = d;
    DX = d_uv;
    float gradiantDistance_Row = DY/DX;
    bElimine = 0;
    if (distanceDeReference==0)
    {
        if (gradiantDistance_Row>gradiantNormRatioWrtCurrDistance_MaxValueAllowed*currentDistance)
        {
           bElimine = 1;
        }
    }
    else
    {
        if (gradiantDistance_Row>gradiantNormRatioWrtCurrDistance_MaxValueAllowed*pow(currentDistance/distanceDeReference, gradiantThresholdPower))
        {
           bElimine = 1;
        }
    }       
    if (bElimine==1)
    {
        depthBufferFlags[depthIndex] = 1;
        imgBufferFlags[imageIndex] = 1;
        return;
    }
}



kernel void identifiePointsRasants(global uchar4 *depthBuffer, global int *depthBufferFlags, global int *imgBufferFlags, 
								 int depthW, int depthH, int imageWidthIncludingMargin, int imageH, int imageMargin,
								 float gradiantNormRatioWrtCurrDistance_MaxValueAllowed, float gradiantThresholdPower, float distanceDeReference, 
								 int bElimineSiPointIsole, float acceptanceRatio, float fillRatioThreshold)
{
	int depthIndex = get_global_id(0);
	if (depthIndex >= depthW*depthH)  
	{
		return;
	}
	int depthRow = (int)(depthIndex/depthW);
	int depthCol = depthIndex-depthW*depthRow;
	
	if ((depthCol>=depthW)||(depthRow>=depthH))
	{
		return;
	}
	
	int2 ColRowInImageBuf = srcColRow2destColRow_Panoramic(depthCol, depthRow, 0, depthW, imageMargin, imageWidthIncludingMargin);
	int imageIndex = ColRowInImageBuf.y*imageWidthIncludingMargin+ColRowInImageBuf.x;
	
	uchar4 depthInfo = depthBuffer[depthIndex];
	float3 localCoords = getDepthBufferLocalCoordinates(depthInfo, depthCol, depthRow, depthW, depthH);
	if ((localCoords.x==0.f)&&(localCoords.y==0.f)&&(localCoords.z==0.f))
	{
		return;
	}

	float currentDistance = getDepthBufferLocalDistance(depthInfo);
	
	int offsetMax = 10;
	int bFoundPreviousCol = 0;
	int bDone = 0;
	int previousCol = depthCol-1;
	int offsetPreviousCol = 1;
	uchar4 depthInfoPreviousCol = (uchar4)(0);
	while (bDone==0)
	{
		if (previousCol<0) previousCol+=depthW;
		int depthIndexPreviousCol = depthRow*depthW + previousCol;
		depthInfoPreviousCol = depthBuffer[depthIndexPreviousCol];
		if ((depthInfoPreviousCol.x!=0.f)||(depthInfoPreviousCol.y!=0.f)||(depthInfoPreviousCol.z!=0.f))
		{
			bFoundPreviousCol = 1;
			bDone = 1;
			break;
		}
		else
		{
			previousCol--;
			offsetPreviousCol++;
			if (offsetPreviousCol>offsetMax)
			{
				bDone = 1;
				break;
			}
		}
	}
	float previousDistance;
	float gradiantDistance;
	float gradiantNorm = 0;
	if (bFoundPreviousCol)
	{
		previousDistance = getDepthBufferLocalDistance(depthInfoPreviousCol);
		gradiantDistance = (currentDistance-previousDistance)/offsetPreviousCol;
		gradiantNorm += gradiantDistance*gradiantDistance;
	}

	int bFoundPreviousRow = 0;
	bDone = 0;
	int previousRow = depthRow-1;
	int offsetPreviousRow = 1;
	uchar4 depthInfoPreviousRow = (uchar4)(0);
	while (bDone==0)
	{
		if (previousRow<0)
		{
			bDone = 1;
			break;
		}
		int depthIndexPreviousRow = previousRow*depthW + depthCol;
		depthInfoPreviousRow = depthBuffer[depthIndexPreviousRow];
		if ((depthInfoPreviousRow.x!=0.f)||(depthInfoPreviousRow.y!=0.f)||(depthInfoPreviousRow.z!=0.f))
		{
			bFoundPreviousRow = 1;
			bDone = 1;
			break;
		}
		else
		{
			previousRow--;
			offsetPreviousRow++;
			if (offsetPreviousRow>offsetMax)
			{
				bDone = 1;
				break;
			}
		}
	}	
	if (bFoundPreviousRow)
	{
		previousDistance = getDepthBufferLocalDistance(depthInfoPreviousRow);
		gradiantDistance = (currentDistance-previousDistance)/offsetPreviousRow;
		gradiantNorm += gradiantDistance*gradiantDistance;
	}
	gradiantNorm = sqrt(gradiantNorm);
	
	
	
	
	int estPointIsole = 0;
	if (bElimineSiPointIsole==1)
	{
		int searchHalfSize = 5;
		int searchSize = 2*searchSize+1;
		int searchSurface = searchSize*searchSize;
		float3 neighborsGrid[121] = {0};
		int neighborsGrid_flags[121] = {0};
		int neighborsGrid_topologyIds[121] = {0};
		float3 pivot, neighbor;
		int coldum, rowdum;
		float dist;
		int ir, ic, iRow, iCol;
		uchar4 depthInfoNeigh;
		for (ic=-searchHalfSize; ic<=searchHalfSize; ic++)
		{
			iCol = depthCol+ic;
			if (iCol<0) iCol+=depthW;
			if (iCol>=depthW) iCol-=depthW;
			for (ir=-searchHalfSize; ir<=searchHalfSize; ir++)
			{
				iRow = depthRow+ir;
				if ((iRow>=0)&&(iRow<depthH))
				{
					depthInfoNeigh = depthBuffer[depthW*iRow+iCol];
					neighbor = getDepthBufferLocalCoordinates(depthInfoNeigh, iCol, iRow, depthW, depthH);
					if ((neighbor.x!=0.f)||(neighbor.y!=0.f)||(neighbor.z!=0.f))
					{
						neighborsGrid[(searchHalfSize+ir)*searchSize + searchHalfSize+ic] = neighbor;
					}
				}
			}
		}
		neighborsGrid_flags[(searchHalfSize)*searchSize+searchHalfSize] = 1;
		int bFoundSpatialNeighbor;
		float pivotDistToCenter;
		
		float theta_1pixel = (float)(2.f*M_PI_F/(float)depthW);
		float pixelDimension_1meter = 2.f*tan(0.5f*theta_1pixel);
		
		for (iRow=0; iRow<searchSize; iRow++)
		{
			for (iCol=0; iCol<searchSize; iCol++)
			{
				pivot = neighborsGrid[iRow*searchSize+iCol];
				
				pivotDistToCenter = sqrt(pivot.x*pivot.x+pivot.y*pivot.y+pivot.z*pivot.z);
	
				bFoundSpatialNeighbor = 0;
				if ((pivot.x!=0.f)||(pivot.y!=0.f)||(pivot.z!=0.f))
				{
					for (ir=-1; ir<=1; ir++)
					{
						rowdum = iRow+ir;
						if ((rowdum>=0)&&(rowdum<searchSize))
						{
							for (ic=-1; ic<=1; ic++)
							{
								if ((ir!=0)||(ic!=0))
								{
									coldum = iCol+ic;
									if ((coldum>=0)&&(coldum<searchSize))
									{
										neighbor = neighborsGrid[rowdum*searchSize+coldum];
										if ((neighbor.x!=0.f)||(neighbor.y!=0.f)||(neighbor.z!=0.f))
										{
											dist = sqrt((pivot.x-neighbor.x)*(pivot.x-neighbor.x)+(pivot.y-neighbor.y)*(pivot.y-neighbor.y)+(pivot.z-neighbor.z)*(pivot.z-neighbor.z));
											if (dist<acceptanceRatio*pixelDimension_1meter*pivotDistToCenter)
											{
												neighborsGrid_flags[iRow*searchSize+iCol] = 1;
												bFoundSpatialNeighbor = 1;
												break;
											}
										}
									}
								}
							}
						}
						if (bFoundSpatialNeighbor==1)
						{
							break;
						}
					}
				}
			}
		}
		
		identifyDistinctForms(neighborsGrid_flags, neighborsGrid_topologyIds, searchSize, searchSize);
		int centricFormId = neighborsGrid_topologyIds[(searchHalfSize)*searchSize+searchHalfSize];

		int nbNeighbors = 0;
		for (int i=0; i<searchSize*searchSize; i++)
		{
			if (neighborsGrid_topologyIds[i]==centricFormId)
			{
			 	neighbor = neighborsGrid[i];
			 	if ((neighbor.x!=0.f)||(neighbor.y!=0.f)||(neighbor.z!=0.f))
			 	{
			 		nbNeighbors++;
			 	}
			}
		}	
		
		int nbNeighborsMin = (int)(fillRatioThreshold*searchSurface);
		if (nbNeighbors<nbNeighborsMin)
		{
			estPointIsole = 1;
		}
	}
	
	int isGap = 0;
	if (distanceDeReference==0)
	{
		if (gradiantNorm>gradiantNormRatioWrtCurrDistance_MaxValueAllowed*currentDistance)
		{
		   isGap = 1;
		}
	}
	else
	{
		if (gradiantNorm>gradiantNormRatioWrtCurrDistance_MaxValueAllowed*pow(currentDistance/distanceDeReference, gradiantThresholdPower))
		{
		   isGap = 1;
		}
	}	

	int bElimine = 0;	
	if (bElimineSiPointIsole)
	{
		if ((isGap==1)&&(estPointIsole==1))
		{
			bElimine = 1;
		}
	}
	else
	{
		bElimine = isGap;
	}

	if (bElimine==1)
	{
		//depthBuffer[depthIndex] = (uchar4)(0);
		depthBufferFlags[depthIndex] = 1;
		imgBufferFlags[imageIndex] = 1;
	}
}

kernel void identifiePointsRasants_avecNormalBuffer(global uchar4 *depthBuffer, global const uchar4 *normalBuffer, global int *depthBufferFlags, global int *imgBufferFlags, 
								 int depthW, int depthH, int normalWidth, int imageWidthIncludingMargin, int imageH, int imageMargin)
{
	int depthIndex = get_global_id(0);
	if (depthIndex >= depthW*depthH)  
	{
		return;
	}
	int depthRow = (int)(depthIndex/depthW);
	int depthCol = depthIndex-depthW*depthRow;
	
	if ((depthCol>=depthW)||(depthRow>=depthH))
	{
		return;
	}
	
	int2 ColRowInImageBuf = srcColRow2destColRow_Panoramic(depthCol, depthRow, 0, depthW, imageMargin, imageWidthIncludingMargin);
	int imageIndex = ColRowInImageBuf.y*imageWidthIncludingMargin+ColRowInImageBuf.x;
	
	uchar4 depthInfo = depthBuffer[depthIndex];
	float3 localCoords = getDepthBufferLocalCoordinates(depthInfo, depthCol, depthRow, depthW, depthH);
	if ((localCoords.x==0.f)&&(localCoords.y==0.f)&&(localCoords.z==0.f))
	{
		return;
	}

    int2 ColRowInNormalBuf = srcColRow2destColRow_Panoramic(depthCol, depthRow, 0, depthW, 0, normalWidth);
    float4 localNormalInfo = getNormalInfo(normalBuffer, ColRowInNormalBuf.x, ColRowInNormalBuf.y, normalWidth, normalWidth/2);
    int bElimine = 0;
    if (localNormalInfo.w==255)
	{
		bElimine = 1;
	}
	else
	{
		float3 localDirection = getLocalDirection_Panoramic((float)depthCol+0.5f, (float)depthRow+0.5f, depthW, depthH);
		float fdot = fabs(dot(localDirection.xyz, localNormalInfo.xyz));
		if (fabs(fdot)<0.01f)
		{
		   bElimine = 1;
		}
	}
	if (bElimine==1)
	{
		//depthBuffer[depthIndex] = (uchar4)(0);
		depthBufferFlags[depthIndex] = 1;
		imgBufferFlags[imageIndex] = 1;
	}
}


kernel void eliminePointsRasants(global uchar4 *depthBuffer, global const uchar4 *normalBuffer, global uchar4 *imgBuffer, 
								 int depthW, int depthH, int normalWidth, int imageWidthIncludingMargin, int imageH, int imageMargin, 
								 global uchar4 *resultImgBuffer)
{
	int depthIndex = get_global_id(0);
	if (depthIndex >= depthW*depthH)  
	{
		return;
	}
	int depthRow = (int)(depthIndex/depthW);
	int depthCol = depthIndex-depthW*depthRow;
	
	if ((depthCol>=depthW)||(depthRow>=depthH))
	{
		return;
	}
	
	int2 ColRowInImageBuf = srcColRow2destColRow_Panoramic(depthCol, depthRow, 0, depthW, imageMargin, imageWidthIncludingMargin);
	int imageIndex = ColRowInImageBuf.y*imageWidthIncludingMargin+ColRowInImageBuf.x;
	
	uchar4 depthInfo = depthBuffer[depthIndex];
	float3 localCoords = getDepthBufferLocalCoordinates(depthInfo, depthCol, depthRow, depthW, depthH);
	if ((localCoords.x==0.f)&&(localCoords.y==0.f)&&(localCoords.z==0.f))
	{
		return;
	}

    int2 ColRowInNormalBuf = srcColRow2destColRow_Panoramic(depthCol, depthRow, 0, depthW, 0, normalWidth);
    float4 localNormalInfo = getNormalInfo(normalBuffer, ColRowInNormalBuf.x, ColRowInNormalBuf.y, normalWidth, normalWidth/2);
    int bElimine = 0;
    if (localNormalInfo.w==255)
	{
		bElimine = 1;
	}
	else
	{
		float3 localDirection = getLocalDirection_Panoramic((float)depthCol+0.5f, (float)depthRow+0.5f, depthW, depthH);
		float fdot = fabs(dot(localDirection.xyz, localNormalInfo.xyz));
		if (fabs(fdot)<0.01f)
		{
		   bElimine = 1;
		}
	}
	
	
	if (bElimine==1)
	{
		depthBuffer[depthIndex].x = 0;
		depthBuffer[depthIndex].y = 0;
		depthBuffer[depthIndex].z = 0;
		depthBuffer[depthIndex].w = 0;
		
		resultImgBuffer[imageIndex] = (uchar4)(0, 0, 255, 0);
	}
	

}
