/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.JogampVersion;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLPlatform;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;

public class JoclVersion
extends JogampVersion {
    protected static volatile JoclVersion jogampCommonVersionInfo;
    private volatile int maxKeyStrlen = -1;

    protected JoclVersion(String string, Manifest manifest) {
        super(string, manifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JoclVersion getInstance() {
        if (null != jogampCommonVersionInfo) return jogampCommonVersionInfo;
        Class<JoclVersion> clazz = JoclVersion.class;
        synchronized (JoclVersion.class) {
            if (null != jogampCommonVersionInfo) return jogampCommonVersionInfo;
            Manifest manifest = VersionUtil.getManifest(JoclVersion.class.getClassLoader(), "com.jogamp.opencl");
            jogampCommonVersionInfo = new JoclVersion("com.jogamp.opencl", manifest);
            // ** MonitorExit[var0] (shouldn't be in output)
            return jogampCommonVersionInfo;
        }
    }

    public StringBuilder getAllVersions(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        try {
            VersionUtil.getPlatformInfo(stringBuilder);
            stringBuilder.append(Platform.getNewline());
            GlueGenVersion.getInstance().toString(stringBuilder);
            stringBuilder.append(Platform.getNewline());
            this.toString(stringBuilder);
            stringBuilder.append(Platform.getNewline());
        }
        catch (Exception exception) {
            stringBuilder.append(exception.getMessage());
            exception.printStackTrace();
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder getOpenCLTextInfo(StringBuilder stringBuilder) {
        Object object;
        Object object2;
        CLDevice[] cLDeviceArray;
        CLPlatform[] cLPlatformArray;
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        try {
            cLPlatformArray = CLPlatform.listCLPlatforms();
        }
        catch (Throwable throwable) {
            Object object3 = null;
            for (Throwable throwable2 = throwable; null != throwable2; throwable2 = throwable2.getCause()) {
                object3 = throwable2;
            }
            Throwable throwable3 = object3;
            System.err.println("CLPlatform.listCLPlatforms() failed, exception: " + throwable3.getMessage());
            throwable.printStackTrace();
            stringBuilder.append("CLPlatform.listCLPlatforms() failed, exception: " + throwable3.getMessage());
            object3 = new StringWriter();
            throwable3.printStackTrace(new PrintWriter((Writer)object3));
            stringBuilder.append(((StringWriter)object3).toString());
            return stringBuilder;
        }
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        if (0 > this.maxKeyStrlen) {
            JoclVersion joclVersion = this;
            synchronized (joclVersion) {
                if (0 > this.maxKeyStrlen) {
                    for (CLPlatform cLPlatform : cLPlatformArray) {
                        arrayList.add(cLPlatform.getProperties());
                        for (CLDevice cLDevice : cLDeviceArray = cLPlatform.listCLDevices()) {
                            Map<String, String> object4 = cLDevice.getProperties();
                            object2 = object4.entrySet();
                            object = object2.iterator();
                            while (object.hasNext()) {
                                Map.Entry entry = (Map.Entry)object.next();
                                this.maxKeyStrlen = Math.max(this.maxKeyStrlen, ((String)entry.getKey()).length());
                            }
                        }
                    }
                }
            }
        }
        stringBuilder.append(String.format("PP:DD:EE  -  Platform (PP), Device (DD), Entry (EE)%n", new Object[0]));
        int n = 0;
        for (CLPlatform cLPlatform : cLPlatformArray) {
            ++n;
            arrayList.add(cLPlatform.getProperties());
            cLDeviceArray = cLPlatform.listCLDevices();
            int n2 = 0;
            for (CLDevice cLDevice : cLDeviceArray) {
                ++n2;
                object2 = cLDevice.getProperties();
                object = object2.entrySet();
                int n3 = 0;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    stringBuilder.append(String.format("%02d:%02d:%02d %" + this.maxKeyStrlen + "s: %s%n", n, n2, ++n3, entry.getKey(), entry.getValue()));
                }
            }
        }
        return stringBuilder;
    }

    public StringBuilder getOpenCLHtmlInfo(StringBuilder stringBuilder) {
        CLPlatform[] cLPlatformArray;
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        try {
            cLPlatformArray = CLPlatform.listCLPlatforms();
        }
        catch (Throwable throwable) {
            Object object = null;
            for (Throwable throwable2 = throwable; null != throwable2; throwable2 = throwable2.getCause()) {
                object = throwable2;
            }
            Throwable throwable3 = object;
            System.err.println("CLPlatform.listCLPlatforms() failed, exception: " + throwable3.getMessage());
            throwable.printStackTrace();
            stringBuilder.append("<pre>CLPlatform.listCLPlatforms() failed, exception: " + throwable3.getMessage());
            object = new StringWriter();
            throwable3.printStackTrace(new PrintWriter((Writer)object));
            stringBuilder.append(((StringWriter)object).toString()).append("</pre>");
            return stringBuilder;
        }
        stringBuilder.append("<table border=\"1\">");
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (CLPlatform cLPlatform : cLPlatformArray) {
            arrayList.add(cLPlatform.getProperties());
            arrayList2.add(cLPlatform.listCLDevices().length);
        }
        JoclVersion.fillHtmlTable(arrayList, arrayList2, stringBuilder);
        ArrayList arrayList3 = new ArrayList();
        for (CLPlatform cLPlatform : cLPlatformArray) {
            CLDevice[] cLDeviceArray;
            for (CLDevice cLDevice : cLDeviceArray = cLPlatform.listCLDevices()) {
                arrayList3.add(cLDevice.getProperties());
            }
        }
        JoclVersion.fillHtmlTable(arrayList3, stringBuilder);
        stringBuilder.append("</table>");
        return stringBuilder;
    }

    private static void fillHtmlTable(List<Map<String, String>> list, StringBuilder stringBuilder) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(1);
        }
        JoclVersion.fillHtmlTable(list, arrayList, stringBuilder);
    }

    private static void fillHtmlTable(List<Map<String, String>> list, List<Integer> list2, StringBuilder stringBuilder) {
        boolean bl = true;
        for (String string : list.get(0).keySet()) {
            stringBuilder.append("<tr>");
            JoclVersion.htmlCell(stringBuilder, string);
            int n = 0;
            for (Map<String, String> map : list) {
                JoclVersion.htmlCell(stringBuilder, list2.get(n), map.get(string), bl);
                ++n;
            }
            stringBuilder.append("</tr>");
            bl = false;
        }
    }

    private static void htmlCell(StringBuilder stringBuilder, String string) {
        stringBuilder.append("<td>").append(string).append("</td>");
    }

    private static void htmlCell(StringBuilder stringBuilder, int n, String string, boolean bl) {
        if (bl) {
            stringBuilder.append("<th colspan=\"").append(n).append("\">").append(string).append("</th>");
        } else {
            stringBuilder.append("<td colspan=\"").append(n).append("\">").append(string).append("</td>");
        }
    }

    public static void main(String[] stringArray) {
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println(GlueGenVersion.getInstance());
        JoclVersion joclVersion = JoclVersion.getInstance();
        System.err.println(joclVersion.toString());
        if (CLPlatform.isAvailable()) {
            System.err.println(joclVersion.getOpenCLTextInfo(null).toString());
        } else {
            System.err.println("JOCL/OpenCL not available");
        }
    }
}

