/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.Position;
import bibliothek.gui.dock.ToolbarContainerDockStation;
import bibliothek.gui.dock.displayer.DisplayerCombinerTarget;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.StationDropOperation;
import bibliothek.gui.dock.station.support.CombinerTarget;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderList;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class ToolbarContainerDropInfo
implements StationDropOperation {
    private final Dockable dragDockable;
    private final ToolbarContainerDockStation stationHost;
    private final DockablePlaceholderList<StationChildHandle> associateToolbars;
    private final int mouseX;
    private final int mouseY;
    private Dockable dockableBeneathMouse = null;
    private Position sideDockableBeneathMouse = null;
    private Position dragDockablePosition;

    public ToolbarContainerDropInfo(Dockable dockable, ToolbarContainerDockStation toolbarContainerDockStation, DockablePlaceholderList<StationChildHandle> dockablePlaceholderList, int n, int n2) {
        this.dragDockable = dockable;
        this.stationHost = toolbarContainerDockStation;
        this.associateToolbars = dockablePlaceholderList;
        this.mouseX = n;
        this.mouseY = n2;
    }

    @Override
    public Dockable getItem() {
        return this.dragDockable;
    }

    @Override
    public DockStation getTarget() {
        return this.stationHost;
    }

    @Override
    public CombinerTarget getCombination() {
        return null;
    }

    @Override
    public DisplayerCombinerTarget getDisplayerCombination() {
        return null;
    }

    @Override
    public boolean isMove() {
        return this.getItem().getDockParent() == this.getTarget();
    }

    public abstract int getIndex();

    public Dockable getDockableBeneathMouse() {
        if (this.dockableBeneathMouse == null) {
            this.dockableBeneathMouse = this.computeDockableBeneathMouse();
        }
        return this.dockableBeneathMouse;
    }

    public Position getSideDockableBeneathMouse() {
        if (this.sideDockableBeneathMouse == null) {
            this.sideDockableBeneathMouse = this.computeSideDockableBeneathMouse();
        }
        return this.sideDockableBeneathMouse;
    }

    public Position getItemPositionVSBeneathDockable() {
        if (this.dragDockablePosition == null) {
            this.dragDockablePosition = this.computeItemPositionVSBeneathDockable();
        }
        return this.dragDockablePosition;
    }

    private Position computeSideDockableBeneathMouse() {
        Dockable dockable = this.getDockableBeneathMouse();
        if (dockable == null) {
            return null;
        }
        Point point = new Point(this.mouseX, this.mouseY);
        switch (this.stationHost.getOrientation()) {
            case VERTICAL: {
                SwingUtilities.convertPointFromScreen(point, dockable.getComponent());
                double d = (dockable.getComponent().getBounds().getMinY() + dockable.getComponent().getBounds().getMaxY()) / 2.0;
                if (Math.abs(point.getY()) <= d) {
                    return Position.NORTH;
                }
                return Position.SOUTH;
            }
            case HORIZONTAL: {
                SwingUtilities.convertPointFromScreen(point, dockable.getComponent());
                double d = (dockable.getComponent().getBounds().getMinX() + dockable.getComponent().getBounds().getMaxX()) / 2.0;
                if (Math.abs(point.getX()) <= d) {
                    return Position.WEST;
                }
                return Position.EAST;
            }
        }
        throw new IllegalArgumentException();
    }

    private Dockable computeDockableBeneathMouse() {
        PlaceholderList.Filter filter = this.associateToolbars.dockables();
        int n = filter.size();
        if (n <= 0) {
            return null;
        }
        Point point = new Point(this.mouseX, this.mouseY);
        JPanel jPanel = this.stationHost.getContainerPanel();
        SwingUtilities.convertPointFromScreen(point, jPanel);
        Orientation orientation = this.stationHost.getOrientation();
        switch (orientation) {
            case VERTICAL: {
                Component component = ((StationChildHandle)filter.get(0)).getDisplayer().getComponent();
                double d = (component.getBounds().getMinY() + component.getBounds().getMaxY()) / 2.0;
                double d2 = Math.abs(point.getY() - d);
                for (int i = 1; i < n; ++i) {
                    component = ((StationChildHandle)filter.get(i)).getDisplayer().getComponent();
                    d = (component.getBounds().getMinY() + component.getBounds().getMaxY()) / 2.0;
                    if (Math.abs(point.getY() - d) >= d2) {
                        return ((StationChildHandle)filter.get(i - 1)).getDockable();
                    }
                    d2 = Math.abs(point.getY() - d);
                }
                return ((StationChildHandle)filter.get(n - 1)).getDockable();
            }
            case HORIZONTAL: {
                Component component = ((StationChildHandle)filter.get(0)).getDisplayer().getComponent();
                double d = (component.getBounds().getMinX() + component.getBounds().getMaxX()) / 2.0;
                double d3 = Math.abs(point.getX() - d);
                for (int i = 1; i < n; ++i) {
                    component = ((StationChildHandle)filter.get(i)).getDisplayer().getComponent();
                    d = (component.getBounds().getMinX() + component.getBounds().getMaxX()) / 2.0;
                    if (Math.abs(point.getX() - d) >= d3) {
                        return ((StationChildHandle)filter.get(i - 1)).getDockable();
                    }
                    d3 = Math.abs(point.getX() - d);
                }
                return ((StationChildHandle)filter.get(n - 1)).getDockable();
            }
        }
        throw new IllegalArgumentException();
    }

    private Position computeItemPositionVSBeneathDockable() {
        Point point = this.getItem().getComponent().getLocation();
        if (this.getDockableBeneathMouse() != null) {
            Point point2 = this.getDockableBeneathMouse().getComponent().getLocation();
            SwingUtilities.convertPointFromScreen(point, this.getDockableBeneathMouse().getComponent());
            if (this.getDockableBeneathMouse() == null) {
                return null;
            }
            if (this.getItem() == this.getDockableBeneathMouse()) {
                return Position.CENTER;
            }
            switch (this.stationHost.getOrientation()) {
                case VERTICAL: {
                    if (point.getY() <= point2.getY()) {
                        return Position.NORTH;
                    }
                    return Position.SOUTH;
                }
                case HORIZONTAL: {
                    if (point.getX() <= point2.getX()) {
                        return Position.EAST;
                    }
                    return Position.WEST;
                }
            }
            throw new IllegalArgumentException();
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode());
    }

    public String toSummaryString() {
        String string = System.getProperty("line.separator");
        return "\t=> Drag dockable: " + this.getItem() + string + "\t=> Station target: " + this.getTarget() + string + "\t=> Dockable beneath mouse:" + this.getDockableBeneathMouse() + string + "\t=> Closest side:" + (Object)((Object)this.getSideDockableBeneathMouse()) + string + "\t=> Drag dockable VS dockable beneath mouse:" + (Object)((Object)this.getItemPositionVSBeneathDockable());
    }
}

