/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.Position;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.component.DefaultDockStationComponentRootHandler;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.location.AsideAnswer;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.station.AbstractDockableStation;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.OrientationObserver;
import bibliothek.gui.dock.station.OrientedDockStation;
import bibliothek.gui.dock.station.OrientingDockStation;
import bibliothek.gui.dock.station.OrientingDockStationEvent;
import bibliothek.gui.dock.station.OrientingDockStationListener;
import bibliothek.gui.dock.station.OverpaintablePanel;
import bibliothek.gui.dock.station.PlaceholderMapping;
import bibliothek.gui.dock.station.StationBackgroundComponent;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.StationDragOperation;
import bibliothek.gui.dock.station.StationDropItem;
import bibliothek.gui.dock.station.StationDropOperation;
import bibliothek.gui.dock.station.layer.DefaultDropLayer;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.DockableShowingManager;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListMapping;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.toolbar.DefaultToolbarContainerConverter;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerConverter;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerConverterCallback;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerDockStationFactory;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerDropInfo;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerLayoutManager;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerProperty;
import bibliothek.gui.dock.station.toolbar.ToolbarStrategy;
import bibliothek.gui.dock.station.toolbar.layer.ToolbarContainerDropLayer;
import bibliothek.gui.dock.themes.DefaultDisplayerFactoryValue;
import bibliothek.gui.dock.themes.DefaultStationPaintValue;
import bibliothek.gui.dock.themes.basic.BasicDockTitleFactory;
import bibliothek.gui.dock.themes.color.StationColor;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.SilentPropertyValue;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.util.Path;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class ToolbarContainerDockStation
extends AbstractDockableStation
implements OrientingDockStation,
OrientedDockStation {
    public static final String TITLE_ID = "toolbar.container";
    public static final String DISPLAYER_ID = "toolbar.container";
    public static final Orientation DEFAULT_ORIENTATION = Orientation.VERTICAL;
    private Orientation orientation = DEFAULT_ORIENTATION;
    private int dockablesMaxNumber = -1;
    private JPanel containerPanel;
    private Background background = new Background();
    protected OverpaintablePanelBase mainPanel;
    private BackgroundColor mainPanelBackground;
    private DockablePlaceholderList<StationChildHandle> dockables = new DockablePlaceholderList();
    private final DisplayerCollection displayers;
    private DockTitleVersion title;
    private final DefaultDisplayerFactoryValue displayerFactory;
    private final DefaultStationPaintValue paint;
    private int indexBeneathMouse = -1;
    private Position sideAboveMouse = null;
    boolean prepareDropDraw = false;
    private Dockable removal = null;
    private final List<OrientingDockStationListener> orientingListeners = new ArrayList<OrientingDockStationListener>();
    private final PropertyValue<PlaceholderStrategy> placeholderStrategy = new PropertyValue<PlaceholderStrategy>(PlaceholderStrategy.PLACEHOLDER_STRATEGY){

        @Override
        protected void valueChanged(PlaceholderStrategy placeholderStrategy, PlaceholderStrategy placeholderStrategy2) {
            ToolbarContainerDockStation.this.dockables.setStrategy(placeholderStrategy2);
        }
    };
    private DockableShowingManager visibility;
    private VisibleListener visibleListener;
    private ToolbarContainerLayoutManager layoutManager;
    private int sideSnapSize = 10;

    public ToolbarContainerDockStation(Orientation orientation) {
        this(orientation, -1);
    }

    public ToolbarContainerDockStation(Orientation orientation, int n) {
        this.orientation = orientation;
        this.setDockablesMaxNumber(n);
        this.mainPanel = new OverpaintablePanelBase();
        this.mainPanelBackground = new BackgroundColor();
        this.paint = new DefaultStationPaintValue("dock.paint.toolbar", this);
        this.displayerFactory = new DefaultDisplayerFactoryValue("dock.displayer.toolbar.container", this);
        this.displayers = new DisplayerCollection((DockStation)this, this.displayerFactory, "toolbar.container");
        DockableDisplayerListener dockableDisplayerListener = new DockableDisplayerListener(){

            @Override
            public void discard(DockableDisplayer dockableDisplayer) {
                ToolbarContainerDockStation.this.discard(dockableDisplayer);
            }

            @Override
            public void moveableElementChanged(DockableDisplayer dockableDisplayer) {
            }
        };
        this.displayers.addDockableDisplayerListener(dockableDisplayerListener);
        this.setTitleIcon(null);
        new OrientationObserver(this){

            @Override
            protected void orientationChanged(Orientation orientation) {
                if (orientation != null) {
                    ToolbarContainerDockStation.this.setOrientation(orientation);
                }
            }
        };
        this.visibility = new DockableShowingManager(this.listeners);
        this.visibleListener = new VisibleListener();
        this.getComponent().addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L) {
                    if (ToolbarContainerDockStation.this.getDockParent() == null) {
                        ToolbarContainerDockStation.this.getDockableStateListeners().checkShowing();
                    }
                    ToolbarContainerDockStation.this.visibility.fire();
                }
            }
        });
    }

    private JPanel createPanel() {
        ConfiguredBackgroundPanel configuredBackgroundPanel = new ConfiguredBackgroundPanel(Transparency.DEFAULT);
        configuredBackgroundPanel.setBackground(this.background);
        this.layoutManager = new ToolbarContainerLayoutManager(configuredBackgroundPanel, this);
        configuredBackgroundPanel.setLayout(this.layoutManager);
        configuredBackgroundPanel.setBorder(new EmptyBorder(new Insets(3, 3, 3, 3)));
        return configuredBackgroundPanel;
    }

    @Override
    protected DockComponentRootHandler createRootHandler() {
        return new DefaultDockStationComponentRootHandler(this, this.displayers);
    }

    @Override
    public int getDockableCount() {
        return this.dockables.dockables().size();
    }

    @Override
    public Dockable getDockable(int n) {
        return ((StationChildHandle)this.dockables.dockables().get(n)).getDockable();
    }

    @Override
    public Dockable getFrontDockable() {
        return null;
    }

    @Override
    public void setFrontDockable(Dockable dockable) {
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        return this.createConverter().getPlaceholders(this);
    }

    public PlaceholderMap getPlaceholders(Map<Dockable, Integer> map) {
        return this.createConverter().getPlaceholders(this, map);
    }

    @Override
    public PlaceholderMapping getPlaceholderMapping() {
        return new PlaceholderListMapping(this, this.dockables){

            @Override
            public DockableProperty getLocationAt(Path path) {
                int n = ToolbarContainerDockStation.this.dockables.getDockableIndex(path);
                return new ToolbarContainerProperty(n, path);
            }
        };
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholderMap) {
        this.createConverter().setPlaceholders(this, placeholderMap);
    }

    public void setPlaceholders(PlaceholderMap placeholderMap, Map<Integer, Dockable> map) {
        this.createConverter().setPlaceholders(this, new ToolbarContainerConverterCallback(){
            int index = 0;

            @Override
            public StationChildHandle wrap(Dockable dockable) {
                return new StationChildHandle(ToolbarContainerDockStation.this, ToolbarContainerDockStation.this.displayers, dockable, ToolbarContainerDockStation.this.title);
            }

            @Override
            public void adding(StationChildHandle stationChildHandle) {
                ToolbarContainerDockStation.this.listeners.fireDockableAdding(stationChildHandle.getDockable());
            }

            @Override
            public void added(StationChildHandle stationChildHandle) {
                stationChildHandle.updateDisplayer();
                ToolbarContainerDockStation.this.insertAt(stationChildHandle, this.index++);
                stationChildHandle.getDockable().setDockParent(ToolbarContainerDockStation.this);
                ToolbarContainerDockStation.this.listeners.fireDockableAdded(stationChildHandle.getDockable());
            }

            @Override
            public void setDockables(DockablePlaceholderList<StationChildHandle> dockablePlaceholderList) {
                ToolbarContainerDockStation.this.setDockables(dockablePlaceholderList, false);
            }

            @Override
            public void finished(DockablePlaceholderList<StationChildHandle> dockablePlaceholderList) {
                if (ToolbarContainerDockStation.this.getController() != null) {
                    dockablePlaceholderList.bind();
                    dockablePlaceholderList.setStrategy(ToolbarContainerDockStation.this.getPlaceholderStrategy());
                }
            }
        }, placeholderMap, map);
    }

    protected ToolbarContainerConverter createConverter() {
        return new DefaultToolbarContainerConverter();
    }

    public PlaceholderStrategy getPlaceholderStrategy() {
        return this.placeholderStrategy.getValue();
    }

    public void setPlaceholderStrategy(PlaceholderStrategy placeholderStrategy) {
        this.placeholderStrategy.setValue(placeholderStrategy);
    }

    @Override
    public DockableProperty getDockableProperty(Dockable dockable, Dockable dockable2) {
        int n = this.indexOf(dockable);
        Path path = null;
        PlaceholderStrategy placeholderStrategy = this.getPlaceholderStrategy();
        if (placeholderStrategy != null && (path = dockable2 != null ? placeholderStrategy.getPlaceholderFor(dockable2) : placeholderStrategy.getPlaceholderFor(dockable)) != null) {
            this.dockables.dockables().addPlaceholder(n, path);
        }
        return new ToolbarContainerProperty(n, path);
    }

    @Override
    public void aside(AsideRequest asideRequest) {
        int n;
        DockableProperty dockableProperty = asideRequest.getLocation();
        Path path = asideRequest.getPlaceholder();
        if (dockableProperty instanceof ToolbarContainerProperty) {
            ToolbarContainerProperty toolbarContainerProperty = (ToolbarContainerProperty)dockableProperty;
            if (toolbarContainerProperty.getSuccessor() == null) {
                n = this.dockables.getNextListIndex(toolbarContainerProperty.getIndex(), toolbarContainerProperty.getPlaceholder());
                if (path != null) {
                    this.dockables.list().insertPlaceholder(n, path);
                }
            } else {
                n = this.dockables.getListIndex(toolbarContainerProperty.getIndex(), toolbarContainerProperty.getPlaceholder());
                if (path != null) {
                    AsideAnswer asideAnswer;
                    DockStation dockStation;
                    this.dockables.list().addPlaceholder(n, path);
                    StationChildHandle stationChildHandle = (StationChildHandle)this.dockables.list().get(n).getDockable();
                    if (stationChildHandle != null && (dockStation = stationChildHandle.asDockable().asDockStation()) != null && (asideAnswer = asideRequest.forward(dockStation)).isCanceled()) {
                        return;
                    }
                }
            }
        } else {
            n = this.dockables.dockables().size();
            if (path != null) {
                this.dockables.dockables().insertPlaceholder(n, path);
            }
        }
        asideRequest.answer(new ToolbarContainerProperty(n, path));
    }

    @Override
    public StationDragOperation prepareDrag(Dockable dockable) {
        this.removal = dockable;
        this.getComponent().repaint();
        return new StationDragOperation(){

            @Override
            public void succeeded() {
                ToolbarContainerDockStation.this.removal = null;
                ToolbarContainerDockStation.this.getComponent().repaint();
            }

            @Override
            public void canceled() {
                ToolbarContainerDockStation.this.removal = null;
                ToolbarContainerDockStation.this.getComponent().repaint();
            }
        };
    }

    public void setSideSnapSize(int n) {
        this.sideSnapSize = n;
    }

    public int getSideSnapSize() {
        return this.sideSnapSize;
    }

    @Override
    public DockStationDropLayer[] getLayers() {
        return new DockStationDropLayer[]{new DefaultDropLayer(this){

            @Override
            public Component getComponent() {
                return ToolbarContainerDockStation.this.getComponent();
            }
        }, new ToolbarContainerDropLayer(this)};
    }

    @Override
    public StationDropOperation prepareDrop(StationDropItem stationDropItem) {
        DockController dockController = this.getController();
        Dockable dockable = stationDropItem.getDockable();
        if (this.accept(dockable) && dockable.accept(this)) {
            if (dockController != null && !dockController.getAcceptance().accept(this, dockable)) {
                return null;
            }
            if (!this.getToolbarStrategy().isToolbarPart(dockable)) {
                return null;
            }
            ToolbarContainerDropInfo toolbarContainerDropInfo = new ToolbarContainerDropInfo(dockable, this, this.dockables, stationDropItem.getMouseX(), stationDropItem.getMouseY()){

                @Override
                public void execute() {
                    ToolbarContainerDockStation.this.drop(this);
                }

                @Override
                public void destroy(StationDropOperation stationDropOperation) {
                    if (stationDropOperation == null || stationDropOperation.getTarget() != this.getTarget()) {
                        ToolbarContainerDockStation.this.layoutManager.setDrawing(null);
                    }
                    ToolbarContainerDockStation.this.indexBeneathMouse = -1;
                    ToolbarContainerDockStation.this.sideAboveMouse = null;
                    ToolbarContainerDockStation.this.prepareDropDraw = false;
                    ToolbarContainerDockStation.this.mainPanel.repaint();
                }

                @Override
                public int getIndex() {
                    return ToolbarContainerDockStation.this.indexOf(this.getDockableBeneathMouse());
                }

                @Override
                public void draw() {
                    boolean bl = true;
                    ToolbarContainerDockStation.this.indexBeneathMouse = this.getIndex();
                    if (this.isMove()) {
                        int n;
                        int n2 = ToolbarContainerDockStation.this.moveIndex(this, ToolbarContainerDockStation.this.indexBeneathMouse);
                        boolean bl2 = bl = n2 != (n = ToolbarContainerDockStation.this.indexOf(this.getItem())) && n2 != n - 1;
                    }
                    if (bl) {
                        ToolbarContainerDockStation.this.layoutManager.setDrawing(this);
                        ToolbarContainerDockStation.this.prepareDropDraw = true;
                    } else {
                        ToolbarContainerDockStation.this.layoutManager.setDrawing(null);
                        ToolbarContainerDockStation.this.prepareDropDraw = false;
                    }
                    ToolbarContainerDockStation.this.sideAboveMouse = this.getSideDockableBeneathMouse();
                    ToolbarContainerDockStation.this.mainPanel.repaint();
                }
            };
            return toolbarContainerDropInfo;
        }
        return null;
    }

    @Override
    public void addOrientingDockStationListener(OrientingDockStationListener orientingDockStationListener) {
        this.orientingListeners.add(orientingDockStationListener);
    }

    @Override
    public void removeOrientingDockStationListener(OrientingDockStationListener orientingDockStationListener) {
        this.orientingListeners.remove(orientingDockStationListener);
    }

    @Override
    public Orientation getOrientationOf(Dockable dockable) {
        return this.orientation;
    }

    public void setDockablesMaxNumber(int n) {
        this.dockablesMaxNumber = n;
    }

    public int getDockablesMaxNumber() {
        return this.dockablesMaxNumber;
    }

    protected void fireOrientingEvent() {
        OrientingDockStationEvent orientingDockStationEvent = new OrientingDockStationEvent(this);
        for (OrientingDockStationListener orientingDockStationListener : this.orientingListeners.toArray(new OrientingDockStationListener[this.orientingListeners.size()])) {
            orientingDockStationListener.changed(orientingDockStationEvent);
        }
    }

    private void drop(ToolbarContainerDropInfo toolbarContainerDropInfo) {
        if (this.getDockables().dockables().size() == 0) {
            this.drop(toolbarContainerDropInfo.getItem(), 0);
        }
        if (toolbarContainerDropInfo.getItemPositionVSBeneathDockable() != Position.CENTER) {
            int n = this.indexOf(toolbarContainerDropInfo.getDockableBeneathMouse());
            if (toolbarContainerDropInfo.isMove()) {
                this.move(toolbarContainerDropInfo.getItem(), this.moveIndex(toolbarContainerDropInfo, n));
            } else {
                int n2 = 0;
                if (toolbarContainerDropInfo.getSideDockableBeneathMouse() == Position.SOUTH || toolbarContainerDropInfo.getSideDockableBeneathMouse() == Position.EAST) {
                    ++n2;
                }
                int n3 = n + n2;
                this.drop(toolbarContainerDropInfo.getItem(), n3);
            }
        }
    }

    private int moveIndex(ToolbarContainerDropInfo toolbarContainerDropInfo, int n) {
        switch (this.getOrientation()) {
            case VERTICAL: {
                if (toolbarContainerDropInfo.getItemPositionVSBeneathDockable() == Position.SOUTH) {
                    if (toolbarContainerDropInfo.getSideDockableBeneathMouse() == Position.SOUTH) {
                        return n + 1;
                    }
                    return n;
                }
                if (toolbarContainerDropInfo.getSideDockableBeneathMouse() == Position.SOUTH) {
                    return n;
                }
                return n - 1;
            }
            case HORIZONTAL: {
                if (toolbarContainerDropInfo.getItemPositionVSBeneathDockable() == Position.EAST) {
                    if (toolbarContainerDropInfo.getSideDockableBeneathMouse() == Position.EAST) {
                        return n + 1;
                    }
                    return n;
                }
                if (toolbarContainerDropInfo.getSideDockableBeneathMouse() == Position.EAST) {
                    return n;
                }
                return n - 1;
            }
        }
        throw new IllegalStateException("unknown orientation: " + (Object)((Object)this.getOrientation()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(Dockable dockable, DockableProperty dockableProperty) {
        if (dockableProperty instanceof ToolbarContainerProperty) {
            Dockable dockable2;
            ToolbarContainerProperty toolbarContainerProperty = (ToolbarContainerProperty)dockableProperty;
            Path path = toolbarContainerProperty.getPlaceholder();
            boolean bl = false;
            int n = -1;
            StationChildHandle stationChildHandle = null;
            if (path != null && (bl = this.dockables.hasPlaceholder(path))) {
                n = this.dockables.getDockableIndex(path);
                stationChildHandle = (StationChildHandle)this.dockables.getDockableAt(path);
            }
            if (n == -1) {
                n = toolbarContainerProperty.getIndex();
            }
            if (toolbarContainerProperty.getSuccessor() != null) {
                DockablePlaceholderList<StationChildHandle> dockablePlaceholderList = this.getDockables();
                dockable2 = null;
                if (stationChildHandle != null) {
                    dockable2 = stationChildHandle.asDockable();
                } else if (!bl && n >= 0 && n < dockablePlaceholderList.dockables().size()) {
                    dockable2 = ((StationChildHandle)dockablePlaceholderList.dockables().get(n)).getDockable();
                }
                if (dockable2 != null && dockable2.asDockStation() != null) {
                    return dockable2.asDockStation().drop(dockable, dockableProperty.getSuccessor());
                }
            }
            int n2 = this.getDockables().dockables().size();
            if (bl && stationChildHandle == null && toolbarContainerProperty.getSuccessor() != null) {
                dockable2 = this.getToolbarStrategy().ensureToolbarLayer(this, dockable);
                DockController dockController = this.getController();
                if (dockController != null) {
                    dockController.freezeLayout();
                }
                try {
                    this.add(dockable2, -1, path);
                    if (dockable2 != dockable && !dockable2.asDockStation().drop(dockable, toolbarContainerProperty.getSuccessor())) {
                        dockable2.asDockStation().drop(dockable);
                    }
                    boolean bl2 = true;
                    return bl2;
                }
                finally {
                    if (dockController != null) {
                        dockController.meltLayout();
                    }
                }
            }
            return this.drop(dockable, Math.max(0, Math.min(n2, n)));
        }
        return false;
    }

    @Override
    public void drop(Dockable dockable) {
        this.drop(dockable, this.getDockables().dockables().size());
    }

    private boolean drop(Dockable dockable, int n) {
        return this.add(dockable, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void move(Dockable dockable, int n) {
        if (this.getToolbarStrategy().isToolbarPart(dockable)) {
            DockController dockController = this.getController();
            try {
                if (dockController != null) {
                    dockController.freezeLayout();
                }
                this.add(dockable, n);
            }
            finally {
                if (dockController != null) {
                    dockController.meltLayout();
                }
            }
        }
    }

    @Override
    public void move(Dockable dockable, DockableProperty dockableProperty) {
    }

    @Override
    public boolean canDrag(Dockable dockable) {
        return true;
    }

    @Override
    public void drag(Dockable dockable) {
        if (dockable.getDockParent() != this) {
            throw new IllegalArgumentException("The dockable cannot be dragged, it is not child of this station.");
        }
        this.remove(dockable);
    }

    @Override
    public boolean canReplace(Dockable dockable, Dockable dockable2) {
        return dockable.getClass() == dockable2.getClass();
    }

    @Override
    public void replace(Dockable dockable, Dockable dockable2) {
        DockUtilities.checkLayoutLocked();
        DockController dockController = this.getController();
        if (dockController != null) {
            dockController.freezeLayout();
        }
        int n = this.indexOf(dockable);
        this.remove(dockable);
        this.add(dockable2, n);
        dockController.meltLayout();
    }

    @Override
    public void replace(DockStation dockStation, Dockable dockable) {
        this.replace(dockStation.asDockable(), dockable);
    }

    @Override
    public String getFactoryID() {
        return "ToolbarContainerDockStationFactory";
    }

    @Override
    public Component getComponent() {
        return this.mainPanel;
    }

    @Override
    protected void callDockUiUpdateTheme() throws IOException {
        DockUI.updateTheme(this, new ToolbarContainerDockStationFactory());
    }

    public JPanel getContainerPanel() {
        return this.containerPanel;
    }

    public ToolbarStrategy getToolbarStrategy() {
        SilentPropertyValue<ToolbarStrategy> silentPropertyValue = new SilentPropertyValue<ToolbarStrategy>(ToolbarStrategy.STRATEGY, this.getController());
        ToolbarStrategy toolbarStrategy = (ToolbarStrategy)silentPropertyValue.getValue();
        silentPropertyValue.setProperties((DockController)null);
        return toolbarStrategy;
    }

    @Override
    public boolean accept(Dockable dockable) {
        if (this.dockablesMaxNumber == -1) {
            return true;
        }
        return this.dockables.dockables().size() < this.dockablesMaxNumber;
    }

    @Override
    public boolean accept(DockStation dockStation) {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode());
    }

    private void setDockables(DockablePlaceholderList<StationChildHandle> dockablePlaceholderList, boolean bl) {
        if (this.getController() != null) {
            DockablePlaceholderList<StationChildHandle> dockablePlaceholderList2 = this.getDockables();
            dockablePlaceholderList2.setStrategy(null);
            dockablePlaceholderList2.unbind();
        }
        this.dockables = dockablePlaceholderList;
        if (this.getController() != null && bl) {
            dockablePlaceholderList.bind();
            dockablePlaceholderList.setStrategy(this.getPlaceholderStrategy());
        }
    }

    public DockablePlaceholderList<StationChildHandle> getDockables() {
        return this.dockables;
    }

    @Override
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.fireOrientingEvent();
    }

    private int indexOf(Dockable dockable) {
        for (int i = 0; i < this.dockables.dockables().size(); ++i) {
            if (((StationChildHandle)this.dockables.dockables().get(i)).getDockable() != dockable) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(Dockable dockable) {
        DockUtilities.checkLayoutLocked();
        DockHierarchyLock.Token token = DockHierarchyLock.acquireUnlinking(this, dockable);
        try {
            int n = this.indexOf(dockable);
            PlaceholderList.Filter filter = this.getDockables().dockables();
            this.listeners.fireDockableRemoving(dockable);
            dockable.setDockParent(null);
            StationChildHandle stationChildHandle = (StationChildHandle)filter.get(n);
            this.getDockables().remove(n);
            this.getContainerPanel().remove(stationChildHandle.getDisplayer().getComponent());
            stationChildHandle.destroy();
            this.mainPanel.getContentPane().revalidate();
            this.mainPanel.getContentPane().repaint();
            this.listeners.fireDockableRemoved(dockable);
            this.fireDockablesRepositioned(n);
        }
        finally {
            token.release();
        }
    }

    protected boolean add(Dockable dockable, int n) {
        return this.add(dockable, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean add(Dockable dockable, int n, Path path) {
        DockUtilities.ensureTreeValidity(this, dockable);
        DockUtilities.checkLayoutLocked();
        ToolbarStrategy toolbarStrategy = this.getToolbarStrategy();
        if (toolbarStrategy.isToolbarPart(dockable)) {
            Dockable dockable2 = toolbarStrategy.ensureToolbarLayer(this, dockable);
            if (dockable2 != dockable) {
                dockable2.setController(this.getController());
                dockable2.asDockStation().drop(dockable);
                dockable2.setController(null);
                dockable = dockable2;
            }
            DockHierarchyLock.Token token = DockHierarchyLock.acquireLinking(this, dockable);
            try {
                this.listeners.fireDockableAdding(dockable);
                PlaceholderList.Filter filter = this.getDockables().dockables();
                StationChildHandle stationChildHandle = new StationChildHandle(this, this.displayers, dockable, this.title);
                if (path != null) {
                    n = this.getDockables().put(path, stationChildHandle);
                } else {
                    filter.add(n, stationChildHandle);
                }
                stationChildHandle.updateDisplayer();
                this.insertAt(stationChildHandle, n);
                dockable.setDockParent(this);
                this.listeners.fireDockableAdded(dockable);
                this.fireDockablesRepositioned(n + 1);
            }
            finally {
                token.release();
            }
            this.mainPanel.revalidate();
            this.mainPanel.repaint();
            return true;
        }
        return false;
    }

    private void insertAt(StationChildHandle stationChildHandle, int n) {
        Dockable dockable = stationChildHandle.getDockable();
        dockable.setDockParent(this);
        this.getContainerPanel().add(stationChildHandle.getDisplayer().getComponent(), n);
        this.mainPanel.getContentPane().revalidate();
        this.mainPanel.getContentPane().repaint();
    }

    protected void discard(DockableDisplayer dockableDisplayer) {
        int n = this.indexOf(dockableDisplayer.getDockable());
        StationChildHandle stationChildHandle = (StationChildHandle)this.getDockables().dockables().get(n);
        this.getContainerPanel().remove(dockableDisplayer.getComponent());
        stationChildHandle.updateDisplayer();
        this.insertAt(stationChildHandle, n);
    }

    public DefaultStationPaintValue getPaint() {
        return this.paint;
    }

    @Override
    public void setDockParent(DockStation dockStation) {
        DockStation dockStation2 = this.getDockParent();
        if (dockStation2 != null) {
            dockStation2.removeDockStationListener(this.visibleListener);
        }
        super.setDockParent(dockStation);
        if (dockStation != null) {
            dockStation.addDockStationListener(this.visibleListener);
        }
        this.visibility.fire();
    }

    @Override
    public void setController(DockController dockController) {
        if (this.getController() != dockController) {
            if (this.getController() != null) {
                this.unbind(this.dockables);
            }
            super.setController(dockController);
            this.paint.setController(dockController);
            this.displayerFactory.setController(dockController);
            this.layoutManager.setController(dockController);
            this.background.setController(dockController);
            this.mainPanelBackground.connect(dockController);
            this.title = dockController == null ? null : dockController.getDockTitleManager().getVersion("toolbar.container", BasicDockTitleFactory.FACTORY);
            this.displayers.setController(dockController);
            this.placeholderStrategy.setProperties(dockController);
            if (dockController != null) {
                this.bind(this.dockables, this.title);
            }
            this.visibility.fire();
        }
    }

    private void unbind(DockablePlaceholderList<StationChildHandle> dockablePlaceholderList) {
        dockablePlaceholderList.unbind();
        for (StationChildHandle stationChildHandle : dockablePlaceholderList.dockables()) {
            stationChildHandle.setTitleRequest(null);
        }
    }

    private void bind(DockablePlaceholderList<StationChildHandle> dockablePlaceholderList, DockTitleVersion dockTitleVersion) {
        dockablePlaceholderList.bind();
        for (StationChildHandle stationChildHandle : dockablePlaceholderList.dockables()) {
            stationChildHandle.setTitleRequest(dockTitleVersion, true);
        }
    }

    private class VisibleListener
    extends DockStationAdapter {
        private VisibleListener() {
        }

        @Override
        public void dockableShowingChanged(DockStation dockStation, Dockable dockable, boolean bl) {
            if (dockable == ToolbarContainerDockStation.this) {
                ToolbarContainerDockStation.this.visibility.fire();
            }
        }
    }

    private class Background
    extends BackgroundAlgorithm
    implements StationBackgroundComponent {
        public Background() {
            super(StationBackgroundComponent.KIND, "dock.background.station.toolbar.container");
        }

        @Override
        public Component getComponent() {
            return ToolbarContainerDockStation.this.getComponent();
        }

        @Override
        public DockStation getStation() {
            return ToolbarContainerDockStation.this;
        }
    }

    protected class OverpaintablePanelBase
    extends OverpaintablePanel {
        public OverpaintablePanelBase() {
            ToolbarContainerDockStation.this.containerPanel = ToolbarContainerDockStation.this.createPanel();
            this.setBasePane(ToolbarContainerDockStation.this.containerPanel);
            this.setContentPane(ToolbarContainerDockStation.this.containerPanel);
            this.setSolid(true);
            this.getContentPane().revalidate();
            this.getContentPane().repaint();
        }

        @Override
        protected void paintOverlay(Graphics graphics) {
            this.paintRemoval(graphics);
            DefaultStationPaintValue defaultStationPaintValue = ToolbarContainerDockStation.this.getPaint();
            if (ToolbarContainerDockStation.this.prepareDropDraw) {
                if (ToolbarContainerDockStation.this.indexBeneathMouse != -1) {
                    Rectangle rectangle = ((StationChildHandle)ToolbarContainerDockStation.this.getDockables().dockables().get(ToolbarContainerDockStation.this.indexBeneathMouse)).getDisplayer().getComponent().getBounds();
                    Rectangle rectangle2 = ToolbarContainerDockStation.this.getContainerPanel().getBounds();
                    rectangle.translate(rectangle2.x, rectangle2.y);
                    switch (ToolbarContainerDockStation.this.getOrientation()) {
                        case VERTICAL: {
                            int n = ToolbarContainerDockStation.this.sideAboveMouse == Position.NORTH ? rectangle.y : rectangle.y + rectangle.height;
                            defaultStationPaintValue.drawInsertionLine(graphics, rectangle.x, n, rectangle.x + rectangle.width, n);
                            break;
                        }
                        case HORIZONTAL: {
                            int n = ToolbarContainerDockStation.this.sideAboveMouse == Position.WEST ? rectangle.x : rectangle.x + rectangle.width;
                            defaultStationPaintValue.drawInsertionLine(graphics, n, rectangle.y, n, rectangle.y + rectangle.height);
                        }
                    }
                } else {
                    defaultStationPaintValue.drawDivider(graphics, ToolbarContainerDockStation.this.getContainerPanel().getBounds());
                }
            }
        }

        private void paintRemoval(Graphics graphics) {
            if (ToolbarContainerDockStation.this.removal != null) {
                for (StationChildHandle stationChildHandle : ToolbarContainerDockStation.this.dockables.dockables()) {
                    if (stationChildHandle.getDockable() != ToolbarContainerDockStation.this.removal) continue;
                    Rectangle rectangle = stationChildHandle.getDisplayer().getComponent().getBounds();
                    ToolbarContainerDockStation.this.getPaint().drawRemoval(graphics, rectangle, rectangle);
                    break;
                }
            }
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode());
        }
    }

    private class BackgroundColor
    extends StationColor {
        public BackgroundColor() {
            super("toolbar.container.background", ToolbarContainerDockStation.this, null);
        }

        @Override
        protected void changed(Color color, Color color2) {
            ToolbarContainerDockStation.this.mainPanel.setBackground(color2);
        }
    }
}

