/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.toolbar.expand;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionContentModifier;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.action.DockActionText;
import bibliothek.gui.dock.action.actions.SimpleButtonAction;
import javax.swing.Icon;

public class SimpleExpandAction
extends SimpleButtonAction {
    private final DockController controller;
    private int bound = 0;
    private DockActionIcon iconHorizontal;
    private DockActionIcon iconVertical;
    private DockActionIcon iconHoverHorizontal;
    private DockActionIcon iconHoverVertical;
    private DockActionText text;
    private DockActionText tooltip;
    private Action behavior;

    public SimpleExpandAction(DockController dockController, Action action) {
        this.controller = dockController;
        this.setBehavior(action);
    }

    public Action getBehavior() {
        return this.behavior;
    }

    public void setBehavior(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("behavior must not be null");
        }
        if (this.behavior != action) {
            this.behavior = action;
            String string = this.name(action);
            if (this.iconHorizontal == null) {
                this.iconHorizontal = new DockActionIcon("toolbar.item." + string + ".horizontal", this){

                    @Override
                    protected void changed(Icon icon, Icon icon2) {
                        SimpleExpandAction.this.setIcon(ActionContentModifier.NONE_HORIZONTAL, icon2);
                    }
                };
                this.iconVertical = new DockActionIcon("toolbar.item." + string + ".vertical", this){

                    @Override
                    protected void changed(Icon icon, Icon icon2) {
                        SimpleExpandAction.this.setIcon(ActionContentModifier.NONE_VERTICAL, icon2);
                    }
                };
                this.iconHoverHorizontal = new DockActionIcon("toolbar.item." + string + ".hover.horizontal", this){

                    @Override
                    protected void changed(Icon icon, Icon icon2) {
                        SimpleExpandAction.this.setIcon(ActionContentModifier.NONE_HOVER_HORIZONTAL, icon2);
                    }
                };
                this.iconHoverVertical = new DockActionIcon("toolbar.item." + string + ".hover.vertical", this){

                    @Override
                    protected void changed(Icon icon, Icon icon2) {
                        SimpleExpandAction.this.setIcon(ActionContentModifier.NONE_HOVER_VERTICAL, icon2);
                    }
                };
                this.text = new DockActionText("toolbar.item." + string, this){

                    @Override
                    protected void changed(String string, String string2) {
                        SimpleExpandAction.this.setText(string2);
                    }
                };
                this.tooltip = new DockActionText("toolbar.item." + string + ".tooltip", this){

                    @Override
                    protected void changed(String string, String string2) {
                        SimpleExpandAction.this.setTooltip(string2);
                    }
                };
            } else {
                this.iconHorizontal.setId("toolbar.item." + string + ".horizontal");
                this.iconVertical.setId("toolbar.item." + string + ".vertical");
                this.iconHoverHorizontal.setId("toolbar.item." + string + ".hover.horizontal");
                this.iconHoverVertical.setId("toolbar.item." + string + ".hover.vertical");
                this.text.setId("toolbar.item." + string);
                this.tooltip.setId("toolbar.item." + string + ".tooltip");
            }
        }
    }

    private String name(Action action) {
        switch (action) {
            case LARGER: {
                return "larger";
            }
            case LARGEST: {
                return "expand";
            }
            case SMALLER: {
                return "smaller";
            }
            case SMALLEST: {
                return "shrink";
            }
        }
        throw new IllegalStateException("unknown action: " + (Object)((Object)action));
    }

    @Override
    public void bound(Dockable dockable) {
        if (this.bound == 0) {
            this.iconHorizontal.setController(this.controller);
            this.iconVertical.setController(this.controller);
            this.iconHoverHorizontal.setController(this.controller);
            this.iconHoverVertical.setController(this.controller);
            this.text.setController(this.controller);
            this.tooltip.setController(this.controller);
        }
        super.bound(dockable);
        ++this.bound;
    }

    @Override
    public void unbound(Dockable dockable) {
        super.unbound(dockable);
        --this.bound;
        if (this.bound == 0) {
            this.iconHorizontal.setController(null);
            this.iconVertical.setController(null);
            this.iconHoverHorizontal.setController(null);
            this.iconHoverVertical.setController(null);
            this.text.setController(null);
            this.tooltip.setController(null);
        }
    }

    public static enum Action {
        LARGEST,
        LARGER,
        SMALLER,
        SMALLEST;

    }
}

