/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.menu;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenuCallback;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenuContent;
import bibliothek.gui.dock.util.icon.DockIcon;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JToggleButton;

public abstract class CustomizationToolbarButton
implements CustomizationMenuContent {
    private DockController controller;
    private Icon icon;
    private String description;
    private String text;
    private JLayeredPane base;
    private JToggleButton button;
    private JLabel elsewhere;
    private CustomizationMenuCallback callback;
    private DockIcon elsewhereIcon = new DockIcon("toolbar.customization.check", DockIcon.KIND_ICON){

        @Override
        protected void changed(Icon icon, Icon icon2) {
            if (CustomizationToolbarButton.this.elsewhere != null) {
                CustomizationToolbarButton.this.elsewhere.setIcon(icon2);
            }
        }
    };

    @Override
    public void setController(DockController dockController) {
        this.controller = dockController;
        if (this.callback != null) {
            this.elsewhereIcon.setController(dockController);
        }
    }

    @Override
    public Component getView() {
        return this.base;
    }

    @Override
    public void bind(CustomizationMenuCallback customizationMenuCallback) {
        this.callback = customizationMenuCallback;
        this.button = new JToggleButton();
        this.button.setIcon(this.icon);
        this.button.setToolTipText(this.description);
        this.button.setText(this.text);
        this.button.setOpaque(false);
        this.elsewhere = new JLabel();
        this.elsewhereIcon.setController(this.controller);
        this.elsewhere.setIcon((Icon)this.elsewhereIcon.value());
        this.elsewhere.setVisible(false);
        this.base = new JLayeredPane();
        this.base.add(this.button);
        this.base.add(this.elsewhere);
        this.base.setLayer(this.button, JLayeredPane.DEFAULT_LAYER);
        this.base.setLayer(this.elsewhere, JLayeredPane.MODAL_LAYER);
        this.base.setLayout(new LayoutManager(){

            @Override
            public void removeLayoutComponent(Component component) {
            }

            @Override
            public Dimension preferredLayoutSize(Container container) {
                return new Dimension(((CustomizationToolbarButton)CustomizationToolbarButton.this).button.getPreferredSize().width + ((CustomizationToolbarButton)CustomizationToolbarButton.this).elsewhere.getPreferredSize().width + 1, ((CustomizationToolbarButton)CustomizationToolbarButton.this).button.getPreferredSize().height);
            }

            @Override
            public Dimension minimumLayoutSize(Container container) {
                return CustomizationToolbarButton.this.button.getMinimumSize();
            }

            @Override
            public void layoutContainer(Container container) {
                if (container.getComponentCount() == 2) {
                    int n = container.getWidth();
                    int n2 = container.getHeight();
                    Dimension dimension = CustomizationToolbarButton.this.elsewhere.getPreferredSize();
                    int n3 = Math.min(dimension.width, n - 1);
                    int n4 = Math.min(dimension.height, n2 - 1);
                    CustomizationToolbarButton.this.button.setBounds(n3 + 2, 0, n - n3 - 2, n2);
                    CustomizationToolbarButton.this.elsewhere.setBounds(1, 0, n3, n4);
                }
            }

            @Override
            public void addLayoutComponent(String string, Component component) {
            }
        });
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ItemLocation itemLocation = CustomizationToolbarButton.this.getItemLocation();
                CustomizationToolbarButton.this.setItemVisible(itemLocation != ItemLocation.HERE);
            }
        });
        this.select();
    }

    private void select() {
        ItemLocation itemLocation = this.getItemLocation();
        this.elsewhere.setVisible(itemLocation == ItemLocation.HERE || itemLocation == ItemLocation.ELSEWHERE);
        this.button.setSelected(itemLocation == ItemLocation.HERE);
    }

    protected ItemLocation getItemLocation() {
        if (this.callback == null) {
            throw new IllegalStateException("this information is only available if the button has been bound");
        }
        if (!this.hasDockable()) {
            return ItemLocation.INVISIBLE;
        }
        Dockable dockable = this.getDockable();
        DockStation dockStation = dockable.getDockParent();
        if (dockStation == null) {
            return ItemLocation.INVISIBLE;
        }
        DockStation dockStation2 = this.callback.getOwner();
        while (dockStation != null) {
            if (dockStation == dockStation2) {
                return ItemLocation.HERE;
            }
            dockable = dockStation.asDockable();
            if (dockable == null) {
                dockStation = null;
                continue;
            }
            dockStation = dockable.getDockParent();
        }
        return ItemLocation.ELSEWHERE;
    }

    protected void setItemVisible(boolean bl) {
        Dockable dockable = this.getDockable();
        DockStation dockStation = dockable.getDockParent();
        if (dockStation != null) {
            dockStation.drag(dockable);
        }
        if (bl) {
            this.callback.append(dockable);
        }
        this.select();
    }

    @Override
    public void unbind() {
        this.base = null;
        this.button = null;
        this.elsewhere = null;
        this.elsewhereIcon.setController(null);
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        if (this.button != null) {
            this.button.setIcon(icon);
        }
    }

    public void setText(String string) {
        this.text = string;
        if (this.button != null) {
            this.button.setText(string);
        }
    }

    public void setDescription(String string) {
        this.description = string;
        if (this.button != null) {
            this.button.setToolTipText(string);
        }
    }

    protected abstract boolean hasDockable();

    protected abstract Dockable getDockable();

    public static enum ItemLocation {
        INVISIBLE,
        ELSEWHERE,
        HERE;

    }
}

