/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action;

import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.action.actions.SeparatorAction;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.themes.basic.action.DockActionImportance;
import java.util.Iterator;

public class LineDockActionSource
extends AbstractDockActionSource {
    private DockActionSource source;
    private SeparatorAction separator = new Separator();
    private DockActionSourceListener listener = new DockActionSourceListener(){

        @Override
        public void actionsRemoved(DockActionSource dockActionSource, int n, int n2) {
            if (dockActionSource.getDockActionCount() == 0) {
                LineDockActionSource.this.fireRemoved(0, n2 + 1);
            } else {
                LineDockActionSource.this.fireRemoved(n + 1, n2 + 1);
            }
        }

        @Override
        public void actionsAdded(DockActionSource dockActionSource, int n, int n2) {
            int n3 = n2 - n + 1;
            if (n3 == dockActionSource.getDockActionCount()) {
                LineDockActionSource.this.fireAdded(0, n2 + 1);
            } else {
                LineDockActionSource.this.fireAdded(n + 1, n2 + 1);
            }
        }
    };

    public LineDockActionSource(DockActionSource dockActionSource) {
        this.source = dockActionSource;
    }

    @Override
    public LocationHint getLocationHint() {
        return this.source.getLocationHint();
    }

    @Override
    public int getDockActionCount() {
        int n = this.source.getDockActionCount();
        if (n > 0) {
            ++n;
        }
        return n;
    }

    @Override
    public DockAction getDockAction(int n) {
        if (n == 0) {
            return this.separator;
        }
        return this.source.getDockAction(n - 1);
    }

    @Override
    public void addDockActionSourceListener(DockActionSourceListener dockActionSourceListener) {
        if (!this.hasListeners()) {
            this.source.addDockActionSourceListener(this.listener);
        }
        super.addDockActionSourceListener(dockActionSourceListener);
    }

    @Override
    public void removeDockActionSourceListener(DockActionSourceListener dockActionSourceListener) {
        super.removeDockActionSourceListener(dockActionSourceListener);
        if (!this.hasListeners()) {
            this.source.removeDockActionSourceListener(this.listener);
        }
    }

    @Override
    public Iterator<DockAction> iterator() {
        return new Iterator<DockAction>(){
            private boolean separatorSent = false;
            private Iterator<DockAction> inner = LineDockActionSource.access$000(LineDockActionSource.this).iterator();

            @Override
            public DockAction next() {
                if (this.separatorSent) {
                    return this.inner.next();
                }
                this.separatorSent = true;
                return LineDockActionSource.this.separator;
            }

            @Override
            public boolean hasNext() {
                if (this.separatorSent) {
                    return this.inner.hasNext();
                }
                return LineDockActionSource.this.getDockActionCount() > 0;
            }

            @Override
            public void remove() {
                if (!this.separatorSent) {
                    throw new IllegalStateException("not supported for the first element");
                }
                this.inner.remove();
            }
        };
    }

    static /* synthetic */ DockActionSource access$000(LineDockActionSource lineDockActionSource) {
        return lineDockActionSource.source;
    }

    @DockActionImportance(value=0.0)
    private class Separator
    extends SeparatorAction {
        public Separator() {
            super(ViewTarget.TITLE);
        }
    }
}

