/*
 * Decompiled with CFR 0.152.
 */
package com.cryptlex.lexfloatclient;

import com.cryptlex.lexfloatclient.HostLicenseMeterAttribute;
import com.cryptlex.lexfloatclient.HostProductVersionFeatureFlag;
import com.cryptlex.lexfloatclient.LexFloatClientException;
import com.cryptlex.lexfloatclient.LexFloatClientNative;
import com.cryptlex.lexfloatclient.LicenseCallbackEvent;
import com.sun.jna.Platform;
import com.sun.jna.WString;
import com.sun.jna.ptr.IntByReference;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;

public class LexFloatClient {
    private static LexFloatClientNative.CallbackType privateCallback = null;
    private static List<LicenseCallbackEvent> listeners = null;
    public static final int LF_OK = 0;
    public static final int LF_FAIL = 1;

    public static void SetHostProductId(String productId) throws LexFloatClientException {
        int status;
        int n = status = Platform.isWindows() ? LexFloatClientNative.SetHostProductId(new WString(productId)) : LexFloatClientNative.SetHostProductId(productId);
        if (0 != status) {
            throw new LexFloatClientException(status);
        }
    }

    public static void SetHostUrl(String hostUrl) throws LexFloatClientException {
        int status;
        int n = status = Platform.isWindows() ? LexFloatClientNative.SetHostUrl(new WString(hostUrl)) : LexFloatClientNative.SetHostUrl(hostUrl);
        if (0 != status) {
            throw new LexFloatClientException(status);
        }
    }

    public static void AddLicenseCallbackListener(LicenseCallbackEvent listener) throws LexFloatClientException {
        int status;
        if (listeners == null) {
            listeners = new ArrayList<LicenseCallbackEvent>();
            listeners.add(listener);
        }
        if (privateCallback == null && 0 != (status = LexFloatClientNative.SetFloatingLicenseCallback(privateCallback = new LexFloatClientNative.CallbackType(){

            @Override
            public void invoke(int status) {
                for (LicenseCallbackEvent event : listeners) {
                    event.LicenseCallback(status);
                }
            }
        }))) {
            throw new LexFloatClientException(status);
        }
    }

    public static void SetFloatingClientMetadata(String key, String value) throws LexFloatClientException {
        int status;
        int n = status = Platform.isWindows() ? LexFloatClientNative.SetFloatingClientMetadata(new WString(key), new WString(value)) : LexFloatClientNative.SetFloatingClientMetadata(key, value);
        if (0 != status) {
            throw new LexFloatClientException(status);
        }
    }

    public static String GetHostProductVersionName() throws LexFloatClientException, UnsupportedEncodingException {
        int status;
        if (Platform.isWindows()) {
            CharBuffer buffer = CharBuffer.allocate(256);
            status = LexFloatClientNative.GetHostProductVersionName(buffer, 256);
            if (0 == status) {
                return buffer.toString().trim();
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(256);
            status = LexFloatClientNative.GetHostProductVersionName(buffer, 256);
            if (0 == status) {
                return new String(buffer.array(), "UTF-8").trim();
            }
        }
        throw new LexFloatClientException(status);
    }

    public static String GetHostProductVersionDisplayName() throws LexFloatClientException, UnsupportedEncodingException {
        int status;
        if (Platform.isWindows()) {
            CharBuffer buffer = CharBuffer.allocate(256);
            status = LexFloatClientNative.GetHostProductVersionDisplayName(buffer, 256);
            if (0 == status) {
                return buffer.toString().trim();
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(256);
            status = LexFloatClientNative.GetHostProductVersionDisplayName(buffer, 256);
            if (0 == status) {
                return new String(buffer.array(), "UTF-8").trim();
            }
        }
        throw new LexFloatClientException(status);
    }

    public static HostProductVersionFeatureFlag GetHostProductVersionFeatureFlag(String name) throws LexFloatClientException, UnsupportedEncodingException {
        int status;
        IntByReference enabled = new IntByReference(0);
        if (Platform.isWindows()) {
            CharBuffer buffer = CharBuffer.allocate(256);
            status = LexFloatClientNative.GetHostProductVersionFeatureFlag(new WString(name), enabled, buffer, 256);
            if (0 == status) {
                return new HostProductVersionFeatureFlag(name, enabled.getValue() > 0, buffer.toString().trim());
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(256);
            status = LexFloatClientNative.GetHostProductVersionFeatureFlag(name, enabled, buffer, 256);
            if (0 == status) {
                return new HostProductVersionFeatureFlag(name, enabled.getValue() > 0, new String(buffer.array(), "UTF-8").trim());
            }
        }
        throw new LexFloatClientException(status);
    }

    public static String GetHostLicenseMetadata(String key) throws LexFloatClientException, UnsupportedEncodingException {
        int status;
        if (Platform.isWindows()) {
            CharBuffer buffer = CharBuffer.allocate(256);
            status = LexFloatClientNative.GetHostLicenseMetadata(new WString(key), buffer, 256);
            if (0 == status) {
                return buffer.toString().trim();
            }
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(256);
            status = LexFloatClientNative.GetHostLicenseMetadata(key, buffer, 256);
            if (0 == status) {
                return new String(buffer.array(), "UTF-8");
            }
        }
        throw new LexFloatClientException(status);
    }

    public static HostLicenseMeterAttribute GetHostLicenseMeterAttribute(String name) throws LexFloatClientException, UnsupportedEncodingException {
        int status;
        IntByReference allowedUses = new IntByReference(0);
        IntByReference totalUses = new IntByReference(0);
        IntByReference grossUses = new IntByReference(0);
        if (Platform.isWindows() ? 0 == (status = LexFloatClientNative.GetHostLicenseMeterAttribute(new WString(name), allowedUses, totalUses, grossUses)) : 0 == (status = LexFloatClientNative.GetHostLicenseMeterAttribute(name, allowedUses, totalUses, grossUses))) {
            return new HostLicenseMeterAttribute(name, allowedUses.getValue(), totalUses.getValue(), grossUses.getValue());
        }
        throw new LexFloatClientException(status);
    }

    public static int GetHostLicenseExpiryDate() throws LexFloatClientException {
        IntByReference expiryDate = new IntByReference(0);
        int status = LexFloatClientNative.GetHostLicenseExpiryDate(expiryDate);
        switch (status) {
            case 0: {
                return expiryDate.getValue();
            }
        }
        throw new LexFloatClientException(status);
    }

    public static int GetFloatingClientMeterAttributeUses(String name) throws LexFloatClientException, UnsupportedEncodingException {
        int status;
        IntByReference uses = new IntByReference(0);
        if (Platform.isWindows() ? 0 == (status = LexFloatClientNative.GetFloatingClientMeterAttributeUses(new WString(name), uses)) : 0 == (status = LexFloatClientNative.GetFloatingClientMeterAttributeUses(name, uses))) {
            return uses.getValue();
        }
        throw new LexFloatClientException(status);
    }

    public static void RequestFloatingLicense() throws LexFloatClientException {
        int status = LexFloatClientNative.RequestFloatingLicense();
        if (0 != status) {
            throw new LexFloatClientException(status);
        }
    }

    public static void DropFloatingLicense() throws LexFloatClientException {
        int status = LexFloatClientNative.DropFloatingLicense();
        if (0 != status) {
            throw new LexFloatClientException(status);
        }
    }

    public static boolean HasFloatingLicense() throws LexFloatClientException {
        int status = LexFloatClientNative.HasFloatingLicense();
        switch (status) {
            case 0: {
                return true;
            }
            case 45: {
                return false;
            }
        }
        throw new LexFloatClientException(status);
    }

    public static void IncrementFloatingClientMeterAttributeUses(String name, int increment) throws LexFloatClientException, UnsupportedEncodingException {
        if (Platform.isWindows()) {
            int status = LexFloatClientNative.IncrementFloatingClientMeterAttributeUses(new WString(name), increment);
            if (0 != status) {
                throw new LexFloatClientException(status);
            }
        } else {
            int status = LexFloatClientNative.IncrementFloatingClientMeterAttributeUses(name, increment);
            if (0 != status) {
                throw new LexFloatClientException(status);
            }
        }
    }

    public static void DecrementFloatingClientMeterAttributeUses(String name, int decrement) throws LexFloatClientException, UnsupportedEncodingException {
        if (Platform.isWindows()) {
            int status = LexFloatClientNative.DecrementFloatingClientMeterAttributeUses(new WString(name), decrement);
            if (0 != status) {
                throw new LexFloatClientException(status);
            }
        } else {
            int status = LexFloatClientNative.DecrementFloatingClientMeterAttributeUses(name, decrement);
            if (0 != status) {
                throw new LexFloatClientException(status);
            }
        }
    }

    public static void ResetFloatingClientMeterAttributeUses(String name) throws LexFloatClientException, UnsupportedEncodingException {
        if (Platform.isWindows()) {
            int status = LexFloatClientNative.ResetFloatingClientMeterAttributeUses(new WString(name));
            if (0 != status) {
                throw new LexFloatClientException(status);
            }
        } else {
            int status = LexFloatClientNative.ResetFloatingClientMeterAttributeUses(name);
            if (0 != status) {
                throw new LexFloatClientException(status);
            }
        }
    }
}

