/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen.window;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.station.screen.window.WindowConfiguration;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import java.awt.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScreenDockWindowHandle
implements PlaceholderListItem<Dockable> {
    private ScreenDockWindow window;
    private WindowConfiguration configuration;
    private Dockable dockable;

    public ScreenDockWindowHandle(Dockable dockable, ScreenDockWindow window, WindowConfiguration configuration) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        if (window == null) {
            throw new IllegalArgumentException("window must not be null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("configuration must not be null");
        }
        this.dockable = dockable;
        this.window = window;
        this.configuration = configuration;
    }

    @Override
    public Dockable asDockable() {
        return this.dockable;
    }

    public void setDockable(Dockable dockable) {
        this.dockable = dockable;
        this.window.setDockable(dockable);
    }

    public ScreenDockWindow getWindow() {
        return this.window;
    }

    public WindowConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setWindow(ScreenDockWindow window, WindowConfiguration configuration) {
        this.window.setDockable(null);
        this.window = window;
        this.configuration = configuration;
        window.setDockable(this.dockable);
    }

    public Rectangle getBounds() {
        Rectangle result = null;
        if (this.window != null) {
            if (this.window.isFullscreen()) {
                result = this.window.getNormalBounds();
            }
            if (result == null) {
                result = this.window.getWindowBounds();
            }
        }
        return result;
    }
}

