/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.Arrays;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.Group;
import org.jogamp.java3d.GroupRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.OrderedGroupRetained;
import org.jogamp.java3d.RestrictedAccessException;
import org.jogamp.java3d.SharedGroup;

public class OrderedGroup
extends Group {
    private boolean[] checkArr = null;
    public static final int ALLOW_CHILD_INDEX_ORDER_READ = 17;
    public static final int ALLOW_CHILD_INDEX_ORDER_WRITE = 18;
    private static final int[] readCapabilities = new int[]{17};

    public OrderedGroup() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public void setChildIndexOrder(int[] childIndexOrder) {
        this.verifyChildIndexOrderArray(childIndexOrder, 0);
        ((OrderedGroupRetained)this.retained).setChildIndexOrder(childIndexOrder);
    }

    public int[] getChildIndexOrder() {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrderedGroup5"));
        }
        return ((OrderedGroupRetained)this.retained).getChildIndexOrder();
    }

    public void addChild(Node child, int[] childIndexOrder) {
        this.verifyAddStates(child);
        this.verifyChildIndexOrderArray(childIndexOrder, 1);
        ((OrderedGroupRetained)this.retained).addChild(child, childIndexOrder);
    }

    @Override
    public void addChild(Node child) {
        super.addChild(child);
    }

    @Override
    public void insertChild(Node child, int index) {
        if (((OrderedGroupRetained)this.retained).userChildIndexOrder != null) {
            throw new IllegalStateException(J3dI18N.getString("OrderedGroup6"));
        }
        super.insertChild(child, index);
    }

    @Override
    public void removeChild(int index) {
        super.removeChild(index);
    }

    @Override
    public void moveTo(BranchGroup branchGroup) {
        super.moveTo(branchGroup);
    }

    @Override
    public void removeChild(Node child) {
        super.removeChild(child);
    }

    @Override
    public void removeAllChildren() {
        super.removeAllChildren();
    }

    @Override
    void createRetained() {
        this.retained = new OrderedGroupRetained();
        this.retained.setSource(this);
    }

    void verifyAddStates(Node child) {
        if (child instanceof SharedGroup) {
            throw new IllegalArgumentException(J3dI18N.getString("Group2"));
        }
        if (this.isLiveOrCompiled()) {
            if (!(child instanceof BranchGroup)) {
                throw new RestrictedAccessException(J3dI18N.getString("Group12"));
            }
            if (!this.getCapability(14)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Group16"));
            }
        }
    }

    void verifyChildIndexOrderArray(int[] cIOArr, int plus) {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrderedGroup4"));
        }
        if (cIOArr != null) {
            if (cIOArr.length != ((GroupRetained)this.retained).children.size() + plus) {
                throw new IllegalArgumentException(J3dI18N.getString("OrderedGroup0"));
            }
            if (this.checkArr == null || this.checkArr.length != cIOArr.length) {
                this.checkArr = new boolean[cIOArr.length];
            }
            Arrays.fill(this.checkArr, false);
            for (int i = 0; i < cIOArr.length; ++i) {
                if (cIOArr[i] < 0) {
                    throw new IllegalArgumentException(J3dI18N.getString("OrderedGroup1"));
                }
                if (cIOArr[i] >= cIOArr.length) {
                    throw new IllegalArgumentException(J3dI18N.getString("OrderedGroup2"));
                }
                if (this.checkArr[cIOArr[i]]) {
                    throw new IllegalArgumentException(J3dI18N.getString("OrderedGroup3"));
                }
                this.checkArr[cIOArr[i]] = true;
            }
        }
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        OrderedGroup og = new OrderedGroup();
        og.duplicateNode(this, forceDuplicate);
        return og;
    }
}

