/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class ToolbarLineBorder
implements Border {
    private BasicDockableDisplayer displayer;

    public ToolbarLineBorder(BasicDockableDisplayer basicDockableDisplayer) {
        this.displayer = basicDockableDisplayer;
    }

    private DockableDisplayer.Location hiddenSide() {
        if (this.displayer.getTitle() == null) {
            return null;
        }
        return this.displayer.getTitleLocation();
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        DockableDisplayer.Location location = this.hiddenSide();
        graphics.setColor(component.getForeground());
        if (location != DockableDisplayer.Location.BOTTOM) {
            graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
        }
        if (location != DockableDisplayer.Location.TOP) {
            graphics.drawLine(n, n2, n + n3 - 1, n2);
        }
        if (location != DockableDisplayer.Location.LEFT) {
            graphics.drawLine(n, n2, n, n2 + n4 - 1);
        }
        if (location != DockableDisplayer.Location.RIGHT) {
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
        }
    }

    @Override
    public Insets getBorderInsets(Component component) {
        Insets insets = new Insets(1, 1, 1, 1);
        DockableDisplayer.Location location = this.hiddenSide();
        if (location != null) {
            switch (location) {
                case BOTTOM: {
                    insets.bottom = 0;
                    break;
                }
                case TOP: {
                    insets.top = 0;
                    break;
                }
                case LEFT: {
                    insets.left = 0;
                    break;
                }
                case RIGHT: {
                    insets.right = 0;
                }
            }
        }
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

