/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.title;

import bibliothek.gui.Dockable;
import bibliothek.gui.ToolbarExtension;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.title.AbstractDockTitle;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;

public class ToolbarDockTitleRoundedBound
extends AbstractDockTitle {
    private final Color color;

    public static DockTitleFactory createFactory(final Color color) {
        return new DockTitleFactory(){

            @Override
            public void uninstall(DockTitleRequest dockTitleRequest) {
            }

            @Override
            public void request(DockTitleRequest dockTitleRequest) {
                dockTitleRequest.answer(new ToolbarDockTitleRoundedBound(dockTitleRequest.getVersion(), dockTitleRequest.getTarget(), color));
            }

            @Override
            public void install(DockTitleRequest dockTitleRequest) {
            }
        };
    }

    public ToolbarDockTitleRoundedBound(DockTitleVersion dockTitleVersion, Dockable dockable, Color color) {
        super(dockable, dockTitleVersion, true);
        this.color = color;
    }

    @Override
    protected BasicTitleViewItem<JComponent> createItemFor(DockAction dockAction, Dockable dockable) {
        return dockable.getController().getActionViewConverter().createView(dockAction, ToolbarExtension.TOOLBAR_TITLE, dockable);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.max(5, dimension.width), Math.max(5, dimension.height));
    }

    @Override
    public void setActive(boolean bl) {
        super.setActive(bl);
        this.repaint();
    }

    @Override
    public void paintBackground(Graphics graphics, JComponent jComponent) {
        super.paintComponents(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.color);
        if (this.getOrientation().isHorizontal()) {
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight() * 2, 8.0, 8.0);
            graphics2D.fill(double_);
        } else {
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, this.getWidth() * 2, this.getHeight(), 8.0, 8.0);
            graphics2D.fill(double_);
        }
    }
}

