/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.focus;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.focus.FocusHistory;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Filter;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFocusHistory
implements FocusHistory {
    private DockController controller;
    private List<Dockable> history = new LinkedList<Dockable>();
    private List<Dockable> unfocused = new LinkedList<Dockable>();
    private Listener listener = new Listener();

    public void setController(DockController controller) {
        if (this.controller != null) {
            this.controller.getRegister().removeDockRegisterListener(this.listener);
            this.controller.getFocusController().removeDockableFocusListener(this.listener);
        }
        this.history.clear();
        this.controller = controller;
        if (this.controller != null) {
            this.controller.getRegister().addDockRegisterListener(this.listener);
            this.controller.getFocusController().addDockableFocusListener(this.listener);
        }
    }

    @Override
    public Dockable[] getHistory() {
        Dockable[] result = new Dockable[this.unfocused.size() + this.history.size()];
        int index = 0;
        for (Dockable dockable : this.unfocused) {
            result[index++] = dockable;
        }
        index = result.length - 1;
        for (Dockable item : this.history) {
            result[index--] = item;
        }
        return result;
    }

    @Override
    public Dockable getNewestOn(DockStation ... parents) {
        for (Dockable item : this.history) {
            for (DockStation station : parents) {
                if (item == station || !DockUtilities.isAncestor(station, item)) continue;
                return item;
            }
        }
        return null;
    }

    @Override
    public Dockable getFirst(Filter<Dockable> filter) {
        for (Dockable dockable : this.history) {
            if (!filter.includes(dockable)) continue;
            return dockable;
        }
        return null;
    }

    private class Listener
    extends DockRegisterAdapter
    implements DockableFocusListener {
        private Listener() {
        }

        public void dockableUnregistered(DockController controller, Dockable dockable) {
            DefaultFocusHistory.this.history.remove(dockable);
            DefaultFocusHistory.this.unfocused.remove(dockable);
        }

        public void dockableRegistered(DockController controller, Dockable dockable) {
            if (!DefaultFocusHistory.this.unfocused.contains(dockable) && !DefaultFocusHistory.this.history.contains(dockable)) {
                DefaultFocusHistory.this.unfocused.add(dockable);
            }
        }

        public void dockableFocused(DockableFocusEvent event) {
            Dockable owner = event.getNewFocusOwner();
            if (owner != null) {
                DefaultFocusHistory.this.unfocused.remove(owner);
                DefaultFocusHistory.this.history.remove(owner);
                DefaultFocusHistory.this.history.add(0, owner);
            }
        }
    }
}

