$(document).ready(function () {
	console.log("[FORM] Load optional_fields.js"); // DEBUG
	// show optional fields depending on the type of the ticket selected
	$("#ticket_type").change(function (e) {
		console.log("[FORM] Ticket Type changed");
		optional_fields(e.currentTarget);
	});

	// lowerCase and remove accent of a string
	function to_class_format(str_to_normalize) {
		return str_to_normalize.toLowerCase().replace(/[\u0300-\u036f]/g, "");
	}

	function optional_fields(eventTarget) {
		let selected_class = to_class_format(
			$("option:selected", eventTarget).val()
		);
		let subbox = $(".subbox");
		if (subbox.length) {
			subbox.each(function () {
				if ($(this).hasClass("type_" + selected_class)) {
					$(this).show(250); // is the display speed in ms
					$("input, select", this).prop("disabled", false);
				} else {
					$(this).hide(250); // is the hide speed in ms
					$("input, select", this).prop("disabled", true);
				}
			});
		}
	}

	optional_fields($("#ticket_type"));
});
