/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.BehaviorStructure;
import org.jogamp.java3d.J3dClock;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.VirtualUniverse;
import org.jogamp.java3d.WakeupCriterion;

public final class WakeupOnElapsedTime
extends WakeupCriterion {
    long wait;
    long triggeredTime;

    public WakeupOnElapsedTime(long milliseconds) {
        if (milliseconds <= 0L) {
            throw new IllegalArgumentException(J3dI18N.getString("WakeupOnElapsedTime0"));
        }
        this.wait = milliseconds;
    }

    public long getElapsedFrameTime() {
        return this.wait;
    }

    @Override
    void addBehaviorCondition(BehaviorStructure bs) {
        this.triggeredTime = this.wait + J3dClock.currentTimeMillis();
        this.behav.wakeupArray[4] = this.behav.wakeupArray[4] + 1;
        this.behav.wakeupMask |= 0x10;
        VirtualUniverse.mc.timerThread.add(this);
    }

    @Override
    void removeBehaviorCondition(BehaviorStructure bs) {
        this.behav.wakeupArray[4] = this.behav.wakeupArray[4] - 1;
        if (this.behav.wakeupArray[4] == 0) {
            this.behav.wakeupMask &= 0xFFFFFFEF;
        }
        VirtualUniverse.mc.timerThread.remove(this);
    }

    @Override
    void reInsertElapseTimeCond() {
        super.reInsertElapseTimeCond();
        this.triggeredTime = this.wait + J3dClock.currentTimeMillis();
        VirtualUniverse.mc.timerThread.add(this);
    }

    @Override
    void resetBehaviorCondition(BehaviorStructure bs) {
        this.triggeredTime = this.wait + J3dClock.currentTimeMillis();
        VirtualUniverse.mc.timerThread.add(this);
    }
}

