/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.menu;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupHeader;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupHeaderFactory;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenu;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenuCallback;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenuContent;
import bibliothek.gui.dock.util.icon.DockIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class CustomizationButton
implements ToolbarGroupHeaderFactory {
    private DockController controller;
    private CustomizationMenu menu;
    private CustomizationMenuContent content;

    public CustomizationButton(DockController dockController) {
        this.controller = dockController;
    }

    @Override
    public ToolbarGroupHeader create(ToolbarGroupDockStation toolbarGroupDockStation) {
        return new Button(toolbarGroupDockStation);
    }

    public void setMenu(CustomizationMenu customizationMenu) {
        if (this.menu != null) {
            this.menu.close();
            this.menu.setController(null);
        }
        this.menu = customizationMenu;
        if (customizationMenu != null) {
            customizationMenu.setController(this.controller);
            customizationMenu.setContent(this.content);
        }
    }

    public void setContent(CustomizationMenuContent customizationMenuContent) {
        if (this.menu != null) {
            this.menu.setContent(customizationMenuContent);
        }
        this.content = customizationMenuContent;
    }

    protected class Button
    implements ToolbarGroupHeader,
    CustomizationMenuCallback {
        private JToggleButton toggle;
        private Orientation orientation;
        private boolean open = false;
        private ToolbarGroupDockStation station;
        private boolean mousePressed = false;
        private DockIcon toolIcon = new DockIcon("toolbar.customization.preferences", DockIcon.KIND_ICON){

            @Override
            protected void changed(Icon icon, Icon icon2) {
                if (Button.this.toggle != null) {
                    Button.this.toggle.setIcon(icon2);
                }
            }
        };

        public Button(ToolbarGroupDockStation toolbarGroupDockStation) {
            this.station = toolbarGroupDockStation;
            this.toolIcon.setController(CustomizationButton.this.controller);
            this.toggle = new JToggleButton();
            this.toggle.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.toggle.setIcon((Icon)this.toolIcon.value());
            this.toggle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Button.this.toggle.isSelected()) {
                        Button.this.showMenu();
                    } else if (Button.this.open) {
                        CustomizationButton.this.menu.close();
                    }
                }
            });
            this.toggle.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    Button.this.mousePressed = true;
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiersEx() & 0x1C00) == 0) {
                        Button.this.mousePressed = false;
                    }
                }
            });
        }

        @Override
        public void destroy() {
            this.toolIcon.setController(null);
        }

        private void showMenu() {
            if (CustomizationButton.this.menu == null) {
                throw new IllegalStateException("there is no menu set");
            }
            Point point = new Point(0, 0);
            SwingUtilities.convertPointToScreen(point, this.toggle);
            if (this.orientation == Orientation.HORIZONTAL) {
                point.y += this.toggle.getHeight();
            } else {
                point.x += this.toggle.getWidth();
            }
            this.open = true;
            CustomizationButton.this.menu.open(point.x, point.y, this);
        }

        @Override
        public Component getComponent() {
            return this.toggle;
        }

        @Override
        public void setOrientation(Orientation orientation) {
            this.orientation = orientation;
        }

        @Override
        public Rectangle getButton() {
            Point point = new Point(0, 0);
            SwingUtilities.convertPointToScreen(point, this.toggle);
            return new Rectangle(point, this.toggle.getSize());
        }

        @Override
        public Component getParent() {
            return this.toggle;
        }

        @Override
        public DockStation getOwner() {
            return this.station;
        }

        @Override
        public void append(Dockable dockable) {
            DockStation dockStation = this.station;
            while (true) {
                if (dockStation.getDockableCount() == 0) {
                    dockStation.drop(dockable);
                    return;
                }
                Dockable dockable2 = dockStation.getDockable(dockStation.getDockableCount() - 1);
                if (dockable2.asDockStation() == null) break;
                dockStation = dockable2.asDockStation();
            }
            dockStation.drop(dockable);
        }

        @Override
        public boolean isAutoCloseAllowed() {
            return !this.mousePressed;
        }

        @Override
        public void closed() {
            this.open = false;
            this.toggle.setSelected(false);
        }
    }
}

