/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.AuralAttributes;
import org.jogamp.java3d.BoundingLeaf;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.Leaf;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.NodeReferenceTable;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.SoundscapeRetained;

public class Soundscape
extends Leaf {
    public static final int ALLOW_APPLICATION_BOUNDS_READ = 12;
    public static final int ALLOW_APPLICATION_BOUNDS_WRITE = 13;
    public static final int ALLOW_ATTRIBUTES_READ = 14;
    public static final int ALLOW_ATTRIBUTES_WRITE = 15;
    private static final int[] readCapabilities = new int[]{12, 14};

    public Soundscape() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public Soundscape(Bounds region, AuralAttributes attributes) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((SoundscapeRetained)this.retained).setApplicationBounds(region);
        ((SoundscapeRetained)this.retained).setAuralAttributes(attributes);
    }

    @Override
    void createRetained() {
        this.retained = new SoundscapeRetained();
        this.retained.setSource(this);
    }

    public void setApplicationBounds(Bounds region) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Soundscape0"));
        }
        ((SoundscapeRetained)this.retained).setApplicationBounds(region);
    }

    public Bounds getApplicationBounds() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Soundscape1"));
        }
        return ((SoundscapeRetained)this.retained).getApplicationBounds();
    }

    public void setApplicationBoundingLeaf(BoundingLeaf region) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Soundscape0"));
        }
        ((SoundscapeRetained)this.retained).setApplicationBoundingLeaf(region);
    }

    public BoundingLeaf getApplicationBoundingLeaf() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Soundscape1"));
        }
        return ((SoundscapeRetained)this.retained).getApplicationBoundingLeaf();
    }

    public void setAuralAttributes(AuralAttributes attributes) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Soundscape4"));
        }
        ((SoundscapeRetained)this.retained).setAuralAttributes(attributes);
    }

    public AuralAttributes getAuralAttributes() {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Soundscape5"));
        }
        return ((SoundscapeRetained)this.retained).getAuralAttributes();
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        Soundscape s = new Soundscape();
        s.duplicateNode(this, forceDuplicate);
        return s;
    }

    @Override
    public void duplicateNode(Node originalNode, boolean forceDuplicate) {
        this.checkDuplicateNode(originalNode, forceDuplicate);
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        SoundscapeRetained attr = (SoundscapeRetained)originalNode.retained;
        SoundscapeRetained rt = (SoundscapeRetained)this.retained;
        rt.setApplicationBounds(attr.getApplicationBounds());
        rt.setAuralAttributes((AuralAttributes)this.getNodeComponent(attr.getAuralAttributes(), forceDuplicate, originalNode.nodeHashtable));
        rt.setApplicationBoundingLeaf(attr.getApplicationBoundingLeaf());
    }

    @Override
    public void updateNodeReferences(NodeReferenceTable referenceTable) {
        SoundscapeRetained rt = (SoundscapeRetained)this.retained;
        BoundingLeaf bl = rt.getApplicationBoundingLeaf();
        if (bl != null) {
            SceneGraphObject o = referenceTable.getNewObjectReference(bl);
            rt.setApplicationBoundingLeaf((BoundingLeaf)o);
        }
    }
}

