/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.menu;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenu;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenuCallback;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenuContent;
import java.awt.Component;

public abstract class AbstractCustomizationMenu
implements CustomizationMenu {
    private int x;
    private int y;
    private CustomizationMenuContent content;
    private CustomizationMenuCallback callback;
    private DockController controller;

    @Override
    public CustomizationMenuContent getContent() {
        return this.content;
    }

    @Override
    public void setContent(CustomizationMenuContent customizationMenuContent) {
        if (this.content != customizationMenuContent) {
            if (this.isOpen()) {
                CustomizationMenuCallback customizationMenuCallback = this.getCallback();
                this.close();
                if (this.content != null) {
                    this.content.setController(null);
                }
                this.content = customizationMenuContent;
                if (customizationMenuContent != null) {
                    customizationMenuContent.setController(this.controller);
                    this.open(this.x, this.y, customizationMenuCallback);
                }
            } else {
                if (this.content != null) {
                    this.content.setController(null);
                }
                this.content = customizationMenuContent;
                if (customizationMenuContent != null) {
                    customizationMenuContent.setController(this.controller);
                }
            }
        }
    }

    @Override
    public void setController(DockController dockController) {
        this.controller = dockController;
        if (this.content != null) {
            this.content.setController(dockController);
        }
    }

    public DockController getController() {
        return this.controller;
    }

    public boolean isOpen() {
        return this.callback != null;
    }

    public CustomizationMenuCallback getCallback() {
        return this.callback;
    }

    @Override
    public void open(int n, int n2, CustomizationMenuCallback customizationMenuCallback) {
        if (customizationMenuCallback == null) {
            throw new IllegalArgumentException();
        }
        if (this.content == null) {
            throw new IllegalStateException("the menu has no content and cannot be opened");
        }
        if (this.callback != null) {
            this.close();
        }
        this.callback = customizationMenuCallback;
        this.content.bind(customizationMenuCallback);
        this.x = n;
        this.y = n2;
        this.doOpen(n, n2, this.content.getView());
    }

    @Override
    public void close() {
        this.doClose();
        this.closed();
    }

    protected void closed() {
        if (this.callback != null) {
            this.callback.closed();
            this.callback = null;
            if (this.content != null) {
                this.content.unbind();
            }
        }
    }

    protected abstract void doOpen(int var1, int var2, Component var3);

    protected abstract void doClose();
}

