/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap.layer;

import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.station.flap.FlapWindow;
import bibliothek.gui.dock.station.layer.DefaultDropLayer;
import bibliothek.gui.dock.station.layer.LayerPriority;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Component;
import java.awt.Point;
import javax.swing.SwingUtilities;

public class FlapOverrideDropLayer
extends DefaultDropLayer {
    private FlapDockStation station;

    public FlapOverrideDropLayer(FlapDockStation station) {
        super(station);
        this.station = station;
        this.setPriority(LayerPriority.OVERRIDE_PRECISE);
    }

    public boolean contains(int x, int y) {
        if (super.contains(x, y)) {
            DockTitle title;
            if (this.station.isOverButtons(x, y)) {
                return true;
            }
            FlapWindow window = this.station.getFlapWindow();
            if (window != null && window.isWindowVisible() && (title = window.getDockTitle()) != null) {
                Component titleComponent = title.getComponent();
                Point point = new Point(x, y);
                SwingUtilities.convertPointFromScreen(point, titleComponent);
                if (titleComponent.contains(point)) {
                    return true;
                }
            }
        }
        return false;
    }
}

