/*
#ifndef __OPENCL_VERSION__ //This should fail during an actual openCL compile, used only to trick Eclipse into syntax highlighting this file as "C" code.
#define __kernel
#define __global
#define kernel
#define global
#define constant
#define local
#define float2 float
#define int3 int
#define float3 float
#define float4 float
#define uchar4 char
#endif
*/

//Solves a linear system of the form A.X = b
//using Gaussian elimination with partial pivoting method.


bool solve(float* A, float* b, float* x, int n) 
{
    // Elimination
    for (int k = 0; k < n - 1; k++) 
    {
        // Trouver le pivot partiel
        int pivot_row = k;
        float max_val = fabs(A[k * n + k]);
        for (int i = k + 1; i < n; i++) 
        {
            float val = fabs(A[i * n + k]);
            if (val > max_val) 
            {
                max_val = val;
                pivot_row = i;
            }
        }

        // Vérifier si la matrice est singulière
        if (fabs(max_val) < 1e-6) 
        {
            // La matrice est singulière, gestion de l'exception
            return false;
        }

        // Échanger les lignes si nécessaire
        if (pivot_row != k) 
        {
            for (int j = k; j < n; j++) 
            {
                float temp = A[k * n + j];
                A[k * n + j] = A[pivot_row * n + j];
                A[pivot_row * n + j] = temp;
            }
            float temp = b[k];
            b[k] = b[pivot_row];
            b[pivot_row] = temp;
        }

        // Elimination
        for (int i = k + 1; i < n; i++) 
        {
            float factor = A[i * n + k] / A[k * n + k];
            for (int j = k; j < n; j++) 
                A[i * n + j] -= factor * A[k * n + j];
            b[i] -= factor * b[k];
        }
    }

    // Vérifier si la dernière valeur de la diagonale est nulle
    if (fabs(A[(n - 1) * n + (n - 1)]) < 1e-6) 
    {
        // La matrice est singulière, gestion de l'exception
        return false;
    }

    // Résolution arrière
    for (int i = n - 1; i >= 0; i--) 
    {
        float sum = 0.0;
        for (int j = i + 1; j < n; j++) 
            sum += A[i * n + j] * x[j];
        x[i] = (b[i] - sum) / A[i * n + i];
    }
    return true;
}
