#version 130
#extension GL_EXT_gpu_shader4 : enable

#define PI 3.14159265359

attribute float a_fIntensity; //1 float per 3D point (worker)
attribute float a_fClashDistance;
attribute int a_f_iNormalPacked;
attribute int a_f_iSegmentationPacked;

uniform float u_fShowIntensity; //Global 0-1 mixes the RGB and intensity (grayscale)
uniform float u_fAmplitude; //Global 0-1 mixes the actual RGB colors with collision distance colors
uniform float u_hasNormals;//should be boolean
uniform float u_hasSegmentation;//should be boolean

uniform ivec2 u_iv2FrameSize; //[horizontal,vertical] span pixel counts.
uniform float u_near; //distance to near clipping plane
//uniform float u_far; //distance to far clipping plane
uniform float u_imPlateWidthInMeters; //the full horizontal width of the imag plate
uniform float u_pointSizeInMeters;//meters!
uniform float u_farPointSizeInMeters;//meters!
uniform float u_adaptSize;//bool!
uniform float u_decaySize;//bool!
uniform float u_ptSizeRatio;// user-defined fudge

//clashes
uniform float u_hasGpuFlags;//should be boolean
uniform float u_shouldBlendClashes;//should be boolean
uniform float[6] u_clashThresholds01;// user-defined ranges (starts at zero)
uniform vec3[6] u_clashColors;// user-defined colors
uniform int u_numColors;// number of user-defined colors

uniform int u_budgetPts; //Maximum number of points allowed

//out float fClashDistance;
flat out vec4 v4Color;
flat out vec4 actual_color;
flat out float flag;
flat out int normalPacked;
flat out int segmentationPacked;
flat out float doDisc;

flat out float near;
flat out float far;
flat out float pointSize;
flat out float z;
flat out float circleMax;

const float radius = 1.0;
const float minPointSize = 2.0;//px!
const float maxPointSize = 10.0;//px!
const float epsilon = .6;//exponent!

const float sqrt2 = 1.4142135;


float distanceFromZDepth(float z, float n, float f)
{
	return (n * f / (z * (n - f) + f));
}

float getPhongIntensity(in vec4 material, in vec3 lightIntensity, in vec3 N, in vec3 L, in vec3 V)
{
	float matka = material.x;
	float matkd = material.y;
	float matks = material.z;
	float matshininess = material.w;
	//matka (ambiant), matkd (diffuse), matks (specular) : material component constant value between 0 to 1 (proportion de lumière renvoyée par le matériau)
	//matshininess : material shininess - can take any value (10, 100 even more)
	
	float ia = lightIntensity.x;
	float id = lightIntensity.y;
	float is = lightIntensity.z;
	//ia (ambiant), id (diffuse), is (specular) : intensité de lumière incidente

	//N : normale locale à la surface (normalisé)
	//L : vecteur surface->lumière (normalisé)
	//V : vecteur surface->oeil (normalisé)

	//Soir R la direction dans laquelle seraiot réfléchie la lumière sur un miroir
	float dotLN = dot(N, L);
	vec3 R = 2.0 * dotLN * N - L;


	//Soit Ia, Id, Is les composantes ambiante, diffuse et spéculaire
	float Ia = ia * matka;

	//De la même manière que le Soleil chauffe plus au zénith, 
	//Id est maximale lorsque la lumière arrive sur la surface selon la direction normale, c'est-à-dire L = N
	float Id = id * matkd * dotLN;

	float dotRV = dot(R, V);

	//Si V = R, Is est maximale. Plus matshininess est grand plus les taches lumineuses seront petites.
	float Is = is * matks * pow(dotRV, matshininess);

	//L'intensité réfléchie totale est ainsi :
	float I = Ia + Id + Is;

	//Pour plusieurs sources lumineuses, on obtient comme formule complète :
	//I = Ia + somme_sur_n( Id(n) + Is(n))

	return I;
}

float getEyeBasicShaderIntensity(in vec3 N, in vec3 V, in float scalHedge)
{
	float Imax = 1.5;
	float Imin = 0.0;
	float scalImax = -1;
	float scalImin = -0.1;

	float scal = dot(N, V);
	float m = (Imax-Imin)/(scalImax-scalImin);
	float I = Imin + m * (scal-scalImin);
	if (scal>scalHedge && scal<-scalHedge)
		I = 0;
	return (I);
}

void main(void) {

	near = u_near;
	//far = u_far;


	vec4 wPos = gl_ModelViewMatrix * gl_Vertex;

	////gl_Position = gl_ProjectionMatrix * wPos;


	flag = a_fClashDistance;
	//vec3 min = vec3(-106.55049133300781, -7.918942451477051, 475.066650390625);
	//vec3 max = vec3(-74.55049133300781, 24.081058502197266, 507.066650390625);
	//vec3 span = max - min;
	actual_color = vec4(mix(gl_Color.rgb, vec3(a_fIntensity), u_fShowIntensity), 1.0);
	doDisc = 0;	

	normalPacked = a_f_iNormalPacked;
	
	segmentationPacked = a_f_iSegmentationPacked;
	if (u_hasSegmentation > 0.5)
	{
	
		int status = (segmentationPacked & 0xffff);
		int formId = (segmentationPacked >> 16) & 0xffff;
		if ( ( status & 0x10 ) != 0){//possible cylinder
			actual_color *= vec4(0.0, 1.0, 0.0, 1.0);
			//doDisc = 1;
		}else if( ( status & 0x01) != 0) {//flat
			actual_color *= vec4(1.0, 0.0, 0.0, 1.0);
			//doDisc = 1;
		}else {
			doDisc = 1;
		}
	}
	

	circleMax = 1.0f;
	if(u_adaptSize > 0.5f){
		float onePlusEpsilon = 1 + epsilon;

		float imW = u_imPlateWidthInMeters;
		float imWP = u_iv2FrameSize.x;
		
		
		float imHP = u_iv2FrameSize.y;
		float imAreaP = u_iv2FrameSize.x * u_iv2FrameSize.y;
		
		//u_pointSizeInMeters est la taille la plus fine que peut prendre le point
		//On calcule un cas semi-nominal où on regarde un mur à une distance proche
		//On dispose d'un budget de points 'budgetPts'
		//Question : quelle taille en mètres doivent avoir les points si on souhaite 
		//qu'il n'y ait pas de trou dans le mur quand on le regarde
		//Sachant que le monde n'est pas parfait :
		//   il y a aussi des points qui sont derrière (d'autres murs ou éléments d'infrastructure)
		//   donc en réalité, le mur ne peut pas en réalité utiliser la totalité du budget de points
		//   mais une partie seulement
		
		float pointSizeFudgeFactor = 0.4;
		
		//float budgetPts = 10000000.;
		float budgetPtsFudgeFactor = 0.5;
		float nbPtsWall = budgetPtsFudgeFactor * u_budgetPts;
		float distToWall = 1.;
		
		float thalesRatio = u_imPlateWidthInMeters / u_near;
		float wallWInMeters = distToWall * thalesRatio;
		float wallHInMeters = wallWInMeters * imHP / imWP;
		float wallAreaInMeters = wallWInMeters * wallHInMeters;
		float retainedPointSizeInMeters = sqrt(wallAreaInMeters / nbPtsWall);
		float sizeMeters = max(retainedPointSizeInMeters, u_pointSizeInMeters * pointSizeFudgeFactor);
	
		//float sizeMeters = u_pointSizeInMeters * pointSizeFudgeFactor;
		
		
		float distance = length(wPos.xyz);


		if(u_decaySize > .5f){
			float farSize = u_farPointSizeInMeters;
			//fudge factor : la distance à partir de laquelle les points sont agrandis
			float Dr = 0.1;
			//fudge factor : la distance à partir de laquelle les points sont au max de taille
			//float farDistance = 15.0;
			float farDistance = 25.0;
			float focusDistance = Dr;

			float ratio = clamp((distance - Dr) / ( farDistance - Dr), 0.0, 1.0);

			circleMax = mix(1.0, 2.0, ratio);
			sizeMeters = mix(sizeMeters, farSize, ratio * ratio);

			// sizeMetersProj = clamp( sizeMetersProj * pow(distance / Dr, onePlusEpsilon), sizeMetersProj, 10.0);
			// sizeMetersProj = clamp( sizeMetersProj * distance * distance / Dr, sizeMetersProj, 10.0);
		}
		float sizeMetersProj = near * sizeMeters / distance;
		float sizePixels = sizeMetersProj * imWP / imW;
		pointSize = clamp(sizePixels, minPointSize, maxPointSize);
		////wPos.z += sizeMeters;
		//wPos.z -= 0.01;
	}else{
		pointSize = 2.5f;
	}
	gl_PointSize = pointSize * (1 + 0.5 * u_ptSizeRatio);


	gl_Position = gl_ProjectionMatrix * wPos;
	
	//Décalage systématique des points afin de voir les surfaces lorsqu'elles sont collées aux points 
	//gl_Position.z += 0.00001;
	
	
	
	//gl_Position.z *= 1.000000001;
	//gl_Position.z += 0.001;
	//if (gl_Position.z>1)
	//	gl_Position.z = 1;

	//actual_color = vec4( ( gl_Position.xyz-min.xyz ) / span.xyz, 1.0);
	if(u_hasGpuFlags > 0.5) {

		//flag 1 means colliding (distance <= 0)
		//flag 0 means outside of biggest threshold


		if (flag < 0 || flag > 1.0) { //Error color
			v4Color = mix(actual_color, vec4(1.0,0.0,1.0,1.0), -flag);//MAGENTA for errors
		}else if (flag < 0.00001){ //NOT colliding
			v4Color = actual_color;
		}else{

            bool blend = u_shouldBlendClashes > 0.5;
			float normalizedDistance = 1.0 - flag;
			gl_Position.z *= .9999; //Move the points closer to the eye, so they are visible on top of their original octree cloud. Lower to 0.1 to see entirely through walls.
			vec3[] clashColors = u_clashColors;
			float previousThreshold = 0.0;
			int thresholdsLength = u_numColors;
            int indexOfColor = 0;

			for(int i = 0; i < u_numColors; i++){
				float threshold = u_clashThresholds01[i];
                bool isOver = (normalizedDistance > threshold);
				bool isOverPrev = (normalizedDistance > previousThreshold);
				if(isOverPrev && !isOver)//the thresholds NEED to be sorted
				    indexOfColor = i;
                previousThreshold = threshold;
			}

            vec3 clashColor = clashColors[indexOfColor];
            if(blend){
                vec3 previousColor = clashColors[0];
                previousThreshold = 0.0;
                if(indexOfColor >= 1){
                    previousThreshold = u_clashThresholds01[indexOfColor -1];
                    previousColor = clashColors[indexOfColor - 1];
                } 
                
                float part = normalizedDistance - previousThreshold;
                float normPart = part / (u_clashThresholds01[indexOfColor] - previousThreshold);
                clashColor = mix(previousColor, clashColors[indexOfColor], normPart);
            }
            
            v4Color = vec4(clashColor, 1.0);
		}
	}else if(u_hasNormals > 0.5 && normalPacked != 0){// we have normals
	
		float theta = (normalPacked >> 17) / pow(2.0,15);
		float phi = ((normalPacked >> 3) & ((1 << 14) -1)) / pow(2.0,14);
		int quality = normalPacked & 7;
		
		float theta_0_2PI = theta * 2 * PI;
		float phi_minPI_PI = -0.5*PI + phi * PI;
		float ct = cos(theta_0_2PI);
		float st = sin(theta_0_2PI);
		float cp = cos(phi_minPI_PI);
		float sp = sin(phi_minPI_PI);
		
		vec3 normal = vec3(-ct * cp, sp, st * cp);
		
		
		vec4 normalInViewCS = gl_ModelViewMatrix * vec4(normal, 0.0);
		normalInViewCS = normalize(normalInViewCS);
		
		
		//vec3 towards = (wPosInWorld-camPosInWorld).xyz;
		vec3 towards = wPos.xyz;
		towards = normalize(towards);
		//float scal = dot(normal, lightDir);
		float scal = dot(normalInViewCS.xyz, towards);
		
		float scalHedge = 0.1;
		if(scal > scalHedge)
			doDisc = 1;
		 
		//float Imax = 1.5;
		//float Imin = 0.0;
		//float scalImax = -1;
		//float scalImin = -0.1;
		////float intensityCorrector = Imin + (Imax-Imin)*(1-scal)/2;
		//float m = (Imax-Imin)/(scalImax-scalImin);
		//float intensityCorrector = Imin + m * (scal-scalImin);
		//if (scal>scalHedge && scal<-scalHedge)
		//	intensityCorrector = 0;
			
		float intensityCorrector = getEyeBasicShaderIntensity(normalInViewCS.xyz, towards, scalHedge);

		vec4 material = vec4(0.9, 0.1, 0.9, 1.5);
		vec3 lightIntensity = vec3(1.0, 0.5, 0.01);
		vec3 NinViewCS = normalInViewCS.xyz;
		vec3 VinViewCS = -wPos.xyz; //du point vers l'oeil
		VinViewCS = normalize(VinViewCS);

		vec3 lightPosInViewCS = vec3(0., 0., 0.);
		vec3 LinViewCS = lightPosInViewCS - wPos.xyz; //du point vers la source
		//vec3 LinViewCS = vec3(0., 0., -1.0);
		//vec3 LinViewCS = vec3(gl_LightSource[0].halfVector));
		LinViewCS = normalize(LinViewCS);
		//float intensityCorrector = getPhongIntensity(material, lightIntensity, NinViewCS, LinViewCS, VinViewCS);

		v4Color = intensityCorrector * actual_color;
		//v4Color = vec4(vec3(intensityCorrector), 1.0);
		
		//v4Color = vec4(theta, phi, 0.2, quality / 7.0);
	}else{ //Nothing to show, use the actual color
		v4Color = actual_color;
		//v4Color = vec4(vec3(0.7), 1.0);
	}

	// float ps = pointSizeInMeters * gl_ProjectionMatrix[2][2] * radius / gl_Position.w;
 //  gl_PointSize = clamp(ps, minPointSize, maxPointSize);
	// pointSize = pointSizeInMeters;
}
