/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.universe;

import java.util.HashSet;
import java.util.Set;
import org.jogamp.java3d.PhysicalBody;
import org.jogamp.java3d.PhysicalEnvironment;
import org.jogamp.java3d.View;
import org.jogamp.java3d.utils.universe.ConfigCommand;
import org.jogamp.java3d.utils.universe.ConfigObject;
import org.jogamp.java3d.utils.universe.ConfigPhysicalBody;
import org.jogamp.java3d.utils.universe.ConfigPhysicalEnvironment;
import org.jogamp.java3d.utils.universe.ConfigScreen;
import org.jogamp.java3d.utils.universe.ConfigViewPlatform;
import org.jogamp.java3d.utils.universe.Viewer;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Tuple3d;

class ConfigView
extends ConfigObject {
    View j3dView = null;
    Viewer j3dViewer = null;
    Set screens = new HashSet();
    boolean stereoEnable = false;
    boolean antialiasingEnable = false;
    PhysicalBody physicalBody = null;
    PhysicalEnvironment physicalEnvironment = null;
    private double fieldOfView = 0.7853981633974483;
    private int backClipPolicy = 3;
    private int frontClipPolicy = 3;
    private double backClipDistance = 10.0;
    private double frontClipDistance = 0.1;
    private int screenScalePolicy = 0;
    private double screenScale = 1.0;
    private boolean trackingEnable = false;
    private int viewPolicy = 0;
    private int windowEyepointPolicy = -1;
    private int windowMovementPolicy = -1;
    private int windowResizePolicy = -1;
    private boolean coeCenteringEnableSet = false;
    private boolean coeCenteringEnable = false;
    private Point3d centerEyeInCoexistence = null;
    private ConfigPhysicalBody configBody = null;
    private ConfigPhysicalEnvironment configEnv = null;
    private ConfigViewPlatform configViewPlatform = null;

    ConfigView() {
    }

    @Override
    protected void initialize(ConfigCommand command) {
    }

    @Override
    protected void setProperty(ConfigCommand command) {
        int argc = command.argc;
        Object[] argv = command.argv;
        String attr = null;
        Object val = null;
        String sval = null;
        ConfigScreen cs = null;
        if (argc != 4) {
            this.syntaxError("Incorrect number of arguments to " + command.commandName);
        }
        if (!this.isName(argv[1])) {
            this.syntaxError("The first argument to " + command.commandName + " must be the instance name");
        }
        if (!this.isName(argv[2])) {
            this.syntaxError("The second argument to " + command.commandName + " must be a property name");
        }
        attr = (String)argv[2];
        val = argv[3];
        if (attr.equals("Screen") || attr.equals("Window")) {
            if (!(val instanceof String)) {
                this.syntaxError("Value for " + attr + " must be a name");
            }
            if (!this.screens.add(cs = (ConfigScreen)this.configContainer.findConfigObject("Screen", (String)val))) {
                this.syntaxError(String.valueOf(attr) + " \"" + (String)val + "\" has already been added to " + this.instanceName);
            }
        } else if (attr.equals("ViewPlatform")) {
            if (!(val instanceof String)) {
                this.syntaxError("value for ViewPlatform  must be an instance name");
            }
            this.configViewPlatform = (ConfigViewPlatform)this.configContainer.findConfigObject("ViewPlatform", (String)val);
            this.configViewPlatform.addConfigView(this);
        } else if (attr.equals("PhysicalEnvironment")) {
            if (!(val instanceof String)) {
                this.syntaxError("value for PhysicalEnvironment must be an instance name");
            }
            this.configEnv = (ConfigPhysicalEnvironment)this.configContainer.findConfigObject("PhysicalEnvironment", (String)val);
        } else if (attr.equals("PhysicalBody")) {
            if (!(val instanceof String)) {
                this.syntaxError("value for PhysicalBody must be an instance name");
            }
            this.configBody = (ConfigPhysicalBody)this.configContainer.findConfigObject("PhysicalBody", (String)val);
        } else if (attr.equals("BackClipPolicy")) {
            if (!(val instanceof String)) {
                this.syntaxError("value for BackClipPolicy must be a string");
            }
            if ((sval = (String)val).equals("PHYSICAL_EYE")) {
                this.backClipPolicy = 3;
            } else if (sval.equals("PHYSICAL_SCREEN")) {
                this.backClipPolicy = 1;
            } else if (sval.equals("VIRTUAL_EYE")) {
                this.backClipPolicy = 2;
            } else if (sval.equals("VIRTUAL_SCREEN")) {
                this.backClipPolicy = 0;
            } else {
                this.syntaxError("Invalid value for BackClipPolicy " + sval);
            }
        } else if (attr.equals("FrontClipPolicy")) {
            if (!(val instanceof String)) {
                this.syntaxError("value for FrontClipPolicy must be a string");
            }
            if ((sval = (String)val).equals("PHYSICAL_EYE")) {
                this.frontClipPolicy = 3;
            } else if (sval.equals("PHYSICAL_SCREEN")) {
                this.frontClipPolicy = 1;
            } else if (sval.equals("VIRTUAL_EYE")) {
                this.frontClipPolicy = 2;
            } else if (sval.equals("VIRTUAL_SCREEN")) {
                this.frontClipPolicy = 0;
            } else {
                this.syntaxError("Invalid value for FrontClipPolicy " + sval);
            }
        } else if (attr.equals("ScreenScalePolicy")) {
            if (!(val instanceof String)) {
                this.syntaxError("value for ScreenScalePolicy must be a string");
            }
            if ((sval = (String)val).equals("SCALE_SCREEN_SIZE")) {
                this.screenScalePolicy = 0;
            } else if (sval.equals("SCALE_EXPLICIT")) {
                this.screenScalePolicy = 1;
            } else {
                this.syntaxError("Invalid value for ScreenScalePolicy " + sval);
            }
        } else if (attr.equals("FieldOfView")) {
            if (!(val instanceof Double)) {
                this.syntaxError("value for FieldOfView must be a number");
            }
            this.fieldOfView = (Double)val;
        } else if (attr.equals("BackClipDistance")) {
            if (!(val instanceof Double)) {
                this.syntaxError("value for BackClipDistance must be a number");
            }
            this.backClipDistance = (Double)val;
        } else if (attr.equals("FrontClipDistance")) {
            if (!(val instanceof Double)) {
                this.syntaxError("value for FrontClipDistance must be a number");
            }
            this.frontClipDistance = (Double)val;
        } else if (attr.equals("ScreenScale")) {
            if (!(val instanceof Double)) {
                this.syntaxError("value for ScreenScale must be a number");
            }
            this.screenScale = (Double)val;
        } else if (attr.equals("TrackingEnable")) {
            if (!(val instanceof Boolean)) {
                this.syntaxError("value for TrackingEnable must be a boolean");
            }
            this.trackingEnable = (Boolean)val;
        } else if (attr.equals("CoexistenceCenteringEnable")) {
            if (!(val instanceof Boolean)) {
                this.syntaxError("value for CoexistenceCenteringEnable must be a boolean");
            }
            this.coeCenteringEnable = (Boolean)val;
            this.coeCenteringEnableSet = true;
        } else if (attr.equals("ViewPolicy")) {
            if (!(val instanceof String)) {
                this.syntaxError("value for ViewPolicy must be a string");
            }
            if ((sval = (String)val).equals("SCREEN_VIEW")) {
                this.viewPolicy = 0;
            } else if (sval.equals("HMD_VIEW")) {
                this.viewPolicy = 1;
            } else {
                this.syntaxError("Invalid value for ViewPolicy " + sval);
            }
        } else if (attr.equals("WindowEyepointPolicy")) {
            if (!(val instanceof String)) {
                this.syntaxError("value for WindowEyepointPolicy must be a string");
            }
            if ((sval = (String)val).equals("RELATIVE_TO_SCREEN")) {
                this.windowEyepointPolicy = 0;
            } else if (sval.equals("RELATIVE_TO_COEXISTENCE")) {
                this.windowEyepointPolicy = 3;
            } else if (sval.equals("RELATIVE_TO_WINDOW")) {
                this.windowEyepointPolicy = 1;
            } else if (sval.equals("RELATIVE_TO_FIELD_OF_VIEW")) {
                this.windowEyepointPolicy = 2;
            } else {
                this.syntaxError("Invalid value for WindowEyepointPolicy " + sval);
            }
        } else if (attr.equals("WindowMovementPolicy")) {
            if (!(val instanceof String)) {
                this.syntaxError("value for WindowEyeMovementPolicy must be a string");
            }
            if ((sval = (String)val).equals("VIRTUAL_WORLD")) {
                this.windowMovementPolicy = 0;
            } else if (sval.equals("PHYSICAL_WORLD")) {
                this.windowMovementPolicy = 1;
            } else {
                this.syntaxError("Invalid value for WindowMovementPolicy " + sval);
            }
        } else if (attr.equals("WindowResizePolicy")) {
            if (!(val instanceof String)) {
                this.syntaxError("value for WindowResizePolicy must be a string");
            }
            if ((sval = (String)val).equals("VIRTUAL_WORLD")) {
                this.windowResizePolicy = 0;
            } else if (sval.equals("PHYSICAL_WORLD")) {
                this.windowResizePolicy = 1;
            } else {
                this.syntaxError("Invalid value for WindowResizePolicy " + sval);
            }
        } else if (attr.equals("CenterEyeInCoexistence")) {
            if (val instanceof Point3d) {
                this.centerEyeInCoexistence = (Point3d)val;
            } else {
                this.syntaxError("value for CenterEyeInCoexistence must be a Point3d");
            }
        } else if (attr.equals("StereoEnable")) {
            if (!(val instanceof Boolean)) {
                this.syntaxError("value for StereoEnable must be a boolean");
            }
            this.stereoEnable = (Boolean)val;
        } else if (attr.equals("AntialiasingEnable")) {
            if (!(val instanceof Boolean)) {
                this.syntaxError("value for AntialiasingEnable must be a boolean");
            }
            this.antialiasingEnable = (Boolean)val;
        } else {
            this.syntaxError("Unknown " + command.commandName + " \"" + attr + "\"");
        }
    }

    protected Viewer createViewer(boolean setVisible) {
        this.j3dView = new View();
        this.j3dView.setViewPolicy(this.viewPolicy);
        this.physicalBody = this.configBody == null ? new PhysicalBody() : this.configBody.j3dPhysicalBody;
        this.physicalEnvironment = this.configEnv == null ? new PhysicalEnvironment() : this.configEnv.j3dPhysicalEnvironment;
        this.j3dView.setPhysicalBody(this.physicalBody);
        this.j3dView.setPhysicalEnvironment(this.physicalEnvironment);
        boolean standardDefaults = true;
        if (this.coeCenteringEnableSet && !this.coeCenteringEnable) {
            standardDefaults = false;
        }
        if (this.configEnv != null && this.configEnv.coexistenceToTrackerBase != null) {
            standardDefaults = false;
        } else {
            for (ConfigScreen s : this.screens) {
                if (s.trackerBaseToImagePlate == null) continue;
                standardDefaults = false;
                break;
            }
        }
        if (standardDefaults) {
            if (this.windowEyepointPolicy == -1) {
                this.windowEyepointPolicy = 2;
            }
            if (this.windowMovementPolicy == -1) {
                this.windowMovementPolicy = 1;
            }
            if (this.windowResizePolicy == -1) {
                this.windowResizePolicy = 1;
            }
            if (!this.coeCenteringEnableSet) {
                this.coeCenteringEnable = true;
            }
        } else {
            if (this.windowEyepointPolicy == -1) {
                this.windowEyepointPolicy = 3;
            }
            if (this.windowMovementPolicy == -1) {
                this.windowMovementPolicy = 0;
            }
            if (this.windowResizePolicy == -1) {
                this.windowResizePolicy = 0;
            }
            if (!this.coeCenteringEnableSet) {
                this.coeCenteringEnable = false;
            }
        }
        this.j3dView.setWindowEyepointPolicy(this.windowEyepointPolicy);
        this.j3dView.setWindowMovementPolicy(this.windowMovementPolicy);
        this.j3dView.setWindowResizePolicy(this.windowResizePolicy);
        this.j3dView.setCoexistenceCenteringEnable(this.coeCenteringEnable);
        if (this.centerEyeInCoexistence == null) {
            this.centerEyeInCoexistence = new Point3d(0.0, 0.0, 0.4572);
        }
        Point3d leftEyeCoe = new Point3d(this.centerEyeInCoexistence);
        Point3d rightEyeCoe = new Point3d(this.centerEyeInCoexistence);
        if (this.stereoEnable) {
            Point3d leftEyeBody = new Point3d();
            Point3d rightEyeBody = new Point3d();
            this.physicalBody.getLeftEyePosition(leftEyeBody);
            this.physicalBody.getRightEyePosition(rightEyeBody);
            leftEyeCoe.add((Tuple3d)leftEyeBody);
            rightEyeCoe.add((Tuple3d)rightEyeBody);
        }
        this.j3dView.setLeftManualEyeInCoexistence(leftEyeCoe);
        this.j3dView.setRightManualEyeInCoexistence(rightEyeCoe);
        this.j3dView.setBackClipPolicy(this.backClipPolicy);
        this.j3dView.setFrontClipPolicy(this.frontClipPolicy);
        this.j3dView.setBackClipDistance(this.backClipDistance);
        this.j3dView.setFrontClipDistance(this.frontClipDistance);
        this.j3dView.setScreenScalePolicy(this.screenScalePolicy);
        this.j3dView.setScreenScale(this.screenScale);
        this.j3dView.setFieldOfView(this.fieldOfView);
        this.j3dView.setTrackingEnable(this.trackingEnable);
        this.j3dView.setSceneAntialiasingEnable(this.antialiasingEnable);
        if (this.screens.size() == 0) {
            throw new IllegalStateException(ConfigView.errorMessage(this.creatingCommand, "View \"" + this.instanceName + "\" has no canvases or screens"));
        }
        ConfigScreen[] cs = new ConfigScreen[this.screens.size()];
        this.screens.toArray(cs);
        this.j3dViewer = new Viewer(cs, this, setVisible);
        return this.j3dViewer;
    }
}

