/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.ToolbarItem;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.dockable.AbstractDockable;
import bibliothek.gui.dock.dockable.DockableBackgroundComponent;
import bibliothek.gui.dock.dockable.DockableIcon;
import bibliothek.gui.dock.station.OrientationObserver;
import bibliothek.gui.dock.station.toolbar.ToolbarStrategy;
import bibliothek.gui.dock.toolbar.expand.ExpandableStateController;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItem;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItemListener;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.gui.dock.toolbar.item.ComponentItem;
import bibliothek.gui.dock.toolbar.item.DockActionItem;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPanel;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.SilentPropertyValue;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.gui.dock.util.icon.DockIcon;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.event.MouseInputListener;

public class ToolbarItemDockable
extends AbstractDockable
implements ExpandableToolbarItem {
    private BackgroundPanel content;
    private CardLayout contentLayout;
    private final List<ExpandableToolbarItemListener> expandableListeners = new ArrayList<ExpandableToolbarItemListener>();
    private ExpandedState state = ExpandedState.SHRUNK;
    private final ToolbarItem[] items = new ToolbarItem[ExpandedState.values().length];
    private final List<MouseInputListener> mouseListeners = new ArrayList<MouseInputListener>();
    private Orientation orientation = Orientation.HORIZONTAL;
    private Background background = new Background();

    public ToolbarItemDockable() {
        this((ToolbarItem)null, null, null);
    }

    public ToolbarItemDockable(Icon icon) {
        this((ToolbarItem)null, null, icon);
    }

    public ToolbarItemDockable(String string) {
        this((ToolbarItem)null, string, null);
    }

    public ToolbarItemDockable(DockAction dockAction) {
        this(dockAction, null, null);
    }

    public ToolbarItemDockable(Component component) {
        this(component, null, null);
    }

    public ToolbarItemDockable(ToolbarItem toolbarItem) {
        this(toolbarItem, null, null);
    }

    public ToolbarItemDockable(DockAction dockAction, Icon icon) {
        this(dockAction, null, icon);
    }

    public ToolbarItemDockable(Component component, Icon icon) {
        this(component, null, icon);
    }

    public ToolbarItemDockable(ToolbarItem toolbarItem, Icon icon) {
        this(toolbarItem, null, icon);
    }

    public ToolbarItemDockable(DockAction dockAction, String string) {
        this(dockAction, string, null);
    }

    public ToolbarItemDockable(Component component, String string) {
        this(component, string, null);
    }

    public ToolbarItemDockable(ToolbarItem toolbarItem, String string) {
        this(toolbarItem, string, null);
    }

    public ToolbarItemDockable(DockAction dockAction, String string, Icon icon) {
        super(PropertyKey.DOCKABLE_TITLE, PropertyKey.DOCKABLE_TOOLTIP);
        this.init(string, icon);
        this.setAction(dockAction, ExpandedState.SHRUNK);
    }

    public ToolbarItemDockable(Component component, String string, Icon icon) {
        super(PropertyKey.DOCKABLE_TITLE, PropertyKey.DOCKABLE_TOOLTIP);
        this.init(string, icon);
        this.setComponent(component, ExpandedState.SHRUNK);
    }

    public ToolbarItemDockable(ToolbarItem toolbarItem, String string, Icon icon) {
        super(PropertyKey.DOCKABLE_TITLE, PropertyKey.DOCKABLE_TOOLTIP);
        this.init(string, icon);
        this.setItem(toolbarItem, ExpandedState.SHRUNK);
    }

    private void init(String string, Icon icon) {
        this.contentLayout = new CardLayout(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Dimension preferredLayoutSize(Container container) {
                Object object = container.getTreeLock();
                synchronized (object) {
                    ToolbarItem toolbarItem = ToolbarItemDockable.this.getNearestComponent(ToolbarItemDockable.this.state);
                    if (toolbarItem == null) {
                        return new Dimension(10, 10);
                    }
                    return toolbarItem.getComponent().getPreferredSize();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Dimension minimumLayoutSize(Container container) {
                Object object = container.getTreeLock();
                synchronized (object) {
                    ToolbarItem toolbarItem = ToolbarItemDockable.this.getNearestComponent(ToolbarItemDockable.this.state);
                    if (toolbarItem == null) {
                        return new Dimension(10, 10);
                    }
                    return toolbarItem.getComponent().getMinimumSize();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Dimension maximumLayoutSize(Container container) {
                Object object = container.getTreeLock();
                synchronized (object) {
                    ToolbarItem toolbarItem = ToolbarItemDockable.this.getNearestComponent(ToolbarItemDockable.this.state);
                    if (toolbarItem == null) {
                        return new Dimension(10, 10);
                    }
                    return toolbarItem.getComponent().getMaximumSize();
                }
            }
        };
        this.content = new ConfiguredBackgroundPanel((LayoutManager)this.contentLayout, Transparency.SOLID);
        this.content.setFocusable(false);
        this.content.setFocusTraversalPolicyProvider(true);
        this.content.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.content.setBackground(this.background);
        new ExpandableStateController(this);
        new OrientationObserver(this){

            @Override
            protected void orientationChanged(Orientation orientation) {
                ToolbarItemDockable.this.orientation = orientation;
                for (ToolbarItem toolbarItem : ToolbarItemDockable.this.items) {
                    if (toolbarItem == null) continue;
                    toolbarItem.setOrientation(orientation);
                }
            }
        };
        this.setTitleIcon(icon);
        this.setTitleText(string);
    }

    @Override
    protected DockComponentRootHandler createRootHandler() {
        return new DockComponentRootHandler(this){

            @Override
            protected DockComponentRootHandler.TraverseResult shouldTraverse(Component component) {
                if (component == ToolbarItemDockable.this.content) {
                    return DockComponentRootHandler.TraverseResult.EXCLUDE_CHILDREN;
                }
                return DockComponentRootHandler.TraverseResult.INCLUDE_CHILDREN;
            }
        };
    }

    private ToolbarItem getNearestComponent(ExpandedState expandedState) {
        int n;
        if (this.getController() == null) {
            return null;
        }
        for (n = expandedState.ordinal(); n >= 0; --n) {
            if (this.items[n] == null) continue;
            return this.items[n];
        }
        for (n = expandedState.ordinal() + 1; n < this.items.length; ++n) {
            if (this.items[n] == null) continue;
            return this.items[n];
        }
        return null;
    }

    private ExpandedState getNearestState(ExpandedState expandedState) {
        ToolbarItem toolbarItem = this.getNearestComponent(expandedState);
        if (toolbarItem == null) {
            return null;
        }
        for (ExpandedState expandedState2 : ExpandedState.values()) {
            if (this.items[expandedState2.ordinal()] != toolbarItem) continue;
            return expandedState2;
        }
        return null;
    }

    @Override
    public void addMouseInputListener(MouseInputListener mouseInputListener) {
        super.addMouseInputListener(mouseInputListener);
        this.mouseListeners.add(mouseInputListener);
        ToolbarItem toolbarItem = this.getCurrentItem();
        if (toolbarItem != null) {
            toolbarItem.addMouseInputListener(mouseInputListener);
        }
    }

    @Override
    public void removeMouseInputListener(MouseInputListener mouseInputListener) {
        super.removeMouseInputListener(mouseInputListener);
        this.mouseListeners.remove(mouseInputListener);
        ToolbarItem toolbarItem = this.getCurrentItem();
        if (toolbarItem != null) {
            toolbarItem.removeMouseInputListener(mouseInputListener);
        }
    }

    public void setAction(DockAction dockAction, ExpandedState expandedState) {
        if (dockAction == null) {
            this.setItem(null, expandedState);
        } else {
            this.setItem(new DockActionItem(dockAction), expandedState);
        }
    }

    public void setComponent(Component component, ExpandedState expandedState) {
        if (component == null) {
            this.setItem(null, expandedState);
        } else {
            this.setItem(new ComponentItem(component), expandedState);
        }
    }

    public void setItem(ToolbarItem toolbarItem, ExpandedState expandedState) {
        boolean bl;
        if (toolbarItem != null) {
            toolbarItem.setOrientation(this.orientation);
        }
        ToolbarItem toolbarItem2 = this.items[expandedState.ordinal()];
        boolean bl2 = this.isEnabled(expandedState);
        if (toolbarItem2 != toolbarItem) {
            if (toolbarItem != null) {
                toolbarItem.setDockable(this);
            }
            if (this.getController() == null) {
                this.items[expandedState.ordinal()] = toolbarItem;
            } else {
                MouseInputListener mouseInputListener;
                Object object;
                ToolbarItem toolbarItem3 = this.getCurrentItem();
                if (toolbarItem3 != null && toolbarItem3 == toolbarItem2) {
                    toolbarItem3.setSelected(false);
                    object = this.mouseListeners.iterator();
                    while (object.hasNext()) {
                        mouseInputListener = (MouseInputListener)object.next();
                        toolbarItem3.removeMouseInputListener(mouseInputListener);
                    }
                }
                if (toolbarItem2 != null) {
                    this.content.remove(toolbarItem2.getComponent());
                    toolbarItem2.unbind();
                    toolbarItem2.setController(null);
                }
                this.items[expandedState.ordinal()] = toolbarItem;
                if (toolbarItem != null) {
                    toolbarItem.setController(this.getController());
                    toolbarItem.bind();
                    this.content.add(toolbarItem.getComponent(), expandedState.toString());
                    toolbarItem3 = this.getCurrentItem();
                    if (toolbarItem3 != null && toolbarItem3 == toolbarItem) {
                        toolbarItem3.setSelected(true);
                        object = this.mouseListeners.iterator();
                        while (object.hasNext()) {
                            mouseInputListener = (MouseInputListener)object.next();
                            toolbarItem3.addMouseInputListener(mouseInputListener);
                        }
                    } else {
                        toolbarItem.setSelected(false);
                    }
                }
                if ((object = this.getNearestState(this.state)) != null) {
                    this.contentLayout.show(this.content, ((Enum)object).toString());
                    this.content.revalidate();
                }
            }
            if (toolbarItem2 != null) {
                toolbarItem2.setDockable(null);
            }
        }
        if ((bl = this.isEnabled(expandedState)) != bl2) {
            for (ExpandableToolbarItemListener expandableToolbarItemListener : this.expandableListeners.toArray(new ExpandableToolbarItemListener[this.expandableListeners.size()])) {
                expandableToolbarItemListener.enablementChanged(this, expandedState, bl);
            }
        }
    }

    @Override
    public void setController(DockController dockController) {
        if (this.getController() != dockController) {
            Object object;
            Object object2;
            if (this.getController() != null) {
                object2 = this.getCurrentItem();
                if (object2 != null) {
                    for (MouseInputListener mouseInputListener : this.mouseListeners) {
                        object2.removeMouseInputListener(mouseInputListener);
                    }
                }
                ToolbarItem[] toolbarItemArray = this.items;
                int n = toolbarItemArray.length;
                for (int i = 0; i < n; ++i) {
                    object = toolbarItemArray[i];
                    if (object == null) continue;
                    this.content.remove(object.getComponent());
                    object.unbind();
                    object.setController(null);
                }
            }
            super.setController(dockController);
            this.background.setController(dockController);
            if (dockController != null) {
                for (ExpandedState expandedState : ExpandedState.values()) {
                    object = this.items[expandedState.ordinal()];
                    if (object == null) continue;
                    object.setController(dockController);
                    object.bind();
                    this.content.add(object.getComponent(), expandedState.toString());
                }
                object2 = this.getCurrentItem();
                if (object2 != null) {
                    for (MouseInputListener mouseInputListener : this.mouseListeners) {
                        object2.addMouseInputListener(mouseInputListener);
                    }
                }
            }
            this.forceState(this.state);
        }
    }

    @Override
    public void setExpandedState(ExpandedState expandedState) {
        if (this.state != expandedState) {
            this.forceState(expandedState);
        }
    }

    private void forceState(ExpandedState expandedState) {
        Object object;
        ExpandedState expandedState2 = this.state;
        ToolbarItem toolbarItem = this.getCurrentItem();
        this.state = expandedState;
        ToolbarItem toolbarItem2 = this.getCurrentItem();
        if (toolbarItem != toolbarItem2) {
            ExpandableToolbarItemListener[] expandableToolbarItemListenerArray;
            if (toolbarItem != null) {
                toolbarItem.setSelected(false);
                object = this.mouseListeners.iterator();
                while (object.hasNext()) {
                    expandableToolbarItemListenerArray = (ExpandableToolbarItemListener[])object.next();
                    toolbarItem.removeMouseInputListener((MouseInputListener)expandableToolbarItemListenerArray);
                }
            }
            if (toolbarItem2 != null) {
                toolbarItem2.setSelected(true);
                object = this.mouseListeners.iterator();
                while (object.hasNext()) {
                    expandableToolbarItemListenerArray = (MouseInputListener)object.next();
                    toolbarItem2.addMouseInputListener((MouseInputListener)expandableToolbarItemListenerArray);
                }
            }
        }
        if ((object = this.getNearestState(expandedState)) != null) {
            this.contentLayout.show(this.content, ((Enum)object).toString());
        }
        this.content.revalidate();
        if (expandedState2 != expandedState) {
            for (ExpandableToolbarItemListener expandableToolbarItemListener : this.expandableListeners.toArray(new ExpandableToolbarItemListener[this.expandableListeners.size()])) {
                expandableToolbarItemListener.changed(this, expandedState2, expandedState);
            }
        }
    }

    private ToolbarItem getCurrentItem() {
        return this.getNearestComponent(this.state);
    }

    @Override
    public boolean isEnabled(ExpandedState expandedState) {
        return this.items[expandedState.ordinal()] != null;
    }

    @Override
    public ExpandedState getExpandedState() {
        return this.state;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public Component getComponent() {
        return this.content;
    }

    @Override
    public void addExpandableListener(ExpandableToolbarItemListener expandableToolbarItemListener) {
        if (expandableToolbarItemListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.expandableListeners.add(expandableToolbarItemListener);
    }

    @Override
    public void removeExpandableListener(ExpandableToolbarItemListener expandableToolbarItemListener) {
        this.expandableListeners.remove(expandableToolbarItemListener);
    }

    @Override
    public DockStation asDockStation() {
        return null;
    }

    @Override
    public String getFactoryID() {
        return "ToolbarItemDockableFactory";
    }

    @Override
    protected DockIcon createTitleIcon() {
        return new DockableIcon("dockable.default", this){

            @Override
            protected void changed(Icon icon, Icon icon2) {
                ToolbarItemDockable.this.fireTitleIconChanged(icon, icon2);
            }
        };
    }

    @Override
    public boolean accept(DockStation dockStation) {
        SilentPropertyValue<ToolbarStrategy> silentPropertyValue = new SilentPropertyValue<ToolbarStrategy>(ToolbarStrategy.STRATEGY, this.getController());
        ToolbarStrategy toolbarStrategy = (ToolbarStrategy)silentPropertyValue.getValue();
        silentPropertyValue.setProperties((DockController)null);
        return toolbarStrategy.isToolbarGroupPartParent(dockStation, this, false);
    }

    @Override
    public boolean accept(DockStation dockStation, Dockable dockable) {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode());
    }

    private class Background
    extends BackgroundAlgorithm
    implements DockableBackgroundComponent {
        public Background() {
            super(DockableBackgroundComponent.KIND, "dock.background.dockable.toolbar");
        }

        @Override
        public Component getComponent() {
            return this.getDockable().getComponent();
        }

        @Override
        public Dockable getDockable() {
            return ToolbarItemDockable.this;
        }
    }
}

